/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.ObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPADListPlugin
extends DirectoryServerPlugin {
    private static final String CLASS_NAME = "org.opends.server.plugins.LDAPADListPlugin";

    public LDAPADListPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializePlugin(DirectoryServer directoryServer, Set<PluginType> set, ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(directoryServer), String.valueOf(set), String.valueOf(configEntry)));
        if (set.isEmpty()) {
            int n = 7602179;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()));
            throw new ConfigException(n, string);
        }
        for (PluginType pluginType : set) {
            if (pluginType == PluginType.PRE_PARSE_SEARCH) continue;
            int n = 0x740004;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), String.valueOf((Object)pluginType));
            throw new ConfigException(n, string);
        }
        DirectoryServer.registerSupportedFeature("1.3.6.1.4.1.4203.1.5.2");
    }

    @Override
    public PreParsePluginResult doPreParse(SearchOperation searchOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreParseSearch", String.valueOf(searchOperation)));
        LinkedHashSet<String> linkedHashSet = searchOperation.getAttributes();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (String string : linkedHashSet) {
            if (!string.startsWith("@")) continue;
            linkedHashSet2.add(string);
        }
        for (String string : linkedHashSet2) {
            ObjectClass objectClass = DirectoryServer.getObjectClass(string.substring(1, string.length()));
            linkedHashSet.remove(string);
            if (objectClass == null) {
                assert (Debug.debugMessage(DebugLogCategory.PLUGIN, DebugLogSeverity.WARNING, CLASS_NAME, "doPreSearch", "Invalid object class: " + string));
                continue;
            }
            Set<AttributeType> set = objectClass.getRequiredAttributeChain();
            Set<AttributeType> set2 = objectClass.getOptionalAttributeChain();
            assert (Debug.debugMessage(DebugLogCategory.PLUGIN, DebugLogSeverity.INFO, CLASS_NAME, "doPreParse", "Replacing object class " + String.valueOf(objectClass)));
            for (AttributeType attributeType : set) {
                linkedHashSet.add(attributeType.getNameOrOID());
            }
            for (AttributeType attributeType : set2) {
                linkedHashSet.add(attributeType.getNameOrOID());
            }
        }
        return new PreParsePluginResult();
    }
}

