/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.opends.server.api.ProtocolElement;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Constants;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1Long;
import org.opends.server.protocols.asn1.ASN1Null;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Set;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1Element
implements ProtocolElement,
Serializable {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Element";
    private static final long serialVersionUID = -6085322427222358963L;
    private byte type;
    private byte[] value;

    public ASN1Element(byte by) {
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by)));
        this.type = by;
        this.value = ASN1Constants.NO_VALUE;
    }

    public ASN1Element(byte by, byte[] byArray) {
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), StaticUtils.bytesToHex(byArray)));
        this.type = by;
        this.value = byArray == null ? ASN1Constants.NO_VALUE : byArray;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return this.type;
    }

    public void setType(byte by) {
        assert (Debug.debugEnter(CLASS_NAME, "setType", StaticUtils.byteToHex(by)));
        this.type = by;
    }

    public boolean isUniversal() {
        assert (Debug.debugEnter(CLASS_NAME, "isUniversal", new String[0]));
        return (this.type & 0xFFFFFFC0) == 0;
    }

    public boolean isApplicationSpecific() {
        assert (Debug.debugEnter(CLASS_NAME, "isApplicationSpecific", new String[0]));
        return (this.type & 0xFFFFFFC0) == 64;
    }

    public boolean isContextSpecific() {
        assert (Debug.debugEnter(CLASS_NAME, "isContextSpecific", new String[0]));
        return (this.type & 0xFFFFFFC0) == -128;
    }

    public boolean isPrivate() {
        assert (Debug.debugEnter(CLASS_NAME, "isPrivate", new String[0]));
        return (this.type & 0xFFFFFFC0) == -64;
    }

    public boolean isPrimitive() {
        assert (Debug.debugEnter(CLASS_NAME, "isPrimitive", new String[0]));
        return (this.type & 0x20) == 0;
    }

    public boolean isConstructed() {
        assert (Debug.debugEnter(CLASS_NAME, "isConstructed", new String[0]));
        return (this.type & 0x20) == 32;
    }

    public byte[] value() {
        assert (Debug.debugEnter(CLASS_NAME, "value", new String[0]));
        return this.value;
    }

    public void setValue(byte[] byArray) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", StaticUtils.bytesToHex(byArray)));
        this.value = byArray == null ? ASN1Constants.NO_VALUE : byArray;
    }

    protected final void setValueInternal(byte[] byArray) {
        assert (Debug.debugEnter(CLASS_NAME, "setValueInternal", StaticUtils.bytesToHex(byArray)));
        this.value = byArray;
    }

    public static byte[] encodeLength(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeLength", String.valueOf(n)));
        if (n < 128) {
            return new byte[]{(byte)n};
        }
        if ((n & 0xFF) == n) {
            return new byte[]{-127, (byte)(n & 0xFF)};
        }
        if ((n & 0xFFFF) == n) {
            return new byte[]{-126, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        if ((n & 0xFFFFFF) == n) {
            return new byte[]{-125, (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        return new byte[]{-124, (byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    public byte[] encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        if (this.value.length == 0) {
            return new byte[]{this.type, 0};
        }
        if (this.value.length < 128) {
            byte[] byArray = new byte[this.value.length + 2];
            byArray[0] = this.type;
            byArray[1] = (byte)this.value.length;
            System.arraycopy(this.value, 0, byArray, 2, this.value.length);
            return byArray;
        }
        byte[] byArray = ASN1Element.encodeLength(this.value.length);
        byte[] byArray2 = new byte[1 + this.value.length + byArray.length];
        byArray2[0] = this.type;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        System.arraycopy(this.value, 0, byArray2, 1 + byArray.length, this.value.length);
        return byArray2;
    }

    public static byte[] encodeValue(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(bl)));
        return bl ? ASN1Constants.BOOLEAN_VALUE_TRUE : ASN1Constants.BOOLEAN_VALUE_FALSE;
    }

    public static byte[] encodeValue(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(n)));
        if ((n & 0x7F) == n) {
            return new byte[]{(byte)(n & 0xFF)};
        }
        if ((n & Short.MAX_VALUE) == n) {
            return new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        if ((n & 0x7FFFFF) == n) {
            return new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        return new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    public static byte[] encodeLongValue(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeLongValue", String.valueOf(l)));
        if ((l & 0x7FL) == l) {
            return new byte[]{(byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFL) == l) {
            return new byte[]{(byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFL) == l) {
            return new byte[]{(byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & Integer.MAX_VALUE) == l) {
            return new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFFFFFL) == l) {
            return new byte[]{(byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFFFFFFFL) == l) {
            return new byte[]{(byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        if ((l & 0x7FFFFFFFFFFFFFL) == l) {
            return new byte[]{(byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        }
        return new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
    }

    public static byte[] encodeValue(ArrayList<ASN1Element> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(arrayList)));
        if (arrayList == null) {
            return ASN1Constants.NO_VALUE;
        }
        int n = 0;
        byte[][] byArrayArray = new byte[arrayList.size()][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = arrayList.get(i).encode();
            n += byArrayArray[i].length;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (byte[] byArray2 : byArrayArray) {
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    public static ASN1Element decode(byte[] byArray) throws ASN1Exception {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decode", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n2 = 2293761;
            String string = MessageHandler.getMessage(n2);
            throw new ASN1Exception(n2, string);
        }
        if (byArray.length < 2) {
            int n3 = 0x230002;
            String string = MessageHandler.getMessage(n3, byArray.length);
            throw new ASN1Exception(n3, string);
        }
        byte by = byArray[0];
        int n4 = byArray[1] & 0x7F;
        int n5 = 2;
        if (n4 != byArray[1]) {
            n = n4;
            if (n > 4) {
                int n6 = 0x230003;
                String string = MessageHandler.getMessage(n6, n);
                throw new ASN1Exception(n6, string);
            }
            if (byArray.length < 2 + n) {
                int n7 = 2293764;
                String string = MessageHandler.getMessage(n7, n);
                throw new ASN1Exception(n7, string);
            }
            n4 = 0;
            n5 = 2 + n;
            for (int i = 0; i < n; ++i) {
                n4 = n4 << 8 | byArray[i + 2] & 0xFF;
            }
        }
        if (byArray.length - n5 != n4) {
            n = 2293765;
            String string = MessageHandler.getMessage(n, n4, byArray.length - n5);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n5, byArray2, 0, n4);
        return new ASN1Element(by, byArray2);
    }

    public static ASN1Element decode(byte[] byArray, int n, int n2) throws ASN1Exception {
        int n3;
        assert (Debug.debugEnter(CLASS_NAME, "decode", StaticUtils.bytesToHex(byArray), String.valueOf(n), String.valueOf(n2)));
        if (byArray == null) {
            int n4 = 2293761;
            String string = MessageHandler.getMessage(n4);
            throw new ASN1Exception(n4, string);
        }
        if (n < 0 || n + n2 > byArray.length || n2 < 2) {
            int n5 = 0x230002;
            String string = MessageHandler.getMessage(n5, byArray.length);
            throw new ASN1Exception(n5, string);
        }
        byte by = byArray[n];
        int n6 = byArray[n + 1] & 0x7F;
        int n7 = n + 2;
        if (n6 != byArray[n + 1]) {
            n3 = n6;
            if (n3 > 4) {
                int n8 = 0x230003;
                String string = MessageHandler.getMessage(n8, n3);
                throw new ASN1Exception(n8, string);
            }
            if (n + n2 < 2 + n3) {
                int n9 = 2293764;
                String string = MessageHandler.getMessage(n9, n3);
                throw new ASN1Exception(n9, string);
            }
            n6 = 0;
            n7 = n + 2 + n3;
            for (int i = 0; i < n3; ++i) {
                n6 = n6 << 8 | byArray[i + 2] & 0xFF;
            }
        }
        if (n + n2 - n7 != n6) {
            n3 = 2293765;
            String string = MessageHandler.getMessage(n3, n6, n + n2 - n7);
            throw new ASN1Exception(n3, string);
        }
        byte[] byArray2 = new byte[n6];
        System.arraycopy(byArray, n7, byArray2, 0, n6);
        return new ASN1Element(by, byArray2);
    }

    public ASN1Boolean decodeAsBoolean() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsBoolean", new String[0]));
        return ASN1Boolean.decodeAsBoolean(this);
    }

    public ASN1Enumerated decodeAsEnumerated() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsEnumerated", new String[0]));
        return ASN1Enumerated.decodeAsEnumerated(this);
    }

    public ASN1Integer decodeAsInteger() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsInteger", new String[0]));
        return ASN1Integer.decodeAsInteger(this);
    }

    public ASN1Long decodeAsLong() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsLong", new String[0]));
        return ASN1Long.decodeAsLong(this);
    }

    public ASN1Null decodeAsNull() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsNull", new String[0]));
        return ASN1Null.decodeAsNull(this);
    }

    public ASN1OctetString decodeAsOctetString() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsOctetString", new String[0]));
        return ASN1OctetString.decodeAsOctetString(this);
    }

    public ASN1Sequence decodeAsSequence() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsSequence", new String[0]));
        return ASN1Sequence.decodeAsSequence(this);
    }

    public ASN1Set decodeAsSet() throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsSet", new String[0]));
        return ASN1Set.decodeAsSet(this);
    }

    public static ArrayList<ASN1Element> decodeElements(byte[] byArray) throws ASN1Exception {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeElements", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n2 = 2293766;
            String string = MessageHandler.getMessage(n2);
            throw new ASN1Exception(n2, string);
        }
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>();
        for (int i = 0; i < byArray.length; i += n) {
            int n3;
            int n4;
            byte by = byArray[i++];
            if (i >= byArray.length) {
                n4 = 2293767;
                String string = MessageHandler.getMessage(n4);
                throw new ASN1Exception(n4, string);
            }
            if ((n = (int)((n4 = byArray[i++]) & 0x7F)) != n4) {
                int n5;
                n3 = n;
                if (n3 > 4) {
                    n5 = 2293768;
                    String string = MessageHandler.getMessage(n5, n3);
                    throw new ASN1Exception(n5, string);
                }
                if (n3 > byArray.length - i) {
                    n5 = 2293769;
                    String string = MessageHandler.getMessage(n5, n3);
                    throw new ASN1Exception(n5, string);
                }
                n = 0;
                for (n5 = 0; n5 < n3; ++n5) {
                    n = n << 8 | byArray[i++] & 0xFF;
                }
            }
            if (n > byArray.length - i) {
                n3 = 2293770;
                String string = MessageHandler.getMessage(n3, n, byArray.length - i);
                throw new ASN1Exception(n3, string);
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, i, byArray2, 0, n);
            arrayList.add(new ASN1Element(by, byArray2));
        }
        return arrayList;
    }

    @Override
    public String getProtocolElementName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolElementName", new String[0]));
        return "ASN.1";
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ASN1Element)) {
            return false;
        }
        ASN1Element aSN1Element = (ASN1Element)object;
        return this.type == aSN1Element.type && Arrays.equals(this.value, aSN1Element.value);
    }

    public boolean equalsIgnoreType(ASN1Element aSN1Element) {
        assert (Debug.debugEnter(CLASS_NAME, "equalsIgnoreType", String.valueOf(aSN1Element)));
        return Arrays.equals(this.value, aSN1Element.value);
    }

    public boolean equalsIgnoreType(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "equalsIgnoreType", String.valueOf(byteString)));
        return Arrays.equals(this.value, byteString.value());
    }

    public boolean equalsElement(ASN1Element aSN1Element) {
        assert (Debug.debugEnter(CLASS_NAME, "equalsElement", String.valueOf(aSN1Element)));
        if (this == aSN1Element) {
            return true;
        }
        if (aSN1Element == null) {
            return false;
        }
        return this.type == aSN1Element.type && Arrays.equals(this.value, aSN1Element.value);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.type;
        int n2 = Math.min(20, this.value.length);
        for (int i = 0; i < n2; ++i) {
            n += this.value[i];
        }
        return n;
    }

    @Override
    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ASN1Element(type=");
        stringBuilder.append(StaticUtils.byteToHex(this.type));
        stringBuilder.append(", length=");
        stringBuilder.append(this.value.length);
        stringBuilder.append(")");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("ASN.1 Element");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  BER Type:  ");
        stringBuilder.append(StaticUtils.byteToHex(this.type));
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Value (");
        stringBuilder.append(this.value.length);
        stringBuilder.append(" bytes)");
        stringBuilder.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(stringBuilder, this.value, n + 2);
    }
}

