/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1Integer
extends ASN1Element {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Integer";
    private static final long serialVersionUID = 7352628713339746558L;
    private int intValue;

    public ASN1Integer(int n) {
        super((byte)2, ASN1Integer.encodeValue(n));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n)));
        this.intValue = n;
    }

    public ASN1Integer(byte by, int n) {
        super(by, ASN1Integer.encodeValue(n));
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), String.valueOf(n)));
        this.intValue = n;
    }

    private ASN1Integer(byte by, byte[] byArray, int n) {
        super(by, byArray);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), StaticUtils.bytesToHex(byArray), String.valueOf(n)));
        this.intValue = n;
    }

    public int intValue() {
        assert (Debug.debugEnter(CLASS_NAME, "intValue", new String[0]));
        return this.intValue;
    }

    public void setValue(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(n)));
        this.intValue = n;
        this.setValueInternal(ASN1Integer.encodeValue(n));
    }

    public void setValue(byte[] byArray) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n = 2293785;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        if (byArray.length < 1 || byArray.length > 4) {
            int n = 2293786;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
        this.intValue = 0;
        for (byte by : byArray) {
            this.intValue = this.intValue << 8 | by & 0xFF;
        }
        this.setValueInternal(byArray);
    }

    public static ASN1Integer decodeAsInteger(ASN1Element aSN1Element) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsInteger", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293787;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray = aSN1Element.value();
        if (byArray.length < 1 || byArray.length > 4) {
            int n = 2293788;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
        int n = 0;
        for (byte by : byArray) {
            n = n << 8 | by & 0xFF;
        }
        return new ASN1Integer(aSN1Element.getType(), byArray, n);
    }

    public static ASN1Integer decodeAsInteger(byte[] byArray) throws ASN1Exception {
        int n;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsInteger", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n3 = 2293789;
            String string = MessageHandler.getMessage(n3);
            throw new ASN1Exception(n3, string);
        }
        if (byArray.length < 3) {
            int n4 = 2293790;
            String string = MessageHandler.getMessage(n4, byArray.length);
            throw new ASN1Exception(n4, string);
        }
        byte by = byArray[0];
        int n5 = byArray[1] & 0x7F;
        int n6 = 2;
        if (n5 != byArray[1]) {
            n2 = n5;
            if (n2 > 4) {
                int n7 = 0x230003;
                String string = MessageHandler.getMessage(n7, n2);
                throw new ASN1Exception(n7, string);
            }
            if (byArray.length < 2 + n2) {
                int n8 = 2293764;
                String string = MessageHandler.getMessage(n8, n2);
                throw new ASN1Exception(n8, string);
            }
            n5 = 0;
            n6 = 2 + n2;
            for (n = 0; n < n2; ++n) {
                n5 = n5 << 8 | byArray[n + 2] & 0xFF;
            }
        }
        if (byArray.length - n6 != n5) {
            n2 = 2293765;
            String string = MessageHandler.getMessage(n2, n5, byArray.length - n6);
            throw new ASN1Exception(n2, string);
        }
        if (n5 < 1 || n5 > 4) {
            n2 = 2293791;
            String string = MessageHandler.getMessage(n2, n5);
            throw new ASN1Exception(n2, string);
        }
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n6, byArray2, 0, n5);
        n = 0;
        for (byte by2 : byArray2) {
            n = n << 8 | by2 & 0xFF;
        }
        return new ASN1Integer(by, byArray2, n);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ASN1Integer(type=");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(", value=");
        stringBuilder.append(this.intValue);
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("ASN.1 Integer");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  BER Type:  ");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Value:  ");
        stringBuilder.append(this.intValue);
        stringBuilder.append(" (");
        stringBuilder.append(StaticUtils.bytesToHex(this.value()));
        stringBuilder.append(")");
        stringBuilder.append(ServerConstants.EOL);
    }
}

