/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1Null
extends ASN1Element {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Null";
    private static final long serialVersionUID = 8921787912269145125L;

    public ASN1Null() {
        super((byte)5);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public ASN1Null(byte by) {
        super(by);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by)));
    }

    public void setValue(byte[] byArray) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", StaticUtils.bytesToHex(byArray)));
        if (byArray != null && byArray.length != 0) {
            int n = 2293778;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
    }

    public static ASN1Null decodeAsNull(ASN1Element aSN1Element) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsNull", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293779;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray = aSN1Element.value();
        if (byArray.length != 0) {
            int n = 2293780;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
        return new ASN1Null(aSN1Element.getType());
    }

    public static ASN1Null decodeAsNull(byte[] byArray) throws ASN1Exception {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsNull", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n2 = 2293781;
            String string = MessageHandler.getMessage(n2);
            throw new ASN1Exception(n2, string);
        }
        if (byArray.length < 2) {
            int n3 = 0x230002;
            String string = MessageHandler.getMessage(n3, byArray.length);
            throw new ASN1Exception(n3, string);
        }
        byte by = byArray[0];
        int n4 = byArray[1] & 0x7F;
        int n5 = 2;
        if (n4 != byArray[1]) {
            n = n4;
            if (n > 4) {
                int n6 = 0x230003;
                String string = MessageHandler.getMessage(n6, n);
                throw new ASN1Exception(n6, string);
            }
            if (byArray.length < 2 + n) {
                int n7 = 2293764;
                String string = MessageHandler.getMessage(n7, n);
                throw new ASN1Exception(n7, string);
            }
            n4 = 0;
            n5 = 2 + n;
            for (int i = 0; i < n; ++i) {
                n4 = n4 << 8 | byArray[i + 2] & 0xFF;
            }
        }
        if (byArray.length - n5 != n4) {
            n = 2293765;
            String string = MessageHandler.getMessage(n, n4, byArray.length - n5);
            throw new ASN1Exception(n, string);
        }
        if (n4 != 0) {
            n = 2293782;
            String string = MessageHandler.getMessage(n, n4);
            throw new ASN1Exception(n, string);
        }
        return new ASN1Null(by);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ASN1Null(type=");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("ASN.1 Null");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  BER Type:  ");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(ServerConstants.EOL);
    }
}

