/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.util.ArrayList;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.BindOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.jmx.Credential;
import org.opends.server.protocols.jmx.JmxClientConnection;
import org.opends.server.protocols.jmx.JmxConnectionHandler;
import org.opends.server.protocols.jmx.OpendsJmxPrincipal;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.ResultCode;

public class RmiAuthenticator
implements JMXAuthenticator {
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.RmiAuthenticator";
    private boolean needClientCertificate = false;
    private boolean finalizedPhase = false;
    private JmxConnectionHandler jmxConnectionHandler;

    public RmiAuthenticator(JmxConnectionHandler jmxConnectionHandler) {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.jmxConnectionHandler = jmxConnectionHandler;
    }

    public synchronized void setFinalizedPhase(boolean bl) {
        this.finalizedPhase = bl;
    }

    public Subject authenticate(Object object) {
        JmxClientConnection jmxClientConnection;
        assert (Debug.debugEnter(CLASS_NAME, "RmiAuthenticator", new String[0]));
        if (this.finalizedPhase) {
            SecurityException securityException = new SecurityException();
            throw securityException;
        }
        if (object == null) {
            SecurityException securityException = new SecurityException();
            throw securityException;
        }
        Object[] objectArray = (Object[])object;
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        if (string == null) {
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.WARNING, CLASS_NAME, "RmiAuthenticator", "User name is Null "));
            SecurityException securityException = new SecurityException();
            throw securityException;
        }
        if (string2 == null) {
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.WARNING, CLASS_NAME, "RmiAuthenticator", "User password is Null "));
            SecurityException securityException = new SecurityException();
            throw securityException;
        }
        assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.WARNING, CLASS_NAME, "RmiAuthenticator", "UserName  =" + string));
        try {
            jmxClientConnection = this.bind(string, string2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "RmiAuthenticator", exception));
            SecurityException securityException = new SecurityException();
            securityException.initCause(exception);
            throw securityException;
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new OpendsJmxPrincipal(string));
        subject.getPrivateCredentials().add(new Credential(jmxClientConnection));
        return subject;
    }

    private JmxClientConnection bind(String string, String string2) {
        DN dN;
        ArrayList<Control> arrayList = new ArrayList<Control>();
        try {
            dN = DN.decode(string);
        }
        catch (Exception exception) {
            LDAPException lDAPException = new LDAPException(49, 88, null);
            SecurityException securityException = new SecurityException();
            securityException.initCause(lDAPException);
            throw securityException;
        }
        ASN1OctetString aSN1OctetString = string2 == null ? null : new ASN1OctetString(string2);
        AuthenticationInfo authenticationInfo = new AuthenticationInfo(dN, aSN1OctetString, false);
        JmxClientConnection jmxClientConnection = new JmxClientConnection(this.jmxConnectionHandler, authenticationInfo);
        BindOperation bindOperation = new BindOperation((ClientConnection)jmxClientConnection, jmxClientConnection.nextOperationID(), jmxClientConnection.nextMessageID(), arrayList, new ASN1OctetString(string), (ByteString)aSN1OctetString);
        bindOperation.run();
        if (bindOperation.getResultCode() == ResultCode.SUCCESS) {
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "bind", "User is authenticated"));
            return jmxClientConnection;
        }
        LDAPException lDAPException = new LDAPException(49, 88, null);
        SecurityException securityException = new SecurityException("return code: " + (Object)((Object)bindOperation.getResultCode()));
        securityException.initCause(lDAPException);
        throw securityException;
    }
}

