/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

public class CompareRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.CompareRequestProtocolOp";
    private ASN1OctetString assertionValue;
    private ASN1OctetString dn;
    private String attributeType;

    public CompareRequestProtocolOp(ASN1OctetString aSN1OctetString, String string, ASN1OctetString aSN1OctetString2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(string), String.valueOf(aSN1OctetString2)));
        this.dn = aSN1OctetString;
        this.attributeType = string;
        this.assertionValue = aSN1OctetString2;
    }

    public ASN1OctetString getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.dn;
    }

    public void setDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
    }

    public String getAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", new String[0]));
        return this.attributeType;
    }

    public void setAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributeType", String.valueOf(string)));
        this.attributeType = string;
    }

    public ASN1OctetString getAssertionValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getAssertionValue", new String[0]));
        return this.assertionValue;
    }

    public void setAssertionValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setAssertionValue", String.valueOf(aSN1OctetString)));
        this.assertionValue = aSN1OctetString;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 110;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Compare Request";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(this.dn);
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(2);
        arrayList2.add(new ASN1OctetString(this.attributeType));
        arrayList2.add(this.assertionValue);
        arrayList.add(new ASN1Sequence(arrayList2));
        return new ASN1Sequence(110, arrayList);
    }

    public static CompareRequestProtocolOp decodeCompareRequest(ASN1Element aSN1Element) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        String string;
        ArrayList<ASN1Element> arrayList;
        ASN1OctetString aSN1OctetString2;
        ArrayList<ASN1Element> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeCompareRequest", String.valueOf(aSN1Element)));
        try {
            arrayList2 = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareRequest", exception));
            int n = 2293843;
            String string2 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string2, exception);
        }
        int n = arrayList2.size();
        if (n != 2) {
            int n2 = 2293844;
            String string3 = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string3);
        }
        try {
            aSN1OctetString2 = arrayList2.get(0).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareRequest", exception));
            int n3 = 2293845;
            String string4 = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string4, exception);
        }
        try {
            arrayList = arrayList2.get(1).decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareRequest", exception));
            int n4 = 2293846;
            String string5 = MessageHandler.getMessage(n4, String.valueOf(exception));
            throw new LDAPException(2, n4, string5, exception);
        }
        n = arrayList.size();
        if (n != 2) {
            int n5 = 2293847;
            String string6 = MessageHandler.getMessage(n5, n);
            throw new LDAPException(2, n5, string6);
        }
        try {
            string = arrayList.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareRequest", exception));
            int n6 = 2293848;
            String string7 = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string7, exception);
        }
        try {
            aSN1OctetString = arrayList.get(1).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareRequest", exception));
            int n7 = 2293849;
            String string8 = MessageHandler.getMessage(n7, String.valueOf(exception));
            throw new LDAPException(2, n7, string8, exception);
        }
        return new CompareRequestProtocolOp(aSN1OctetString2, string, aSN1OctetString);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("CompareRequest(dn=");
        this.dn.toString(stringBuilder);
        stringBuilder.append(", attribute=");
        stringBuilder.append(this.attributeType);
        stringBuilder.append(", value=");
        this.assertionValue.toString(stringBuilder);
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Compare Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Target DN:  ");
        this.dn.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Attribute Type:  ");
        stringBuilder.append(this.attributeType);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Assertion Value:");
        stringBuilder.append(ServerConstants.EOL);
        this.assertionValue.toString(stringBuilder, n + 4);
    }
}

