/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPControl {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPControl";
    private Control control;

    public LDAPControl(Control control) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(control)));
        this.control = control;
    }

    public LDAPControl(String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.control = new Control(string, false);
    }

    public LDAPControl(String string, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl)));
        this.control = new Control(string, bl);
    }

    public LDAPControl(String string, boolean bl, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(aSN1OctetString)));
        this.control = new Control(string, bl, aSN1OctetString);
    }

    public Control getControl() {
        assert (Debug.debugEnter(CLASS_NAME, "getControl", new String[0]));
        return this.control;
    }

    public ASN1Element encode() {
        ASN1OctetString aSN1OctetString;
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
        arrayList.add(new ASN1OctetString(this.control.getOID()));
        if (this.control.isCritical()) {
            arrayList.add(new ASN1Boolean(this.control.isCritical()));
        }
        if ((aSN1OctetString = this.control.getValue()) != null) {
            arrayList.add(aSN1OctetString);
        }
        return new ASN1Sequence(arrayList);
    }

    public static ASN1Element encodeControls(ArrayList<LDAPControl> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeControls", String.valueOf(arrayList)));
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(arrayList.size());
        for (LDAPControl lDAPControl : arrayList) {
            arrayList2.add(lDAPControl.encode());
        }
        return new ASN1Sequence(-96, arrayList2);
    }

    public static LDAPControl decode(ASN1Element aSN1Element) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        boolean bl;
        String string;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 0x230032;
            String string2 = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string2);
        }
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n = 0x230033;
            String string3 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string3, exception);
        }
        int n = arrayList.size();
        if (n < 1 || n > 3) {
            int n2 = 2293812;
            String string4 = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string4);
        }
        try {
            string = arrayList.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n3 = 2293813;
            String string5 = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string5, exception);
        }
        if (n == 1) {
            return new LDAPControl(string);
        }
        if (n == 2) {
            boolean bl2;
            ASN1OctetString aSN1OctetString2;
            ASN1Element aSN1Element2 = arrayList.get(1);
            switch (aSN1Element2.getType()) {
                case 1: {
                    aSN1OctetString2 = null;
                    try {
                        bl2 = aSN1Element2.decodeAsBoolean().booleanValue();
                        break;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "decode", exception));
                        int n4 = 2293814;
                        String string6 = MessageHandler.getMessage(n4, String.valueOf(aSN1Element2));
                        throw new LDAPException(2, n4, string6, exception);
                    }
                }
                case 4: {
                    bl2 = false;
                    try {
                        aSN1OctetString2 = aSN1Element2.decodeAsOctetString();
                        break;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "decode", exception));
                        int n5 = 2293815;
                        String string7 = MessageHandler.getMessage(n5, String.valueOf(aSN1Element2));
                        throw new LDAPException(2, n5, string7, exception);
                    }
                }
                default: {
                    int n6 = 2293816;
                    String string8 = MessageHandler.getMessage(n6, aSN1Element2.getType());
                    throw new LDAPException(2, n6, string8);
                }
            }
            return new LDAPControl(string, bl2, aSN1OctetString2);
        }
        try {
            bl = arrayList.get(1).decodeAsBoolean().booleanValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n7 = 2293814;
            String string9 = MessageHandler.getMessage(n7, String.valueOf(exception));
            throw new LDAPException(2, n7, string9, exception);
        }
        try {
            aSN1OctetString = arrayList.get(2).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n8 = 2293815;
            String string10 = MessageHandler.getMessage(n8, String.valueOf(exception));
            throw new LDAPException(2, n8, string10, exception);
        }
        return new LDAPControl(string, bl, aSN1OctetString);
    }

    public static ArrayList<LDAPControl> decodeControls(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControls", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293817;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            int n = 2293818;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        ArrayList<LDAPControl> arrayList2 = new ArrayList<LDAPControl>(arrayList.size());
        for (ASN1Element aSN1Element2 : arrayList) {
            arrayList2.add(LDAPControl.decode(aSN1Element2));
        }
        return arrayList2;
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.control.getOID();
    }

    public boolean isCritical() {
        assert (Debug.debugEnter(CLASS_NAME, "isCritical", new String[0]));
        return this.control.isCritical();
    }

    public ASN1OctetString getValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", new String[0]));
        return this.control.getValue();
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAPControl(oid=");
        stringBuilder.append(this.control.getOID());
        stringBuilder.append(", criticality=");
        stringBuilder.append(this.control.isCritical());
        ASN1OctetString aSN1OctetString = this.control.getValue();
        if (aSN1OctetString != null) {
            stringBuilder.append(", value=");
            stringBuilder.append(String.valueOf(aSN1OctetString));
        }
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("LDAP Control");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  OID:  ");
        stringBuilder.append(this.control.getOID());
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Criticality:  ");
        stringBuilder.append(this.control.isCritical());
        stringBuilder.append(ServerConstants.EOL);
        ASN1OctetString aSN1OctetString = this.control.getValue();
        if (aSN1OctetString != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Value:");
            aSN1OctetString.toString(stringBuilder, n + 4);
        }
    }
}

