/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class AuthPasswordSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.AuthPasswordSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;

    public AuthPasswordSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.4.1.4203.1.2.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "authPasswordExactMatch", "AuthenticationPasswordSyntax");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "AuthenticationPasswordSyntax";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Authentication Password Syntax";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return null;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return null;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        try {
            AuthPasswordSyntax.decodeAuthPassword(byteString.stringValue());
            return true;
        }
        catch (DirectoryException directoryException) {
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
    }

    public static StringBuilder[] decodeAuthPassword(String string) throws DirectoryException {
        char c;
        char c2;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAuthPassword", String.valueOf(string)));
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        block5: while (n < n2) {
            char c3 = string.charAt(n);
            switch (c3) {
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': {
                    stringBuilder.append(c3);
                    ++n;
                    break;
                }
                case ' ': 
                case '$': {
                    break block5;
                }
                default: {
                    int n6 = 6553843;
                    String string2 = MessageHandler.getMessage(n6, n);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n6);
                }
            }
        }
        if (stringBuilder.length() == 0) {
            int n3 = 6553844;
            String string3 = MessageHandler.getMessage(n3);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n < n2 && string.charAt(n) == '$') {
            ++n;
        } else {
            int n4 = 6553845;
            String string4 = MessageHandler.getMessage(n4);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        while (n < n2 && (c2 = string.charAt(n)) != ' ' && c2 != '$') {
            if (PrintableString.isPrintableCharacter(c2)) {
                stringBuilder2.append(c2);
                ++n;
                continue;
            }
            int n5 = 6553846;
            String string5 = MessageHandler.getMessage(n5, n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        if (stringBuilder.length() == 0) {
            int n6 = 6553847;
            String string6 = MessageHandler.getMessage(n6);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n6);
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n < n2 && string.charAt(n) == '$') {
            ++n;
        } else {
            int n7 = 6553848;
            String string7 = MessageHandler.getMessage(n7);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n7);
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        while (n < n2 && (c = string.charAt(n)) != ' ' && c != '$') {
            if (PrintableString.isPrintableCharacter(c)) {
                stringBuilder3.append(c);
                ++n;
                continue;
            }
            int n8 = 6553846;
            String string8 = MessageHandler.getMessage(n8, n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string8, n8);
        }
        if (stringBuilder.length() == 0) {
            int n9 = 6553847;
            String string9 = MessageHandler.getMessage(n9);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string9, n9);
        }
        while (n < n2) {
            char c4 = string.charAt(n);
            if (c4 == ' ') {
                ++n;
                continue;
            }
            int n10 = 6553848;
            String string10 = MessageHandler.getMessage(n10, n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string10, n10);
        }
        return new StringBuilder[]{stringBuilder, stringBuilder2, stringBuilder3};
    }

    public static boolean isEncoded(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "isEncoded", String.valueOf(byteString)));
        try {
            AuthPasswordSyntax.decodeAuthPassword(byteString.stringValue());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

