/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.HashSet;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class FaxNumberSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.FaxNumberSyntax";
    public static final HashSet<String> ALLOWED_FAX_PARAMETERS = new HashSet(7);
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public FaxNumberSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "FacsimileTelephoneNumber");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "FacsimileTelephoneNumber");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "FacsimileTelephoneNumber");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "FacsimileTelephoneNumber";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.22";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Facsimile Telephone Number";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        String string;
        int n;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string2 = StaticUtils.toLowerCase(byteString.stringValue());
        int n3 = string2.length();
        if (n3 == 0) {
            int n4 = 6488253;
            stringBuilder.append(MessageHandler.getMessage(n4));
            return false;
        }
        char c = string2.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            int n5 = 6488254;
            stringBuilder.append(MessageHandler.getMessage(n5, string2, Character.valueOf(c), 0));
            return false;
        }
        for (n2 = 1; n2 < n3; ++n2) {
            c = string2.charAt(n2);
            if (c == '$') {
                ++n2;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            n = 6488254;
            stringBuilder.append(MessageHandler.getMessage(n, string2, Character.valueOf(c), n2));
        }
        if (n2 >= n3) {
            if (c == '$') {
                n = 6488255;
                stringBuilder.append(MessageHandler.getMessage(n, string2));
                return false;
            }
            return true;
        }
        n = n2;
        while (n2 < n3) {
            if ((c = string2.charAt(n2++)) != '$') continue;
            string = string2.substring(n, n2);
            if (!ALLOWED_FAX_PARAMETERS.contains(string)) {
                int n6 = 6488256;
                stringBuilder.append(MessageHandler.getMessage(n6, string2, string, n, n2 - 1));
                return false;
            }
            n = n2;
        }
        string = string2.substring(n);
        if (!ALLOWED_FAX_PARAMETERS.contains(string)) {
            int n7 = 6488256;
            stringBuilder.append(MessageHandler.getMessage(n7, string2, string, n, n2 - 1));
            return false;
        }
        return true;
    }

    static {
        ALLOWED_FAX_PARAMETERS.add("twodimensional");
        ALLOWED_FAX_PARAMETERS.add("fineresolution");
        ALLOWED_FAX_PARAMETERS.add("unlimitedlength");
        ALLOWED_FAX_PARAMETERS.add("b4length");
        ALLOWED_FAX_PARAMETERS.add("a3width");
        ALLOWED_FAX_PARAMETERS.add("b4width");
        ALLOWED_FAX_PARAMETERS.add("uncompressed");
    }
}

