/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class IntegerSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.IntegerSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    public static final AttributeValueDecoder<Integer> DECODER = new AttributeValueDecoder<Integer>(){

        @Override
        public Integer decode(AttributeValue attributeValue) throws DirectoryException {
            ByteString byteString = attributeValue.getNormalizedValue();
            try {
                return Integer.valueOf(byteString.stringValue());
            }
            catch (NumberFormatException numberFormatException) {
                int n = 6422788;
                String string = MessageHandler.getMessage(n, byteString.stringValue());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
            }
        }
    };

    public IntegerSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.14");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.14", "Integer");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.15");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.15", "Integer");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.7");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.7", "Integer");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "Integer";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Integer";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue();
        int n = string.length();
        if (n == 0) {
            stringBuilder.append(MessageHandler.getMessage(6422574, string));
            return false;
        }
        if (n == 1) {
            switch (string.charAt(0)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return true;
                }
                case '-': {
                    int n2 = 6422575;
                    stringBuilder.append(MessageHandler.getMessage(n2, string));
                    return false;
                }
            }
            int n3 = 6422573;
            stringBuilder.append(MessageHandler.getMessage(n3, string, Character.valueOf(string.charAt(0)), 0));
            return false;
        }
        boolean bl = false;
        switch (string.charAt(0)) {
            case '0': {
                int n4 = 6422571;
                stringBuilder.append(MessageHandler.getMessage(n4, string));
                return false;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            case '-': {
                bl = true;
                break;
            }
            default: {
                int n5 = 6422573;
                stringBuilder.append(MessageHandler.getMessage(n5, string, Character.valueOf(string.charAt(0)), 0));
                return false;
            }
        }
        switch (string.charAt(1)) {
            case '0': {
                if (!bl) break;
                int n6 = 6422571;
                stringBuilder.append(MessageHandler.getMessage(n6, string));
                return false;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                int n7 = 6422573;
                stringBuilder.append(MessageHandler.getMessage(n7, string, Character.valueOf(string.charAt(0)), 0));
                return false;
            }
        }
        block16: for (int i = 2; i < n; ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block16;
                }
                default: {
                    int n8 = 6422573;
                    stringBuilder.append(MessageHandler.getMessage(n8, string, Character.valueOf(string.charAt(0)), 0));
                    return false;
                }
            }
        }
        return true;
    }
}

