/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeNumber
implements Serializable,
Comparable<ChangeNumber> {
    private static final long serialVersionUID = -8802722277749190740L;
    private long timeStamp;
    private int seqnum;
    private short serverId;

    public ChangeNumber(String string) {
        String string2 = string.substring(0, 16);
        this.timeStamp = Long.parseLong(string2, 16);
        string2 = string.substring(16, 20);
        this.seqnum = Integer.parseInt(string2, 16);
        string2 = string.substring(20, 24);
        this.serverId = Short.parseShort(string2, 16);
    }

    public ChangeNumber(long l, int n, short s) {
        this.serverId = s;
        this.timeStamp = l;
        this.seqnum = n;
    }

    public long getTime() {
        return this.timeStamp;
    }

    public long getTimeSec() {
        return this.timeStamp / 1000L;
    }

    public int getSeqnum() {
        return this.seqnum;
    }

    public short getServerId() {
        return this.serverId;
    }

    public boolean equals(Object object) {
        if (object instanceof ChangeNumber) {
            ChangeNumber changeNumber = (ChangeNumber)object;
            return this.seqnum == changeNumber.seqnum && this.serverId == changeNumber.serverId && this.timeStamp == changeNumber.timeStamp;
        }
        return false;
    }

    public int hashCode() {
        return this.seqnum + this.serverId + new Long(this.timeStamp).hashCode();
    }

    public String toString() {
        return String.format("%016x%04x%04x", this.timeStamp, this.seqnum, this.serverId);
    }

    public static int compare(ChangeNumber changeNumber, ChangeNumber changeNumber2) {
        if (changeNumber == null) {
            if (changeNumber2 == null) {
                return 0;
            }
            return -1;
        }
        if (changeNumber2 == null) {
            return 1;
        }
        if (changeNumber.timeStamp < changeNumber2.timeStamp) {
            return -1;
        }
        if (changeNumber2.timeStamp < changeNumber.timeStamp) {
            return 1;
        }
        if (changeNumber.seqnum < changeNumber2.seqnum) {
            return -1;
        }
        if (changeNumber2.seqnum < changeNumber.seqnum) {
            return 1;
        }
        if (changeNumber.serverId < changeNumber2.serverId) {
            return -1;
        }
        if (changeNumber2.serverId < changeNumber.serverId) {
            return 1;
        }
        return 0;
    }

    public Boolean older(ChangeNumber changeNumber) {
        if (ChangeNumber.compare(this, changeNumber) < 0) {
            return true;
        }
        return false;
    }

    public Boolean olderOrEqual(ChangeNumber changeNumber) {
        if (ChangeNumber.compare(this, changeNumber) <= 0) {
            return true;
        }
        return false;
    }

    public boolean newerOrEquals(ChangeNumber changeNumber) {
        return ChangeNumber.compare(this, changeNumber) >= 0;
    }

    public boolean newer(ChangeNumber changeNumber) {
        return ChangeNumber.compare(this, changeNumber) > 0;
    }

    @Override
    public int compareTo(ChangeNumber changeNumber) {
        return ChangeNumber.compare(this, changeNumber);
    }
}

