/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.synchronization.AttrInfo;
import org.opends.server.synchronization.AttrInfoWithOptions;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.FakeOperation;
import org.opends.server.synchronization.HistKey;
import org.opends.server.synchronization.HistVal;
import org.opends.server.synchronization.ModifyFakeOperation;
import org.opends.server.synchronization.OperationContext;
import org.opends.server.synchronization.ValueInfo;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Historical {
    static final String HISTORICALATTRIBUTENAME = "ds-sync-hist";
    static final AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType("ds-sync-hist");
    static final String ENTRYUIDNAME = "entryuuid";
    static final AttributeType entryuuidAttrType = DirectoryServer.getSchema().getAttributeType("entryuuid");
    private ChangeNumber moreRecentChangenumber = new ChangeNumber(0L, 0, 0);
    private HashMap<AttributeType, AttrInfoWithOptions> attributesInfo = new HashMap();

    public Historical duplicate() {
        Historical historical = new Historical();
        historical.attributesInfo = new HashMap<AttributeType, AttrInfoWithOptions>(this.attributesInfo);
        historical.moreRecentChangenumber = this.moreRecentChangenumber;
        return historical;
    }

    public void replayOperation(ModifyOperation modifyOperation, Entry entry) {
        List<Modification> list = modifyOperation.getModifications();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(modifyOperation);
        Iterator<Modification> iterator = list.iterator();
        while (iterator.hasNext()) {
            Modification modification = iterator.next();
            Attribute attribute = modification.getAttribute();
            LinkedHashSet<String> linkedHashSet = attribute.getOptions();
            if (linkedHashSet.isEmpty()) {
                linkedHashSet = null;
            }
            AttributeType attributeType = attribute.getAttributeType();
            AttrInfoWithOptions attrInfoWithOptions = this.attributesInfo.get(attributeType);
            AttrInfo attrInfo = null;
            if (attrInfoWithOptions != null) {
                attrInfo = attrInfoWithOptions.get(linkedHashSet);
            }
            if (this.hasConflict(attrInfo, changeNumber)) {
                switch (modification.getModificationType()) {
                    case DELETE: {
                        if (changeNumber.older(attrInfo.getDeleteTime()).booleanValue()) {
                            iterator.remove();
                            break;
                        }
                        this.conflictDelete(changeNumber, attributeType, modification, entry, attrInfo, attribute);
                        break;
                    }
                    case ADD: {
                        this.conflictAdd(iterator, changeNumber, attrInfo, attribute.getValues(), attribute.getOptions());
                        break;
                    }
                    case REPLACE: {
                        if (changeNumber.older(attrInfo.getDeleteTime()).booleanValue()) {
                            iterator.remove();
                            break;
                        }
                        LinkedHashSet<AttributeValue> linkedHashSet2 = attribute.getValues();
                        attribute.setValues(new LinkedHashSet<AttributeValue>());
                        this.conflictDelete(changeNumber, attributeType, modification, entry, attrInfo, attribute);
                        LinkedHashSet<AttributeValue> linkedHashSet3 = attribute.getValues();
                        this.conflictAdd(iterator, changeNumber, attrInfo, linkedHashSet2, attribute.getOptions());
                        linkedHashSet3.addAll(linkedHashSet2);
                        break;
                    }
                }
                continue;
            }
            this.processLocalOrNonConflictModification(changeNumber, modification);
        }
        if (this.moreRecentChangenumber == null || this.moreRecentChangenumber.older(changeNumber).booleanValue()) {
            this.moreRecentChangenumber = changeNumber;
        }
    }

    private void processLocalOrNonConflictModification(ChangeNumber changeNumber, Modification modification) {
        AttributeType attributeType;
        AttrInfoWithOptions attrInfoWithOptions;
        AttrInfo attrInfo;
        Attribute attribute = modification.getAttribute();
        LinkedHashSet<String> linkedHashSet = attribute.getOptions();
        if (linkedHashSet.isEmpty()) {
            linkedHashSet = null;
        }
        if ((attrInfo = (attrInfoWithOptions = this.attributesInfo.get(attributeType = attribute.getAttributeType())) != null ? attrInfoWithOptions.get(linkedHashSet) : null) == null) {
            attrInfo = new AttrInfo();
            if (attrInfoWithOptions == null) {
                attrInfoWithOptions = new AttrInfoWithOptions();
            }
            attrInfoWithOptions.put(linkedHashSet, attrInfo);
            this.attributesInfo.put(attributeType, attrInfoWithOptions);
        }
        switch (modification.getModificationType()) {
            case DELETE: {
                if (attribute.getValues().isEmpty()) {
                    attrInfo.delete(changeNumber);
                    break;
                }
                attrInfo.delete(attribute.getValues(), changeNumber);
                break;
            }
            case ADD: {
                if (attributeType.isSingleValue()) {
                    attrInfo.delete(changeNumber);
                }
                attrInfo.add(attribute.getValues(), changeNumber);
                break;
            }
            case REPLACE: {
                attrInfo.delete(changeNumber);
                attrInfo.add(attribute.getValues(), changeNumber);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateState(ModifyOperation modifyOperation) {
        void var6_10;
        List<Modification> list = modifyOperation.getModifications();
        Entry entry = modifyOperation.getModifiedEntry();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(modifyOperation);
        if (!modifyOperation.isSynchronizationOperation()) {
            for (Modification object22 : list) {
                this.processLocalOrNonConflictModification(changeNumber, object22);
            }
            if (this.moreRecentChangenumber == null || this.moreRecentChangenumber.older(changeNumber).booleanValue()) {
                this.moreRecentChangenumber = changeNumber;
            }
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Map.Entry<AttributeType, AttrInfoWithOptions> entry2 : this.attributesInfo.entrySet()) {
            AttributeType attributeType = entry2.getKey();
            HashMap<Set<String>, AttrInfo> hashMap = entry2.getValue().getAttributesInfo();
            for (Map.Entry<Set<String>, AttrInfo> entry3 : hashMap.entrySet()) {
                boolean bl = false;
                Set<String> set = entry3.getKey();
                String string = "";
                AttrInfo attrInfo = entry3.getValue();
                ChangeNumber changeNumber2 = attrInfo.getDeleteTime();
                if (set != null) {
                    for (String string2 : set) {
                        string.concat(";" + string2);
                    }
                }
                if (changeNumber2 != null) {
                    bl = true;
                }
                for (ValueInfo valueInfo : attrInfo.getValuesInfo()) {
                    AttributeValue attributeValue;
                    String string3;
                    if (valueInfo.getValueDeleteTime() != null) {
                        string3 = attributeType.getNormalizedPrimaryName() + string + ":" + valueInfo.getValueDeleteTime().toString() + ":del:" + valueInfo.getValue().toString();
                        attributeValue = new AttributeValue(historicalAttrType, string3);
                        linkedHashSet.add(attributeValue);
                        continue;
                    }
                    if (valueInfo.getValueUpdateTime() == null) continue;
                    if (bl && valueInfo.getValueUpdateTime() == changeNumber2) {
                        string3 = attributeType.getNormalizedPrimaryName() + string + ":" + valueInfo.getValueUpdateTime().toString() + ":repl:" + valueInfo.getValue().toString();
                        bl = false;
                    } else {
                        string3 = attributeType.getNormalizedPrimaryName() + string + ":" + valueInfo.getValueUpdateTime().toString() + ":add:" + valueInfo.getValue().toString();
                    }
                    attributeValue = new AttributeValue(historicalAttrType, string3);
                    linkedHashSet.add(attributeValue);
                }
                if (!bl) continue;
                String string4 = attributeType.getNormalizedPrimaryName() + string + ":" + changeNumber2.toString() + ":attrDel";
                bl = false;
                AttributeValue attributeValue = new AttributeValue(historicalAttrType, string4);
                linkedHashSet.add(attributeValue);
            }
        }
        if (linkedHashSet.isEmpty()) {
            Attribute attribute = new Attribute(historicalAttrType, HISTORICALATTRIBUTENAME, null);
        } else {
            Attribute attribute = new Attribute(historicalAttrType, HISTORICALATTRIBUTENAME, linkedHashSet);
        }
        Modification modification = new Modification(ModificationType.REPLACE, (Attribute)var6_10);
        list.add(modification);
        entry.removeAttribute(historicalAttrType);
        entry.addAttribute((Attribute)var6_10, null);
    }

    private boolean hasConflict(AttrInfo attrInfo, ChangeNumber changeNumber) {
        if (ChangeNumber.compare(changeNumber, this.moreRecentChangenumber) <= 0) {
            if (attrInfo == null) {
                return false;
            }
            return ChangeNumber.compare(changeNumber, attrInfo.getLastUpdateTime()) <= 0;
        }
        return false;
    }

    private boolean conflictDelete(ChangeNumber changeNumber, AttributeType attributeType, Modification modification, Entry entry, AttrInfo attrInfo, Attribute attribute) {
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            modification.setModificationType(ModificationType.REPLACE);
            LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>();
            Iterator<ValueInfo> iterator = attrInfo.getValuesInfo().iterator();
            while (iterator.hasNext()) {
                ValueInfo valueInfo = iterator.next();
                if (changeNumber.older(valueInfo.getValueUpdateTime()).booleanValue()) {
                    linkedHashSet2.add(valueInfo.getValue());
                    continue;
                }
                if (!changeNumber.newerOrEquals(valueInfo.getValueDeleteTime())) continue;
                iterator.remove();
            }
            attribute.setValues(linkedHashSet2);
            if (changeNumber.newer(attrInfo.getDeleteTime())) {
                attrInfo.setDeleteTime(changeNumber);
            }
            if (changeNumber.newer(attrInfo.getLastUpdateTime())) {
                attrInfo.setLastUpdateTime(changeNumber);
            }
        } else {
            ArrayList<ValueInfo> arrayList = attrInfo.getValuesInfo();
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                AttributeValue attributeValue = (AttributeValue)iterator.next();
                Boolean bl = true;
                ValueInfo valueInfo = new ValueInfo(attributeValue, null, changeNumber);
                int n = arrayList.indexOf(valueInfo);
                if (n != -1) {
                    ValueInfo valueInfo2 = arrayList.get(n);
                    if (changeNumber.newer(valueInfo2.getValueDeleteTime()) && changeNumber.newer(valueInfo2.getValueUpdateTime())) {
                        arrayList.remove(n);
                        arrayList.add(valueInfo);
                    } else if (valueInfo2.isUpdate()) {
                        bl = false;
                    }
                } else {
                    arrayList.add(valueInfo);
                }
                entry.getAttribute(attributeType);
                if (bl.booleanValue() && entry.hasValue(attributeType, attribute.getOptions(), attributeValue)) continue;
                iterator.remove();
            }
            if (changeNumber.newer(attrInfo.getLastUpdateTime())) {
                attrInfo.setLastUpdateTime(changeNumber);
            }
        }
        return true;
    }

    private boolean conflictAdd(Iterator iterator, ChangeNumber changeNumber, AttrInfo attrInfo, LinkedHashSet<AttributeValue> linkedHashSet, Set<String> set) {
        if (changeNumber.older(attrInfo.getDeleteTime()).booleanValue()) {
            iterator.remove();
            return false;
        }
        Iterator iterator2 = linkedHashSet.iterator();
        while (iterator2.hasNext()) {
            ValueInfo valueInfo;
            AttributeValue attributeValue = (AttributeValue)iterator2.next();
            ArrayList<ValueInfo> arrayList = attrInfo.getValuesInfo();
            int n = arrayList.indexOf(valueInfo = new ValueInfo(attributeValue, changeNumber, null));
            if (n == -1) {
                arrayList.add(valueInfo);
                continue;
            }
            ValueInfo valueInfo2 = arrayList.get(n);
            if (valueInfo2.isUpdate()) {
                if (changeNumber.newer(valueInfo2.getValueUpdateTime())) {
                    arrayList.remove(n);
                    arrayList.add(valueInfo);
                }
                iterator2.remove();
                continue;
            }
            if (changeNumber.newer(valueInfo2.getValueDeleteTime())) {
                arrayList.remove(n);
                arrayList.add(valueInfo);
                continue;
            }
            iterator2.remove();
        }
        if (linkedHashSet.isEmpty()) {
            iterator.remove();
        }
        if (changeNumber.newer(attrInfo.getLastUpdateTime())) {
            attrInfo.setLastUpdateTime(changeNumber);
        }
        return true;
    }

    public static Historical load(Entry entry) {
        List<Attribute> list = entry.getAttribute(historicalAttrType);
        Historical historical = new Historical();
        AttributeType attributeType = null;
        Set<String> set = null;
        AttrInfo attrInfo = null;
        AttrInfoWithOptions attrInfoWithOptions = null;
        if (list == null) {
            return historical;
        }
        for (Attribute attribute : list) {
            for (AttributeValue attributeValue : attribute.getValues()) {
                HistVal histVal = new HistVal(attributeValue.getStringValue());
                AttributeType attributeType2 = histVal.getAttrType();
                Set<String> set2 = histVal.getOptions();
                ChangeNumber changeNumber = histVal.getCn();
                AttributeValue attributeValue2 = histVal.getAttributeValue();
                HistKey histKey = histVal.getHistKey();
                if (attributeType2 == null) continue;
                if (attributeType2 != attributeType) {
                    attrInfo = new AttrInfo();
                    attrInfoWithOptions = new AttrInfoWithOptions();
                    attrInfoWithOptions.put(set2, attrInfo);
                    historical.attributesInfo.put(attributeType2, attrInfoWithOptions);
                    attributeType = attributeType2;
                    set = set2;
                } else {
                    attributeType2 = attributeType;
                    if (set2 != set) {
                        attrInfo = new AttrInfo();
                        attrInfoWithOptions.put(set2, attrInfo);
                        set = set2;
                    }
                }
                if (historical.moreRecentChangenumber.older(changeNumber).booleanValue()) {
                    historical.moreRecentChangenumber = changeNumber;
                }
                switch (histKey) {
                    case ADD: {
                        if (attributeValue2 == null) break;
                        attrInfo.add(attributeValue2, changeNumber);
                        break;
                    }
                    case DEL: {
                        if (attributeValue2 == null) break;
                        attrInfo.delete(attributeValue2, changeNumber);
                        break;
                    }
                    case REPL: {
                        attrInfo.delete(changeNumber);
                        if (attributeValue2 == null) break;
                        attrInfo.add(attributeValue2, changeNumber);
                        break;
                    }
                    case DELATTR: {
                        attrInfo.delete(changeNumber);
                    }
                }
            }
        }
        return historical;
    }

    public static Iterable<FakeOperation> generateFakeOperations(Entry entry) {
        TreeMap<ChangeNumber, ModifyFakeOperation> treeMap = new TreeMap<ChangeNumber, ModifyFakeOperation>();
        List<Attribute> list = entry.getOperationalAttribute(historicalAttrType);
        if (list != null) {
            for (Attribute attribute : list) {
                for (AttributeValue attributeValue : attribute.getValues()) {
                    HistVal histVal = new HistVal(attributeValue.getStringValue());
                    ChangeNumber changeNumber = histVal.getCn();
                    Modification modification = histVal.generateMod();
                    FakeOperation fakeOperation = (FakeOperation)treeMap.get(changeNumber);
                    if (fakeOperation != null) {
                        try {
                            fakeOperation.addModification(modification);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    String string = Historical.getEntryUuid(entry);
                    if (string == null) continue;
                    ModifyFakeOperation modifyFakeOperation = new ModifyFakeOperation(entry.getDN(), changeNumber, string);
                    modifyFakeOperation.addModification(modification);
                    treeMap.put(histVal.getCn(), modifyFakeOperation);
                }
            }
        }
        return treeMap.values();
    }

    public static String getEntryUuid(Entry entry) {
        Attribute attribute;
        String string = null;
        List<Attribute> list = entry.getOperationalAttribute(entryuuidAttrType);
        if (list != null && (attribute = list.get(0)).hasValue()) {
            AttributeValue attributeValue = (AttributeValue)attribute.getValues().iterator().next();
            string = attributeValue.getStringValue();
        }
        return string;
    }

    public static String getEntryUuid(AddOperation addOperation) {
        Attribute attribute;
        String string = null;
        Map<AttributeType, List<Attribute>> map = addOperation.getOperationalAttributes();
        List<Attribute> list = map.get(entryuuidAttrType);
        if (list != null && (attribute = list.get(0)).hasValue()) {
            AttributeValue attributeValue = (AttributeValue)attribute.getValues().iterator().next();
            string = attributeValue.getStringValue();
        }
        return string;
    }
}

