/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.Historical;
import org.opends.server.synchronization.ModifyContext;
import org.opends.server.synchronization.OperationContext;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.DN;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyMsg
extends UpdateMessage {
    private static final long serialVersionUID = -4905520652801395185L;
    private byte[] encodedMods = null;
    private byte[] encodedMsg = null;

    public ModifyMsg(ModifyOperation modifyOperation) {
        super((OperationContext)modifyOperation.getAttachment("synchronizationContext"), modifyOperation.getRawEntryDN().stringValue());
        this.encodedMods = this.modsToByte(modifyOperation.getModifications());
    }

    public ModifyMsg(ChangeNumber changeNumber, DN dN, List<Modification> list, String string) {
        super(new ModifyContext(changeNumber, string), dN.toNormalizedString());
        this.encodedMods = this.modsToByte(list);
    }

    public ModifyMsg(byte[] byArray) throws DataFormatException, UnsupportedEncodingException {
        super(byArray);
        this.encodedMsg = byArray;
    }

    @Override
    public byte[] getBytes() {
        if (this.encodedMsg == null) {
            try {
                this.encode();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        return this.encodedMsg;
    }

    @Override
    public Operation createOperation(InternalClientConnection internalClientConnection, String string) throws LDAPException, ASN1Exception, DataFormatException {
        if (this.encodedMods == null) {
            this.decode();
        }
        if (string == null) {
            string = this.getDn();
        }
        ArrayList<ASN1Element> arrayList = null;
        arrayList = ASN1Element.decodeElements(this.encodedMods);
        ArrayList<LDAPModification> arrayList2 = new ArrayList<LDAPModification>(arrayList.size());
        for (ASN1Element object2 : arrayList) {
            arrayList2.add(LDAPModification.decode(object2));
        }
        ModifyOperation modifyOperation = new ModifyOperation((ClientConnection)internalClientConnection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(string), arrayList2);
        ModifyContext modifyContext = new ModifyContext(this.getChangeNumber(), this.getUniqueId());
        modifyOperation.setAttachment("synchronizationContext", modifyContext);
        return modifyOperation;
    }

    private void encode() throws UnsupportedEncodingException {
        this.encodedMsg = this.encodeHeader((byte)1, this.encodedMods.length + 1);
        int n = this.encodedMsg.length - (this.encodedMods.length + 1);
        n = this.addByteArray(this.encodedMods, this.encodedMsg, n);
    }

    private void decode() throws DataFormatException {
        int n = this.decodeHeader((byte)1, this.encodedMsg);
        this.encodedMods = new byte[this.encodedMsg.length - n - 1];
        int n2 = 0;
        while (n < this.encodedMsg.length - 1) {
            this.encodedMods[n2++] = this.encodedMsg[n++];
        }
    }

    private byte[] modsToByte(List<Modification> list) {
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(list.size());
        for (Modification modification : list) {
            Attribute attribute = modification.getAttribute();
            if (attribute.getAttributeType().equals(Historical.historicalAttrType)) continue;
            LDAPModification lDAPModification = new LDAPModification(modification.getModificationType(), new LDAPAttribute(modification.getAttribute()));
            arrayList.add(lDAPModification.encode());
        }
        return ASN1Element.encodeValue(arrayList);
    }

    public String toString() {
        return "Modify " + this.getDn() + " " + this.getChangeNumber();
    }
}

