/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.synchronization.AddMsg;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.DeleteMsg;
import org.opends.server.synchronization.ModifyDNMsg;
import org.opends.server.synchronization.ModifyMsg;
import org.opends.server.synchronization.OperationContext;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.synchronization.SynchronizationMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdateMessage
extends SynchronizationMessage
implements Serializable,
Comparable<UpdateMessage> {
    private ChangeNumber changeNumber;
    private String dn = null;
    private boolean assuredFlag = false;
    private String UniqueId;

    public UpdateMessage(OperationContext operationContext, String string) {
        this.changeNumber = operationContext.getChangeNumber();
        this.UniqueId = operationContext.getEntryUid();
        this.dn = string;
    }

    public UpdateMessage(byte[] byArray) throws DataFormatException, UnsupportedEncodingException {
        int n = 1;
        int n2 = this.getNextLength(byArray, n);
        String string = new String(byArray, n, n2, "UTF-8");
        this.changeNumber = new ChangeNumber(string);
    }

    public static UpdateMessage generateMsg(Operation operation, boolean bl) {
        UpdateMessage updateMessage = null;
        switch (operation.getOperationType()) {
            case MODIFY: {
                updateMessage = new ModifyMsg((ModifyOperation)operation);
                if (!bl) break;
                updateMessage.setAssured();
                break;
            }
            case ADD: {
                updateMessage = new AddMsg((AddOperation)operation);
                if (!bl) break;
                updateMessage.setAssured();
                break;
            }
            case DELETE: {
                updateMessage = new DeleteMsg((DeleteOperation)operation);
                if (!bl) break;
                updateMessage.setAssured();
                break;
            }
            case MODIFY_DN: {
                updateMessage = new ModifyDNMsg((ModifyDNOperation)operation);
                if (!bl) break;
                updateMessage.setAssured();
            }
        }
        return updateMessage;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String string) {
        this.dn = string;
    }

    public String getUniqueId() {
        return this.UniqueId;
    }

    public boolean isAssured() {
        return this.assuredFlag;
    }

    public void setAssured() {
        this.assuredFlag = true;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object.getClass() != this.getClass()) {
                return false;
            }
            return this.changeNumber.equals(((UpdateMessage)object).changeNumber);
        }
        return false;
    }

    public int hashCode() {
        return this.changeNumber.hashCode();
    }

    @Override
    public int compareTo(UpdateMessage updateMessage) {
        return this.changeNumber.compareTo(updateMessage.getChangeNumber());
    }

    public Operation createOperation(InternalClientConnection internalClientConnection) throws LDAPException, ASN1Exception, DataFormatException {
        return this.createOperation(internalClientConnection, this.dn);
    }

    public abstract Operation createOperation(InternalClientConnection var1, String var2) throws LDAPException, ASN1Exception, DataFormatException;

    public byte[] encodeHeader(byte by, int n) throws UnsupportedEncodingException {
        byte[] byArray = this.dn.getBytes("UTF-8");
        byte[] byArray2 = this.getChangeNumber().toString().getBytes("UTF-8");
        byte[] byArray3 = this.getUniqueId().getBytes("UTF-8");
        int n2 = 1 + byArray2.length + 1 + byArray.length + 1 + byArray3.length + 1 + n;
        byte[] byArray4 = new byte[n2];
        byArray4[0] = by;
        int n3 = 1;
        n3 = this.addByteArray(byArray2, byArray4, n3);
        n3 = this.addByteArray(byArray, byArray4, n3);
        n3 = this.addByteArray(byArray3, byArray4, n3);
        return byArray4;
    }

    public int decodeHeader(byte by, byte[] byArray) throws DataFormatException {
        if (byArray[0] != by) {
            throw new DataFormatException("byte[] is not a valid msg");
        }
        try {
            int n = 1;
            int n2 = this.getNextLength(byArray, n);
            String string = new String(byArray, n, n2, "UTF-8");
            n += n2 + 1;
            this.changeNumber = new ChangeNumber(string);
            n2 = this.getNextLength(byArray, n);
            this.dn = new String(byArray, n, n2, "UTF-8");
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            this.UniqueId = new String(byArray, n, n2, "UTF-8");
            return n += n2 + 1;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    @Override
    public UpdateMessage processReceive(SynchronizationDomain synchronizationDomain) {
        synchronizationDomain.receiveUpdate(this);
        return this;
    }
}

