/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.util.List;
import org.opends.server.api.Backend;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.StaticUtils;

public class RestoreTask
extends Task {
    private static final String CLASS_NAME = "org.opends.server.tasks.RestoreTask";
    private File backupDirectory;
    private String backupID;
    private boolean verifyOnly;

    public void initializeTask() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeTask", new String[0]));
        Entry entry = this.getTaskEntry();
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeType attributeType2 = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeType attributeType3 = DirectoryServer.getAttributeType("ds-task-restore-verify-only", true);
        List<Attribute> list = entry.getAttribute(attributeType);
        String string = TaskUtils.getSingleValueString(list);
        this.backupDirectory = new File(string);
        if (!this.backupDirectory.isAbsolute()) {
            this.backupDirectory = new File(DirectoryServer.getServerRoot(), string);
        }
        list = entry.getAttribute(attributeType2);
        this.backupID = TaskUtils.getSingleValueString(list);
        list = entry.getAttribute(attributeType3);
        this.verifyOnly = TaskUtils.getBoolean(list, false);
    }

    private boolean lockBackend(Backend backend) {
        try {
            String string = LockFileManager.getBackendLockFileName(backend);
            StringBuilder stringBuilder = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(string, stringBuilder)) {
                int n = 10748234;
                String string2 = MessageHandler.getMessage(n, backend.getBackendID(), String.valueOf(stringBuilder));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
                return false;
            }
        }
        catch (Exception exception) {
            int n = 10748234;
            String string = MessageHandler.getMessage(n, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return false;
        }
        return true;
    }

    private boolean unlockBackend(Backend backend) {
        try {
            String string = LockFileManager.getBackendLockFileName(backend);
            StringBuilder stringBuilder = new StringBuilder();
            if (!LockFileManager.releaseLock(string, stringBuilder)) {
                int n = 10617163;
                String string2 = MessageHandler.getMessage(n, backend.getBackendID(), String.valueOf(stringBuilder));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string2, n);
                return false;
            }
        }
        catch (Exception exception) {
            int n = 10617163;
            String string = MessageHandler.getMessage(n, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string, n);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState runTask() {
        boolean bl;
        block30: {
            ConfigEntry configEntry;
            Object object;
            BackupDirectory backupDirectory;
            assert (Debug.debugEnter(CLASS_NAME, "runTask", new String[0]));
            try {
                backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(this.backupDirectory.getPath());
            }
            catch (Exception exception) {
                int n = 10748208;
                String string = MessageHandler.getMessage(n, this.backupDirectory, StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return TaskState.STOPPED_BY_ERROR;
            }
            if (this.backupID != null) {
                object = backupDirectory.getBackupInfo(this.backupID);
                if (object == null) {
                    int n = 10748217;
                    String string = MessageHandler.getMessage(n, this.backupID, this.backupDirectory);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    return TaskState.STOPPED_BY_ERROR;
                }
            } else {
                object = backupDirectory.getLatestBackup();
                if (object == null) {
                    int n = 10748218;
                    String string = MessageHandler.getMessage(n, this.backupDirectory);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    return TaskState.STOPPED_BY_ERROR;
                }
                this.backupID = ((BackupInfo)object).getBackupID();
            }
            object = backupDirectory.getConfigEntryDN();
            try {
                configEntry = DirectoryServer.getConfigEntry((DN)object);
            }
            catch (ConfigException configException) {
                assert (Debug.debugException(CLASS_NAME, "runTask", configException));
                int n = 10748219;
                String string = MessageHandler.getMessage(n, this.backupDirectory, ((DN)object).toString());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return TaskState.STOPPED_BY_ERROR;
            }
            String string = TaskUtils.getBackendID(configEntry);
            Backend backend = DirectoryServer.getBackend(string);
            if (!backend.supportsRestore()) {
                int n = 10748220;
                String string2 = MessageHandler.getMessage(n, backend.getBackendID());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
                return TaskState.STOPPED_BY_ERROR;
            }
            RestoreConfig restoreConfig = new RestoreConfig(backupDirectory, this.backupID, this.verifyOnly);
            try {
                TaskUtils.setBackendEnabled(configEntry, false);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "runTask", directoryException));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, directoryException.getErrorMessage(), directoryException.getErrorMessageID());
                return TaskState.STOPPED_BY_ERROR;
            }
            bl = false;
            try {
                if (!this.lockBackend(backend)) break block30;
                try {
                    try {
                        backend.restoreBackup(configEntry, restoreConfig);
                    }
                    catch (DirectoryException directoryException) {
                        int n = 10748221;
                        String string3 = MessageHandler.getMessage(n, this.backupID, backupDirectory.getPath(), directoryException.getErrorMessage());
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string3, n);
                        bl = true;
                    }
                    catch (Exception exception) {
                        int n = 10748221;
                        String string4 = MessageHandler.getMessage(n, this.backupID, backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string4, n);
                        bl = true;
                    }
                }
                finally {
                    if (!this.unlockBackend(backend)) {
                        bl = true;
                    }
                }
            }
            finally {
                try {
                    TaskUtils.setBackendEnabled(configEntry, true);
                }
                catch (DirectoryException directoryException) {
                    assert (Debug.debugException(CLASS_NAME, "runTask", directoryException));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, directoryException.getErrorMessage(), directoryException.getErrorMessageID());
                    bl = true;
                }
            }
        }
        if (bl) {
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

