/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.loggers.Debug;
import org.opends.server.tools.SSLConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPConnectionOptions {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPConnectionOptions";
    private boolean reportAuthzID = false;
    private boolean useSSL = false;
    private boolean startTLS = false;
    private boolean saslExternal = false;
    private boolean usePasswordPolicyControl = false;
    private SSLConnectionFactory sslConnectionFactory = null;
    private String saslMechanism = null;
    private int versionNumber = 3;
    private Map<String, List<String>> saslProperties = new HashMap<String, List<String>>();

    public LDAPConnectionOptions() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void setUseSSL(boolean bl) {
        this.useSSL = bl;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public void setStartTLS(boolean bl) {
        this.startTLS = bl;
    }

    public boolean useStartTLS() {
        return this.startTLS;
    }

    public void setSASLExternal(boolean bl) {
        this.saslExternal = bl;
    }

    public boolean useSASLExternal() {
        return this.saslExternal;
    }

    public void setSSLConnectionFactory(SSLConnectionFactory sSLConnectionFactory) {
        this.sslConnectionFactory = sSLConnectionFactory;
    }

    public SSLConnectionFactory getSSLConnectionFactory() {
        return this.sslConnectionFactory;
    }

    public boolean setSASLMechanism(String string) {
        int n = string.indexOf("=");
        if (n == -1) {
            System.err.println("Invalid SASL mechanism property:" + string);
            return false;
        }
        this.saslMechanism = string.substring(n + 1, string.length());
        if (this.saslMechanism.equalsIgnoreCase("EXTERNAL")) {
            this.setSASLExternal(true);
        }
        return true;
    }

    public String getSASLMechanism() {
        return this.saslMechanism;
    }

    public Map<String, List<String>> getSASLProperties() {
        return this.saslProperties;
    }

    public boolean addSASLProperty(String string) {
        int n = string.indexOf("=");
        if (n == -1) {
            System.err.println("Invalid SASL property format:" + string);
            return false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        List<String> list = this.saslProperties.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(string3);
        this.saslProperties.put(string2, list);
        return true;
    }

    public void setVersionNumber(int n) {
        this.versionNumber = n;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public boolean getReportAuthzID() {
        return this.reportAuthzID;
    }

    public void setReportAuthzID(boolean bl) {
        this.reportAuthzID = bl;
    }

    public boolean usePasswordPolicyControl() {
        return this.usePasswordPolicyControl;
    }

    public void setUsePasswordPolicyControl(boolean bl) {
        this.usePasswordPolicyControl = bl;
    }
}

