/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class MakeLDIF
implements EntryWriter {
    private static final String CLASS_NAME = "org.opends.server.tools.makeldif.MakeLDIF";
    public static final int MAX_LINE_WIDTH = 79;
    private LDIFWriter ldifWriter = null;
    private long entriesWritten = 0L;

    public static void main(String[] stringArray) {
        MakeLDIF makeLDIF = new MakeLDIF();
        int n = makeLDIF.makeLDIFMain(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int makeLDIFMain(String[] stringArray) {
        File file;
        Random random;
        BooleanArgument booleanArgument;
        IntegerArgument integerArgument;
        StringArgument stringArgument;
        StringArgument stringArgument2;
        StringArgument stringArgument3;
        StringArgument stringArgument4;
        StringArgument stringArgument5;
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, false);
        try {
            stringArgument5 = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, "{configFile}", null, null, 10486334, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            stringArgument4 = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", null, null, 10486335, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            stringArgument3 = new StringArgument("resourcepath", Character.valueOf('r'), "resourcePath", true, false, true, "{path}", null, null, 10486351, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            stringArgument2 = new StringArgument("templatefile", Character.valueOf('t'), "templateFile", true, false, true, "{file}", null, null, 10486336, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument = new StringArgument("ldiffile", Character.valueOf('o'), "ldifFile", true, false, true, "{file}", null, null, 10486337, new Object[0]);
            argumentParser.addArgument(stringArgument);
            integerArgument = new IntegerArgument("randomseed", Character.valueOf('s'), "randomSeed", false, false, true, "{seed}", 0, null, 10486338, new Object[0]);
            argumentParser.addArgument(integerArgument);
            booleanArgument = new BooleanArgument("help", Character.valueOf('H'), "help", 10486339, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            argumentParser.setUsageArgument(booleanArgument);
        }
        catch (ArgumentException argumentException) {
            int n = 10748484;
            String string = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n = 10748485;
            String string = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string, 79));
            System.err.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument.isPresent()) {
            return 0;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
        try {
            directoryServer.initializeJMX();
        }
        catch (Exception exception) {
            int n = 10748486;
            String string = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(stringArgument4.getValue(), stringArgument5.getValue());
        }
        catch (Exception exception) {
            int n = 10748487;
            String string = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Exception exception) {
            int n = 10748488;
            String string = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        if (integerArgument.isPresent()) {
            try {
                random = new Random(integerArgument.getIntValue());
            }
            catch (Exception exception) {
                random = new Random();
            }
        } else {
            random = new Random();
        }
        if (!(file = new File(stringArgument3.getValue())).exists()) {
            int n = 10682961;
            String string = MessageHandler.getMessage(n, stringArgument3.getValue());
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        TemplateFile templateFile = new TemplateFile(stringArgument3.getValue(), random);
        try {
            templateFile.parse(stringArgument2.getValue(), linkedList);
        }
        catch (IOException iOException) {
            int n = 10748489;
            String string = MessageHandler.getMessage(n, iOException.getMessage());
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        catch (Exception exception) {
            int n = 10748490;
            String string = MessageHandler.getMessage(n, exception.getMessage());
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        if (!linkedList.isEmpty()) {
            for (String string : linkedList) {
                System.err.println(StaticUtils.wrapText(string, 79));
            }
        }
        LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(stringArgument.getValue(), ExistingFileBehavior.OVERWRITE);
        try {
            this.ldifWriter = new LDIFWriter(lDIFExportConfig);
        }
        catch (IOException iOException) {
            int n = 10682966;
            String string = MessageHandler.getMessage(n, stringArgument.getValue(), String.valueOf(iOException));
            System.err.println(StaticUtils.wrapText(string, 79));
            return 1;
        }
        try {
            templateFile.generateLDIF(this);
        }
        catch (Exception exception) {
            int n = 10682967;
            String string = MessageHandler.getMessage(n, stringArgument.getValue(), String.valueOf(exception));
            System.err.println(StaticUtils.wrapText(string, 79));
            int n2 = 1;
            return n2;
        }
        finally {
            try {
                this.ldifWriter.close();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public boolean writeEntry(Entry entry) throws IOException, MakeLDIFException {
        try {
            this.ldifWriter.writeEntry(entry);
            if (++this.entriesWritten % 1000L == 0L) {
                int n = 10486360;
                String string = MessageHandler.getMessage(n, this.entriesWritten);
                System.out.println(StaticUtils.wrapText(string, 79));
            }
            return true;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            int n = 10682969;
            String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(exception));
            throw new MakeLDIFException(n, string, exception);
        }
    }

    public void closeEntryWriter() {
        int n = 10486362;
        String string = MessageHandler.getMessage(n, this.entriesWritten);
        System.out.println(StaticUtils.wrapText(string, 79));
    }
}

