/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import org.opends.server.core.InitializationException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTag
extends Tag {
    public static final int RANDOM_TYPE_CHARS_FIXED = 1;
    public static final int RANDOM_TYPE_CHARS_VARIABLE = 2;
    public static final int RANDOM_TYPE_NUMERIC = 3;
    public static final int RANDOM_TYPE_MONTH = 4;
    public static final int RANDOM_TYPE_TELEPHONE = 5;
    public static final char[] ALPHA_CHARS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] NUMERIC_CHARS = "01234567890".toCharArray();
    public static final char[] ALPHANUMERIC_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final char[] HEX_CHARS = "01234567890abcdef".toCharArray();
    public static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567890+/".toCharArray();
    public static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private char[] characterSet = null;
    private DecimalFormat decimalFormat = null;
    private int lengthRange = 1;
    private int maxLength = 0;
    private int minLength = 0;
    private int randomType = 0;
    private long maxValue = 0L;
    private long minValue = 0L;
    private long valueRange = 1L;
    private Random random;

    @Override
    public String getName() {
        return "Random";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n, list);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeInternal(TemplateFile templateFile, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.random = templateFile.getRandom();
        if (stringArray == null || stringArray.length == 0) {
            int n2 = 10682956;
            String string = MessageHandler.getMessage(n2, n);
            throw new InitializationException(n2, string);
        }
        int n3 = stringArray.length;
        String string = StaticUtils.toLowerCase(stringArray[0]);
        if (string.equals("alpha")) {
            this.characterSet = ALPHA_CHARS;
            this.decodeLength(stringArray, 1, n, list);
            return;
        }
        if (string.equals("numeric")) {
            if (n3 == 2) {
                this.randomType = 1;
                this.characterSet = NUMERIC_CHARS;
                try {
                    this.minLength = Integer.parseInt(stringArray[1]);
                    if (this.minLength < 0) {
                        int n4 = 10682906;
                        String string2 = MessageHandler.getMessage(n4, this.minLength, 0, this.getName(), n);
                        throw new InitializationException(n4, string2);
                    }
                    if (this.minLength != 0) return;
                    int n5 = 10551885;
                    String string3 = MessageHandler.getMessage(n5, n);
                    list.add(string3);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    int n6 = 10682907;
                    String string4 = MessageHandler.getMessage(n6, stringArray[1], this.getName(), n);
                    throw new InitializationException(n6, string4, numberFormatException);
                }
            }
            if (n3 != 3 && n3 != 4) {
                int n7 = 10682904;
                String string5 = MessageHandler.getMessage(n7, this.getName(), n, 2, 4, n3);
                throw new InitializationException(n7, string5);
            }
            this.randomType = 3;
            if (n3 == 4) {
                try {
                    this.decimalFormat = new DecimalFormat(stringArray[3]);
                }
                catch (Exception exception) {
                    int n8 = 10682955;
                    String string6 = MessageHandler.getMessage(n8, stringArray[3], this.getName(), n);
                    throw new InitializationException(n8, string6, exception);
                }
            } else {
                this.decimalFormat = null;
            }
            try {
                this.minValue = Long.parseLong(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                int n9 = 10682907;
                String string7 = MessageHandler.getMessage(n9, stringArray[1], this.getName(), n);
                throw new InitializationException(n9, string7, numberFormatException);
            }
            try {
                this.maxValue = Long.parseLong(stringArray[2]);
                if (this.maxValue < this.minValue) {
                    int n10 = 10682906;
                    String string8 = MessageHandler.getMessage(n10, this.maxValue, this.minValue, this.getName(), n);
                    throw new InitializationException(n10, string8);
                }
                this.valueRange = this.maxValue - this.minValue + 1L;
                return;
            }
            catch (NumberFormatException numberFormatException) {
                int n11 = 10682907;
                String string9 = MessageHandler.getMessage(n11, stringArray[2], this.getName(), n);
                throw new InitializationException(n11, string9, numberFormatException);
            }
        }
        if (string.equals("alphanumeric")) {
            this.characterSet = ALPHANUMERIC_CHARS;
            this.decodeLength(stringArray, 1, n, list);
            return;
        }
        if (string.equals("chars")) {
            if (n3 >= 3 && n3 <= 4) {
                this.characterSet = stringArray[1].toCharArray();
                this.decodeLength(stringArray, 2, n, list);
                return;
            }
            int n12 = 10682904;
            String string10 = MessageHandler.getMessage(n12, this.getName(), n, 3, 4, n3);
            throw new InitializationException(n12, string10);
        }
        if (string.equals("hex")) {
            this.characterSet = HEX_CHARS;
            this.decodeLength(stringArray, 1, n, list);
            return;
        }
        if (string.equals("base64")) {
            this.characterSet = BASE64_CHARS;
            this.decodeLength(stringArray, 1, n, list);
            return;
        }
        if (string.equals("month")) {
            this.randomType = 4;
            if (n3 == 1) {
                this.maxLength = 0;
                return;
            }
            if (n3 != 2) {
                int n13 = 10682904;
                String string11 = MessageHandler.getMessage(n13, this.getName(), n, 1, 2, n3);
                throw new InitializationException(n13, string11);
            }
            try {
                this.maxLength = Integer.parseInt(stringArray[1]);
                if (this.maxLength > 0) return;
                int n14 = 10682906;
                String string12 = MessageHandler.getMessage(n14, this.maxLength, 1, this.getName(), n);
                throw new InitializationException(n14, string12);
            }
            catch (NumberFormatException numberFormatException) {
                int n15 = 10682907;
                String string13 = MessageHandler.getMessage(n15, stringArray[1], this.getName(), n);
                throw new InitializationException(n15, string13, numberFormatException);
            }
        }
        if (string.equals("telephone")) {
            this.randomType = 5;
            return;
        }
        int n16 = 10682958;
        String string14 = MessageHandler.getMessage(n16, n, string);
        throw new InitializationException(n16, string14);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeLength(String[] stringArray, int n, int n2, List<String> list) throws InitializationException {
        int n3 = stringArray.length - n + 1;
        if (n3 == 2) {
            this.randomType = 1;
            try {
                this.minLength = Integer.parseInt(stringArray[n]);
                if (this.minLength < 0) {
                    int n4 = 10682906;
                    String string = MessageHandler.getMessage(n4, this.minLength, 0, this.getName(), n2);
                    throw new InitializationException(n4, string);
                }
                if (this.minLength != 0) return;
                int n5 = 10551885;
                String string = MessageHandler.getMessage(n5, n2);
                list.add(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                int n6 = 10682907;
                String string = MessageHandler.getMessage(n6, stringArray[n], this.getName(), n2);
                throw new InitializationException(n6, string, numberFormatException);
            }
        }
        if (n3 == 3) {
            this.randomType = 2;
            try {
                this.minLength = Integer.parseInt(stringArray[n]);
                if (this.minLength < 0) {
                    int n7 = 10682906;
                    String string = MessageHandler.getMessage(n7, this.minLength, 0, this.getName(), n2);
                    throw new InitializationException(n7, string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                int n8 = 10682907;
                String string = MessageHandler.getMessage(n8, stringArray[n], this.getName(), n2);
                throw new InitializationException(n8, string, numberFormatException);
            }
            try {
                this.maxLength = Integer.parseInt(stringArray[n + 1]);
                this.lengthRange = this.maxLength - this.minLength + 1;
                if (this.maxLength < this.minLength) {
                    int n9 = 10682906;
                    String string = MessageHandler.getMessage(n9, this.maxLength, this.minLength, this.getName(), n2);
                    throw new InitializationException(n9, string);
                }
                if (this.maxLength != 0) return;
                int n10 = 10551885;
                String string = MessageHandler.getMessage(n10, this.getName(), n2);
                list.add(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                int n11 = 10682907;
                String string = MessageHandler.getMessage(n11, stringArray[n + 1], this.getName(), n2);
                throw new InitializationException(n11, string, numberFormatException);
            }
        }
        int n12 = 10682904;
        String string = MessageHandler.getMessage(n12, this.getName(), n2, n + 1, n + 2, n3);
        throw new InitializationException(n12, string);
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        StringBuilder stringBuilder = templateValue.getValue();
        switch (this.randomType) {
            case 1: {
                for (int i = 0; i < this.minLength; ++i) {
                    stringBuilder.append(this.characterSet[this.random.nextInt(this.characterSet.length)]);
                }
                break;
            }
            case 2: {
                int n = this.random.nextInt(this.lengthRange) + this.minLength;
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(this.characterSet[this.random.nextInt(this.characterSet.length)]);
                }
                break;
            }
            case 3: {
                long l = (this.random.nextLong() & Long.MAX_VALUE) % this.valueRange + this.minValue;
                if (this.decimalFormat == null) {
                    stringBuilder.append(l);
                    break;
                }
                stringBuilder.append(this.decimalFormat.format(l));
                break;
            }
            case 4: {
                String string = MONTHS[this.random.nextInt(MONTHS.length)];
                if (this.maxLength == 0 || string.length() <= this.maxLength) {
                    stringBuilder.append(string);
                    break;
                }
                stringBuilder.append(string.substring(0, this.maxLength));
                break;
            }
            case 5: {
                int n;
                for (n = 0; n < 3; ++n) {
                    stringBuilder.append(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]);
                }
                stringBuilder.append('-');
                for (n = 0; n < 3; ++n) {
                    stringBuilder.append(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]);
                }
                stringBuilder.append('-');
                for (n = 0; n < 4; ++n) {
                    stringBuilder.append(NUMERIC_CHARS[this.random.nextInt(NUMERIC_CHARS.length)]);
                }
                break;
            }
        }
        return TagResult.SUCCESS_RESULT;
    }
}

