/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;

public class TemplateLine {
    private AttributeType attributeType;
    private int lineNumber;
    private Tag[] tags;

    public TemplateLine(AttributeType attributeType, int n, Tag[] tagArray) {
        this.attributeType = attributeType;
        this.lineNumber = n;
        this.tags = tagArray;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public TagResult generateLine(TemplateEntry templateEntry) {
        TemplateValue templateValue = new TemplateValue(this);
        for (Tag tag : this.tags) {
            TagResult tagResult = tag.generateValue(templateEntry, templateValue);
            if (tagResult.keepProcessingLine() && tagResult.keepProcessingEntry() && tagResult.keepProcessingParent() && tagResult.keepProcessingTemplateFile()) continue;
            return tagResult;
        }
        templateEntry.addValue(templateValue);
        return TagResult.SUCCESS_RESULT;
    }
}

