/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.ProtocolElement;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockManager;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValueIterable;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry
implements ProtocolElement {
    private static final String CLASS_NAME = "org.opends.server.types.Entry";
    private Map<AttributeType, List<Attribute>> operationalAttributes;
    private Map<AttributeType, List<Attribute>> userAttributes;
    private Map<ObjectClass, String> objectClasses;
    private DN dn;
    private transient Object attachment;

    public Entry(DN dN, Map<ObjectClass, String> map, Map<AttributeType, List<Attribute>> map2, Map<AttributeType, List<Attribute>> map3) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(map), String.valueOf(map2), String.valueOf(map3)));
        this.attachment = null;
        this.dn = dN == null ? new DN(new ArrayList<RDN>(0)) : dN;
        this.objectClasses = map == null ? new HashMap<ObjectClass, String>() : map;
        this.userAttributes = map2 == null ? new HashMap<AttributeType, List<Attribute>>() : map2;
        this.operationalAttributes = map3 == null ? new HashMap<AttributeType, List<Attribute>>() : map3;
    }

    public DN getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.dn;
    }

    public void setDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(dN)));
        this.dn = dN == null ? new DN(new ArrayList<RDN>(0)) : dN;
        this.attachment = null;
    }

    public Map<ObjectClass, String> getObjectClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClasses", new String[0]));
        return this.objectClasses;
    }

    public boolean hasObjectClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "hasObjectClass", String.valueOf(objectClass)));
        return this.objectClasses.containsKey(objectClass);
    }

    public ObjectClass getStructuralObjectClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getStructuralObjectClass", new String[0]));
        ObjectClass objectClass = null;
        for (ObjectClass objectClass2 : this.objectClasses.keySet()) {
            if (objectClass2.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
            if (objectClass == null) {
                objectClass = objectClass2;
                continue;
            }
            if (!objectClass2.isDescendantOf(objectClass)) continue;
            objectClass = objectClass2;
        }
        return objectClass;
    }

    public void setObjectClasses(Collection<AttributeValue> collection) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "setObjectClasses", String.valueOf(collection)));
        this.attachment = null;
        LinkedHashMap<ObjectClass, String> linkedHashMap = new LinkedHashMap<ObjectClass, String>();
        for (AttributeValue attributeValue : collection) {
            String string;
            String string2 = attributeValue.getStringValue();
            try {
                string = attributeValue.getNormalizedStringValue();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "addObjectClasses", exception));
                string = StaticUtils.toLowerCase(attributeValue.getStringValue());
            }
            ObjectClass objectClass = DirectoryServer.getObjectClass(string);
            if (objectClass == null) {
                int n = 196884;
                String string3 = MessageHandler.getMessage(n, string2, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, string3, n);
            }
            linkedHashMap.put(objectClass, string2);
        }
        this.objectClasses = linkedHashMap;
    }

    public void addObjectClass(AttributeValue attributeValue) throws DirectoryException {
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "addObjectClass", String.valueOf(attributeValue)));
        this.attachment = null;
        String string2 = attributeValue.getStringValue();
        try {
            string = attributeValue.getNormalizedStringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "addObjectClass", exception));
            string = StaticUtils.toLowerCase(string2);
        }
        ObjectClass objectClass = DirectoryServer.getObjectClass(string, true);
        if (this.objectClasses.containsKey(objectClass)) {
            int n = 196885;
            String string3 = MessageHandler.getMessage(n, string2, String.valueOf(this.dn));
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, string3, n);
        }
        this.objectClasses.put(objectClass, string2);
    }

    public void addObjectClass(ObjectClass objectClass) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addObjectClass", String.valueOf(objectClass)));
        this.attachment = null;
        if (this.objectClasses.containsKey(objectClass)) {
            int n = 196885;
            String string = MessageHandler.getMessage(n, objectClass.getNameOrOID(), String.valueOf(this.dn));
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, string, n);
        }
        this.objectClasses.put(objectClass, objectClass.getNameOrOID());
    }

    public void addObjectClasses(Collection<AttributeValue> collection) throws DirectoryException {
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "addObjectClasses", String.valueOf(collection)));
        this.attachment = null;
        LinkedHashMap<ObjectClass, String> linkedHashMap = new LinkedHashMap<ObjectClass, String>();
        for (AttributeValue object : collection) {
            String string2;
            string = object.getStringValue();
            try {
                string2 = object.getNormalizedStringValue();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "addObjectClasses", exception));
                string2 = StaticUtils.toLowerCase(object.getStringValue());
            }
            ObjectClass objectClass = DirectoryServer.getObjectClass(string2);
            if (objectClass == null) {
                int n = 196884;
                String string3 = MessageHandler.getMessage(n, string, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, string3, n);
            }
            if (this.objectClasses.containsKey(objectClass)) {
                int n = 196885;
                String string4 = MessageHandler.getMessage(n, string, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, string4, n);
            }
            linkedHashMap.put(objectClass, string);
        }
        for (ObjectClass objectClass : linkedHashMap.keySet()) {
            string = (String)linkedHashMap.get(objectClass);
            this.objectClasses.put(objectClass, string);
        }
    }

    public List<Attribute> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (List<Attribute> list : this.userAttributes.values()) {
            for (Attribute attribute : list) {
                arrayList.add(attribute);
            }
        }
        for (List<Attribute> list : this.operationalAttributes.values()) {
            for (Attribute attribute : list) {
                arrayList.add(attribute);
            }
        }
        return arrayList;
    }

    public Map<AttributeType, List<Attribute>> getUserAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserAttributes", new String[0]));
        return this.userAttributes;
    }

    public Map<AttributeType, List<Attribute>> getOperationalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationalAttributes", new String[0]));
        return this.operationalAttributes;
    }

    public Attribute getObjectClassAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClassAttribute", new String[0]));
        if (this.objectClasses == null || this.objectClasses.isEmpty()) {
            return null;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(this.objectClasses.size());
        for (String string : this.objectClasses.values()) {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(StaticUtils.toLowerCase(string))));
        }
        return new Attribute(DirectoryServer.getObjectClassAttributeType(), "objectClass", linkedHashSet);
    }

    public boolean hasAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAttribute", String.valueOf(attributeType)));
        if (this.userAttributes.containsKey(attributeType) || this.operationalAttributes.containsKey(attributeType)) {
            return true;
        }
        return attributeType.isObjectClassType() && !this.objectClasses.isEmpty();
    }

    public boolean hasAttribute(AttributeType attributeType, Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAttribute", String.valueOf(attributeType), String.valueOf(set)));
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null && (list = this.operationalAttributes.get(attributeType)) == null) {
            if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty()) {
                return set == null || set.isEmpty();
            }
            return false;
        }
        for (Attribute attribute : list) {
            if (!attribute.hasValue()) continue;
            return true;
        }
        return false;
    }

    public List<Attribute> getAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", String.valueOf(attributeType)));
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null) {
            list = this.operationalAttributes.get(attributeType);
            if (list == null) {
                if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty()) {
                    list = new ArrayList<Attribute>(1);
                    list.add(this.getObjectClassAttribute());
                    return list;
                }
                return null;
            }
            return list;
        }
        return list;
    }

    public List<Attribute> getAttribute(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", String.valueOf(string)));
        for (AttributeType attributeType : this.userAttributes.keySet()) {
            if (!attributeType.hasNameOrOID(string)) continue;
            return this.userAttributes.get(attributeType);
        }
        for (AttributeType attributeType : this.operationalAttributes.keySet()) {
            if (!attributeType.hasNameOrOID(string)) continue;
            return this.operationalAttributes.get(attributeType);
        }
        return null;
    }

    public List<Attribute> getAttribute(AttributeType attributeType, Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", String.valueOf(attributeType), String.valueOf(set)));
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null && (list = this.operationalAttributes.get(attributeType)) == null) {
            if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty() && (set == null || set.isEmpty())) {
                list = new ArrayList<Attribute>(1);
                list.add(this.getObjectClassAttribute());
                return list;
            }
            return null;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(list.size());
        for (Attribute attribute : list) {
            if (!attribute.hasOptions(set)) continue;
            arrayList.add(attribute);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public List<Attribute> getAttribute(String string, Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", String.valueOf(string), String.valueOf(set)));
        List<Attribute> list = null;
        for (AttributeType object : this.userAttributes.keySet()) {
            if (!object.hasNameOrOID(string)) continue;
            list = this.userAttributes.get(object);
            break;
        }
        if (list == null) {
            for (AttributeType attributeType : this.operationalAttributes.keySet()) {
                if (!attributeType.hasNameOrOID(string)) continue;
                list = this.operationalAttributes.get(attributeType);
                break;
            }
            if (list == null) {
                return null;
            }
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (Attribute attribute : list) {
            if (!attribute.hasOptions(set)) continue;
            arrayList.add(attribute);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public final <T> T getAttributeValue(AttributeType attributeType, AttributeValueDecoder<T> attributeValueDecoder) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValue", String.valueOf(attributeType), attributeValueDecoder.getClass().getName()));
        List<Attribute> list = this.getAttribute(attributeType);
        AttributeValueIterable attributeValueIterable = new AttributeValueIterable(list);
        Iterator<AttributeValue> iterator = attributeValueIterable.iterator();
        if (iterator.hasNext()) {
            return attributeValueDecoder.decode(iterator.next());
        }
        return null;
    }

    public final <T> Collection<T> getAttributeValues(AttributeType attributeType, AttributeValueDecoder<? extends T> attributeValueDecoder, Collection<T> collection) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValues", String.valueOf(attributeType), attributeValueDecoder.getClass().getName()));
        List<Attribute> list = this.getAttribute(attributeType);
        AttributeValueIterable attributeValueIterable = new AttributeValueIterable(list);
        for (AttributeValue attributeValue : attributeValueIterable) {
            collection.add(attributeValueDecoder.decode(attributeValue));
        }
        return collection;
    }

    public boolean hasUserAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "hasUserAttribute", String.valueOf(attributeType)));
        return this.userAttributes.containsKey(attributeType);
    }

    public List<Attribute> getUserAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "getUserAttribute", String.valueOf(attributeType)));
        return this.userAttributes.get(attributeType);
    }

    public List<Attribute> getUserAttribute(AttributeType attributeType, Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "getUserAttribute", String.valueOf(attributeType), String.valueOf(set)));
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null) {
            return null;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(list.size());
        for (Attribute attribute : list) {
            if (!attribute.hasOptions(set)) continue;
            arrayList.add(attribute);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public List<Attribute> duplicateUserAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "duplicateUserAttribute", String.valueOf(attributeType)));
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null) {
            return null;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(list.size());
        for (Attribute attribute : list) {
            arrayList.add(attribute.duplicate());
        }
        return arrayList;
    }

    public boolean hasOperationalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "hasOperationalAttribute", String.valueOf(attributeType)));
        return this.operationalAttributes.containsKey(attributeType);
    }

    public List<Attribute> getOperationalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationalAttribute", String.valueOf(attributeType)));
        return this.operationalAttributes.get(attributeType);
    }

    public List<Attribute> getOperationalAttribute(AttributeType attributeType, Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationalAttribute", String.valueOf(attributeType), String.valueOf(set)));
        List<Attribute> list = this.operationalAttributes.get(attributeType);
        if (list == null) {
            return null;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(list.size());
        for (Attribute attribute : list) {
            if (!attribute.hasOptions(set)) continue;
            arrayList.add(attribute);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public List<Attribute> duplicateOperationalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "duplicateOperationalAttribute", String.valueOf(attributeType)));
        List<Attribute> list = this.operationalAttributes.get(attributeType);
        if (list == null) {
            return null;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(list.size());
        for (Attribute attribute : list) {
            arrayList.add(attribute.duplicate());
        }
        return arrayList;
    }

    public void putAttribute(AttributeType attributeType, List<Attribute> list) {
        assert (Debug.debugEnter(CLASS_NAME, "putAttribute", String.valueOf(attributeType), String.valueOf(list)));
        this.attachment = null;
        List<Attribute> list2 = this.userAttributes.get(attributeType);
        if (list2 != null) {
            this.userAttributes.put(attributeType, list);
            return;
        }
        list2 = this.operationalAttributes.get(attributeType);
        if (list2 != null) {
            this.operationalAttributes.put(attributeType, list);
            return;
        }
        if (attributeType.isOperational()) {
            this.operationalAttributes.put(attributeType, list);
        } else {
            this.userAttributes.put(attributeType, list);
        }
    }

    public void addAttribute(Attribute attribute, List<AttributeValue> list) {
        assert (Debug.debugEnter(CLASS_NAME, "addAttribute", String.valueOf(attribute), "java.util.List<AttributeValue>"));
        this.attachment = null;
        List<Attribute> list2 = this.getAttribute(attribute.getAttributeType());
        if (list2 == null) {
            list2 = new ArrayList<Attribute>(1);
            list2.add(attribute);
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.isOperational()) {
                this.operationalAttributes.put(attributeType, list2);
            } else {
                this.userAttributes.put(attributeType, list2);
            }
            return;
        }
        LinkedHashSet<String> linkedHashSet = attribute.getOptions();
        for (Attribute attribute2 : list2) {
            if (!attribute2.optionsEqual(linkedHashSet)) continue;
            LinkedHashSet<AttributeValue> linkedHashSet2 = attribute2.getValues();
            LinkedHashSet<AttributeValue> linkedHashSet3 = attribute.getValues();
            for (AttributeValue attributeValue : linkedHashSet3) {
                if (linkedHashSet2.add(attributeValue)) continue;
                list.add(attributeValue);
            }
            return;
        }
        list2.add(attribute);
    }

    public boolean removeAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeAttribute", String.valueOf(attributeType)));
        this.attachment = null;
        if (attributeType.isObjectClassType()) {
            this.objectClasses.clear();
            return true;
        }
        return this.userAttributes.remove(attributeType) != null || this.operationalAttributes.remove(attributeType) != null;
    }

    public boolean removeAttribute(AttributeType attributeType, Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "removeAttribute", String.valueOf(attributeType)));
        this.attachment = null;
        if (set == null || set.isEmpty()) {
            return this.removeAttribute(attributeType);
        }
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null && (list = this.operationalAttributes.get(attributeType)) == null) {
            return false;
        }
        boolean bl = false;
        Iterator<Attribute> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.optionsEqual(set)) continue;
            iterator.remove();
            bl = true;
            break;
        }
        if (list.isEmpty()) {
            this.userAttributes.remove(attributeType);
            this.operationalAttributes.remove(attributeType);
        }
        return bl;
    }

    public boolean removeAttribute(Attribute attribute, List<AttributeValue> list) {
        assert (Debug.debugEnter(CLASS_NAME, "removeAttribute", String.valueOf(attribute), "java.util.List<AttributeValue>"));
        this.attachment = null;
        if (attribute.getAttributeType().isObjectClassType()) {
            boolean bl = true;
            for (AttributeValue attributeValue : attribute.getValues()) {
                String string;
                try {
                    string = attributeValue.getNormalizedStringValue();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "removeAttribute", exception));
                    string = StaticUtils.toLowerCase(attributeValue.getStringValue());
                }
                boolean bl2 = false;
                for (ObjectClass objectClass : this.objectClasses.keySet()) {
                    if (!objectClass.hasNameOrOID(string)) continue;
                    bl2 = true;
                    this.objectClasses.remove(objectClass);
                    break;
                }
                if (bl2) continue;
                bl = false;
                list.add(attributeValue);
            }
            return bl;
        }
        if (attribute.hasOptions()) {
            LinkedHashSet<String> linkedHashSet = attribute.getOptions();
            LinkedHashSet<AttributeValue> linkedHashSet2 = attribute.getValues();
            if (linkedHashSet2 == null || linkedHashSet2.isEmpty()) {
                return this.removeAttribute(attribute.getAttributeType(), linkedHashSet);
            }
            List<Attribute> list2 = this.getAttribute(attribute.getAttributeType());
            if (list2 == null) {
                return false;
            }
            for (Attribute attribute2 : list2) {
                if (!attribute2.optionsEqual(linkedHashSet)) continue;
                LinkedHashSet<AttributeValue> linkedHashSet3 = attribute2.getValues();
                for (AttributeValue attributeValue : linkedHashSet2) {
                    if (linkedHashSet3.remove(attributeValue)) continue;
                    list.add(attributeValue);
                }
                if (linkedHashSet3.isEmpty()) {
                    return this.removeAttribute(attribute.getAttributeType(), linkedHashSet);
                }
                return true;
            }
            return false;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            return this.removeAttribute(attribute.getAttributeType());
        }
        List<Attribute> list3 = this.getAttribute(attribute.getAttributeType());
        if (list3 == null) {
            return false;
        }
        for (Attribute attribute3 : list3) {
            if (attribute3.hasOptions()) continue;
            LinkedHashSet<AttributeValue> linkedHashSet4 = attribute3.getValues();
            for (AttributeValue attributeValue : linkedHashSet) {
                if (linkedHashSet4.remove(attributeValue)) continue;
                list.add(attributeValue);
            }
            if (linkedHashSet4.isEmpty()) {
                return this.removeAttribute(attribute.getAttributeType());
            }
            return true;
        }
        return false;
    }

    public boolean allowsAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "allowsAttribute", String.valueOf(attributeType)));
        for (ObjectClass objectClass : this.objectClasses.keySet()) {
            if (!objectClass.isRequiredOrOptional(attributeType)) continue;
            return true;
        }
        return false;
    }

    public boolean requiresAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "requiresAttribute", String.valueOf(attributeType)));
        for (ObjectClass objectClass : this.objectClasses.keySet()) {
            if (!objectClass.isRequired(attributeType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValue(AttributeType attributeType, Set<String> set, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "hasValue", String.valueOf(attributeType), String.valueOf(set), String.valueOf(attributeValue)));
        List<Attribute> list = this.getAttribute(attributeType);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Attribute attribute : list) {
            if (!attribute.optionsEqual(set)) continue;
            return attribute.hasValue(attributeValue);
        }
        return false;
    }

    public void applyModification(Modification modification) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "applyModification", String.valueOf(modification)));
        Attribute attribute = modification.getAttribute();
        AttributeType attributeType = attribute.getAttributeType();
        if (attributeType.isObjectClassType()) {
            String string;
            LinkedHashMap<ObjectClass, String> linkedHashMap = new LinkedHashMap<ObjectClass, String>();
            for (AttributeValue object2 : attribute.getValues()) {
                String linkedHashSet = object2.getStringValue();
                string = StaticUtils.toLowerCase(linkedHashSet);
                ObjectClass objectClass = DirectoryServer.getObjectClass(string, true);
                linkedHashMap.put(objectClass, linkedHashSet);
            }
            switch (modification.getModificationType()) {
                case ADD: {
                    for (ObjectClass n : linkedHashMap.keySet()) {
                        if (this.objectClasses.containsKey(n)) {
                            int n2 = 197167;
                            string = MessageHandler.getMessage(n2, attribute.getName());
                            throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, string, n2);
                        }
                        this.objectClasses.put(n, linkedHashMap.get(n));
                    }
                    break;
                }
                case DELETE: {
                    for (ObjectClass objectClass : linkedHashMap.keySet()) {
                        if (this.objectClasses.remove(objectClass) != null) continue;
                        int n = 197168;
                        string = MessageHandler.getMessage(n, attribute.getName());
                        throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, string, n);
                    }
                    break;
                }
                case REPLACE: {
                    this.objectClasses = linkedHashMap;
                    break;
                }
                case INCREMENT: {
                    int n = 197169;
                    String string2 = MessageHandler.getMessage(n);
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n);
                }
                default: {
                    int n = 197170;
                    String string3 = MessageHandler.getMessage(n, String.valueOf((Object)modification.getModificationType()));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string3, n);
                }
            }
            return;
        }
        switch (modification.getModificationType()) {
            case ADD: {
                LinkedList<AttributeValue> linkedList = new LinkedList<AttributeValue>();
                this.addAttribute(attribute, linkedList);
                if (linkedList.isEmpty()) break;
                int n = 197167;
                String string = MessageHandler.getMessage(n, attribute.getName());
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, string, n);
            }
            case DELETE: {
                LinkedList<AttributeValue> linkedList = new LinkedList<AttributeValue>();
                this.removeAttribute(attribute, linkedList);
                if (linkedList.isEmpty()) break;
                int n = 197168;
                String string = MessageHandler.getMessage(n, attribute.getName());
                throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, string, n);
            }
            case REPLACE: {
                this.removeAttribute(attributeType, attribute.getOptions());
                if (!attribute.hasValue()) break;
                LinkedList<AttributeValue> linkedList = new LinkedList<AttributeValue>();
                this.addAttribute(attribute, linkedList);
                break;
            }
            case INCREMENT: {
                long l;
                List<Attribute> list = this.getAttribute(attributeType);
                if (list == null || list.isEmpty()) {
                    int n = 197170;
                    String string = MessageHandler.getMessage(n, attribute.getName());
                    throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, string, n);
                }
                if (list.size() != 1) {
                    int n = 197171;
                    String string = MessageHandler.getMessage(n, attribute.getName());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                LinkedHashSet<AttributeValue> linkedHashSet = list.get(0).getValues();
                if (linkedHashSet.isEmpty()) {
                    int n = 197170;
                    String string = MessageHandler.getMessage(n, attribute.getName());
                    throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, string, n);
                }
                if (linkedHashSet.size() > 1) {
                    int n = 197171;
                    String string = MessageHandler.getMessage(n, attribute.getName());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                LinkedHashSet<AttributeValue> linkedHashSet2 = attribute.getValues();
                if (linkedHashSet2.size() != 1) {
                    int n = 197172;
                    String string = MessageHandler.getMessage(n);
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                try {
                    String string = ((AttributeValue)linkedHashSet.iterator().next()).getStringValue();
                    long l2 = Long.parseLong(string);
                    string = ((AttributeValue)attribute.getValues().iterator().next()).getStringValue();
                    long l3 = Long.parseLong(string);
                    l = l2 + l3;
                }
                catch (NumberFormatException numberFormatException) {
                    int n = 197173;
                    String string = MessageHandler.getMessage(n);
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                linkedHashSet.clear();
                linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(l)));
                break;
            }
            default: {
                int n = 197170;
                String string = MessageHandler.getMessage(n, String.valueOf((Object)modification.getModificationType()));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
            }
        }
    }

    public void applyModifications(List<Modification> list) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "applyModifications", String.valueOf(list)));
        for (Modification modification : list) {
            this.applyModification(modification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean conformsToSchema(Entry entry, boolean bl, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "conformsToSchema", "java.lang.StringBuilder"));
        for (ObjectClass object3 : this.objectClasses.keySet()) {
            if (DirectoryServer.getObjectClass(object3.getOID()) == null) {
                int n = 196877;
                String string = MessageHandler.getMessage(n, String.valueOf(this.dn), object3.getNameOrOID());
                stringBuilder.append(string);
                return false;
            }
            for (AttributeType attributeType : object3.getRequiredAttributes()) {
                if (this.userAttributes.containsKey(attributeType) || this.operationalAttributes.containsKey(attributeType) || attributeType.isObjectClassType()) continue;
                int n = 196734;
                String string = MessageHandler.getMessage(n, String.valueOf(this.dn), attributeType.getNameOrOID(), object3.getNameOrOID());
                stringBuilder.append(string);
                return false;
            }
        }
        for (AttributeType attributeType : this.userAttributes.keySet()) {
            List<Attribute> list;
            Object object2;
            boolean bl2 = false;
            for (Object object2 : this.objectClasses.keySet()) {
                if (!((ObjectClass)object2).isRequiredOrOptional(attributeType)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                int n = 196735;
                object2 = MessageHandler.getMessage(n, String.valueOf(this.dn), attributeType.getNameOrOID());
                stringBuilder.append((String)object2);
                return false;
            }
            if (!attributeType.isSingleValue() || (list = this.userAttributes.get(attributeType)) == null) continue;
            object2 = list.iterator();
            while (object2.hasNext()) {
                Attribute attribute = (Attribute)object2.next();
                if (attribute.getValues().size() <= 1) continue;
                int n = 196813;
                String string = MessageHandler.getMessage(n, String.valueOf(this.dn), attributeType.getNameOrOID());
                stringBuilder.append(string);
                return false;
            }
        }
        Object object5 = DirectoryServer.getSingleStructuralObjectClassPolicy();
        if (object5 == AcceptRejectWarn.REJECT || object5 == AcceptRejectWarn.WARN) {
            void var5_9;
            Object var5_8 = null;
            for (ObjectClass objectClass : this.objectClasses.keySet()) {
                if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
                if (var5_9 == null) {
                    ObjectClass objectClass2 = objectClass;
                    continue;
                }
                if (objectClass.isDescendantOf((ObjectClass)var5_9)) {
                    ObjectClass objectClass3 = objectClass;
                    continue;
                }
                if (var5_9.isDescendantOf(objectClass)) continue;
                int n = 196806;
                String string = MessageHandler.getMessage(n, String.valueOf(this.dn), var5_9.getNameOrOID(), objectClass.getNameOrOID());
                if (object5 == AcceptRejectWarn.REJECT) {
                    stringBuilder.append(string);
                    return false;
                }
                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                break;
            }
            if (var5_9 == null) {
                int n = 196807;
                String string = MessageHandler.getMessage(n, String.valueOf(this.dn));
                if (object5 == AcceptRejectWarn.REJECT) {
                    stringBuilder.append(string);
                    return false;
                }
                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
            } else {
                DITContentRule dITContentRule;
                NameForm nameForm = DirectoryServer.getNameForm((ObjectClass)var5_9);
                if (nameForm != null && !nameForm.isObsolete()) {
                    DITStructureRule dITStructureRule;
                    String string;
                    int n;
                    RDN rDN = this.dn.getRDN();
                    if (rDN != null) {
                        for (AttributeType attributeType : nameForm.getRequiredAttributes()) {
                            if (rDN.hasAttributeType(attributeType)) continue;
                            int n2 = 196814;
                            String string2 = MessageHandler.getMessage(n2, String.valueOf(this.dn), attributeType.getNameOrOID(), nameForm.getNameOrOID());
                            if (object5 == AcceptRejectWarn.REJECT) {
                                stringBuilder.append(string2);
                                return false;
                            }
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string2, n2);
                        }
                        for (AttributeType attributeType : rDN.getAttributeTypes()) {
                            if (nameForm.isRequiredOrOptional(attributeType)) continue;
                            n = 196815;
                            string = MessageHandler.getMessage(n, String.valueOf(this.dn), attributeType.getNameOrOID(), nameForm.getNameOrOID());
                            if (object5 == AcceptRejectWarn.REJECT) {
                                stringBuilder.append(string);
                                return false;
                            }
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                        }
                    }
                    if ((dITStructureRule = DirectoryServer.getDITStructureRule(nameForm)) != null && !dITStructureRule.isObsolete() && dITStructureRule.hasSuperiorRules()) {
                        if (bl) {
                            boolean bl3;
                            if (entry != null && !(bl3 = this.validateDITStructureRule(dITStructureRule, (ObjectClass)var5_9, entry, (AcceptRejectWarn)((Object)object5), stringBuilder))) {
                                return false;
                            }
                        } else {
                            DN dN = this.dn.getParent();
                            if (dN != null) {
                                void var11_61;
                                Lock lock = null;
                                boolean bl4 = false;
                                while (var11_61 < 3 && (lock = LockManager.lockRead(dN)) == null) {
                                    ++var11_61;
                                }
                                if (lock == null) {
                                    int n3 = 196820;
                                    String string3 = MessageHandler.getMessage(n3, String.valueOf(this.dn), dITStructureRule.getNameOrRuleID(), String.valueOf(dN));
                                    if (object5 == AcceptRejectWarn.REJECT) {
                                        stringBuilder.append(string3);
                                        return false;
                                    }
                                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string3, n3);
                                } else {
                                    try {
                                        entry = DirectoryServer.getEntry(dN);
                                        if (entry == null) {
                                            int n4 = 196821;
                                            String string4 = MessageHandler.getMessage(n4, String.valueOf(this.dn), dITStructureRule.getNameOrRuleID(), String.valueOf(dN));
                                            if (object5 == AcceptRejectWarn.REJECT) {
                                                stringBuilder.append(string4);
                                                boolean bl5 = false;
                                                return bl5;
                                            }
                                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string4, n4);
                                        } else {
                                            boolean bl6 = this.validateDITStructureRule(dITStructureRule, (ObjectClass)var5_9, entry, (AcceptRejectWarn)((Object)object5), stringBuilder);
                                            if (!bl6) {
                                                n = 0;
                                                return n != 0;
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        assert (Debug.debugException(CLASS_NAME, "conformsToSchema", exception));
                                        int n5 = 196824;
                                        string = MessageHandler.getMessage(n5, String.valueOf(this.dn), dITStructureRule.getNameOrRuleID(), StaticUtils.stackTraceToSingleLineString(exception));
                                        if (object5 == AcceptRejectWarn.REJECT) {
                                            stringBuilder.append(string);
                                            boolean bl7 = false;
                                            return bl7;
                                        }
                                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n5);
                                    }
                                    finally {
                                        LockManager.unlock(dN, lock);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((dITContentRule = DirectoryServer.getDITContentRule((ObjectClass)var5_9)) != null && !dITContentRule.isObsolete()) {
                    for (AttributeType attributeType : dITContentRule.getRequiredAttributes()) {
                        if (this.userAttributes.containsKey(attributeType) || this.operationalAttributes.containsKey(attributeType) || attributeType.isObjectClassType()) break;
                        int n = 196816;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.dn), attributeType.getNameOrOID(), dITContentRule.getName());
                        if (object5 == AcceptRejectWarn.REJECT) {
                            stringBuilder.append(string);
                            return false;
                        }
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                    for (AttributeType attributeType : dITContentRule.getProhibitedAttributes()) {
                        if (!this.userAttributes.containsKey(attributeType) && !this.operationalAttributes.containsKey(attributeType)) continue;
                        int n = 196817;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.dn), attributeType.getNameOrOID(), dITContentRule.getName());
                        if (object5 == AcceptRejectWarn.REJECT) {
                            stringBuilder.append(string);
                            return false;
                        }
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                    for (AttributeType attributeType : this.userAttributes.keySet()) {
                        if (dITContentRule.isRequiredOrOptional(attributeType, true)) continue;
                        int n = 196818;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.dn), attributeType.getNameOrOID(), dITContentRule.getName());
                        if (object5 == AcceptRejectWarn.REJECT) {
                            stringBuilder.append(string);
                            return false;
                        }
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                    for (ObjectClass objectClass : this.objectClasses.keySet()) {
                        if (objectClass.getObjectClassType() != ObjectClassType.AUXILIARY || dITContentRule.isAllowedAuxiliaryClass(objectClass)) continue;
                        int n = 196819;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.dn), objectClass.getNameOrOID(), dITContentRule.getName());
                        if (object5 == AcceptRejectWarn.REJECT) {
                            stringBuilder.append(string);
                            return false;
                        }
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                }
            }
        }
        return true;
    }

    private boolean validateDITStructureRule(DITStructureRule dITStructureRule, ObjectClass objectClass, Entry entry, AcceptRejectWarn acceptRejectWarn, StringBuilder stringBuilder) {
        int n;
        ObjectClass objectClass2 = entry.getStructuralObjectClass();
        if (objectClass2 == null) {
            n = 196822;
            String string = MessageHandler.getMessage(n, String.valueOf(this.dn), dITStructureRule.getNameOrRuleID(), String.valueOf(entry.getDN()));
            if (acceptRejectWarn == AcceptRejectWarn.REJECT) {
                stringBuilder.append(string);
                return false;
            }
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
        }
        n = 0;
        for (DITStructureRule object : dITStructureRule.getSuperiorRules()) {
            if (!object.getStructuralClass().equals(objectClass2)) continue;
            n = 1;
        }
        if (n == 0) {
            int n2 = 196823;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.dn), dITStructureRule.getNameOrRuleID(), objectClass.getNameOrOID(), objectClass2.getNameOrOID());
            if (acceptRejectWarn == AcceptRejectWarn.REJECT) {
                stringBuilder.append(string);
                return false;
            }
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n2);
        }
        return true;
    }

    public Object getAttachment() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttachment", new String[0]));
        return this.attachment;
    }

    public void setAttachment(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttachment", String.valueOf(object)));
        this.attachment = object;
    }

    public Entry duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        DN dN = this.dn.duplicate();
        HashMap<ObjectClass, String> hashMap = new HashMap<ObjectClass, String>(this.objectClasses);
        HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
        this.deepCopy(this.userAttributes, hashMap2);
        HashMap<AttributeType, List<Attribute>> hashMap3 = new HashMap<AttributeType, List<Attribute>>(this.operationalAttributes.size());
        this.deepCopy(this.operationalAttributes, hashMap3);
        return new Entry(dN, hashMap, hashMap2, hashMap3);
    }

    public Entry duplicateWithoutOperationalAttributes(boolean bl) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        DN dN = this.dn.duplicate();
        HashMap<Object, Object> hashMap = bl ? new HashMap(0) : new HashMap<ObjectClass, String>(this.objectClasses);
        HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
        if (bl) {
            object = DirectoryServer.getObjectClassAttributeType();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(new Attribute((AttributeType)object));
            hashMap2.put((AttributeType)object, arrayList);
            for (AttributeType attributeType : this.userAttributes.keySet()) {
                ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(1);
                arrayList2.add(new Attribute(attributeType));
                hashMap2.put(attributeType, arrayList2);
            }
        } else {
            this.deepCopy(this.userAttributes, hashMap2);
        }
        object = new HashMap(0);
        return new Entry(dN, hashMap, hashMap2, (Map<AttributeType, List<Attribute>>)object);
    }

    private void deepCopy(Map<AttributeType, List<Attribute>> map, Map<AttributeType, List<Attribute>> map2) {
        for (AttributeType attributeType : map.keySet()) {
            List<Attribute> list = map.get(attributeType);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(list.size());
            for (Attribute attribute : list) {
                arrayList.add(attribute.duplicate());
            }
            map2.put(attributeType, arrayList);
        }
    }

    public Entry duplicateWithoutAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        DN dN = this.dn.duplicate();
        HashMap<ObjectClass, String> hashMap = new HashMap<ObjectClass, String>(this.objectClasses.size());
        HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
        HashMap<AttributeType, List<Attribute>> hashMap3 = new HashMap<AttributeType, List<Attribute>>(this.operationalAttributes.size());
        return new Entry(dN, hashMap, hashMap2, hashMap3);
    }

    public boolean isReferral() {
        assert (Debug.debugEnter(CLASS_NAME, "isReferral", new String[0]));
        ObjectClass objectClass = DirectoryServer.getObjectClass("referral");
        if (objectClass == null) {
            assert (Debug.debugMessage(DebugLogCategory.SCHEMA, DebugLogSeverity.WARNING, CLASS_NAME, "isReferral", "No referral objectclass is defined in the server schema."));
            for (String string : this.objectClasses.values()) {
                if (!string.equalsIgnoreCase("referral")) continue;
                return true;
            }
            return false;
        }
        if (!this.objectClasses.containsKey(objectClass)) {
            return false;
        }
        AttributeType attributeType = DirectoryServer.getAttributeType("ref");
        if (attributeType == null) {
            assert (Debug.debugMessage(DebugLogCategory.SCHEMA, DebugLogSeverity.WARNING, CLASS_NAME, "isReferral", "No ref attribute type is defined in the server schema."));
            return false;
        }
        return this.userAttributes.containsKey(attributeType) || this.operationalAttributes.containsKey(attributeType);
    }

    public LinkedHashSet<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        AttributeType attributeType = DirectoryServer.getAttributeType("ref");
        if (attributeType == null) {
            assert (Debug.debugMessage(DebugLogCategory.SCHEMA, DebugLogSeverity.WARNING, CLASS_NAME, "getReferralURLs", "No ref attribute type is defined in the server schema."));
            return null;
        }
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null && (list = this.operationalAttributes.get(attributeType)) == null) {
            return null;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Attribute attribute : list) {
            for (AttributeValue attributeValue : attribute.getValues()) {
                linkedHashSet.add(attributeValue.getStringValue());
            }
        }
        return linkedHashSet;
    }

    public boolean isAlias() {
        assert (Debug.debugEnter(CLASS_NAME, "isAlias", new String[0]));
        ObjectClass objectClass = DirectoryServer.getObjectClass("alias");
        if (objectClass == null) {
            assert (Debug.debugMessage(DebugLogCategory.SCHEMA, DebugLogSeverity.WARNING, CLASS_NAME, "isAlias", "No alias objectclass is defined in the server schema."));
            for (String string : this.objectClasses.values()) {
                if (!string.equalsIgnoreCase("alias")) continue;
                return true;
            }
            return false;
        }
        if (!this.objectClasses.containsKey(objectClass)) {
            return false;
        }
        AttributeType attributeType = DirectoryServer.getAttributeType("aliasedobjectname");
        if (attributeType == null) {
            assert (Debug.debugMessage(DebugLogCategory.SCHEMA, DebugLogSeverity.WARNING, CLASS_NAME, "isAlias", "No aliasedobjectname attribute type is defined in the server schema."));
            return false;
        }
        return this.userAttributes.containsKey(attributeType) || this.operationalAttributes.containsKey(attributeType);
    }

    public DN getAliasedDN() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getAliasedDN", new String[0]));
        AttributeType attributeType = DirectoryServer.getAttributeType("ref");
        if (attributeType == null) {
            assert (Debug.debugMessage(DebugLogCategory.SCHEMA, DebugLogSeverity.WARNING, CLASS_NAME, "getAliasedDN", "No aliasedobjectname attribute type is defined in the server schema."));
            return null;
        }
        List<Attribute> list = this.userAttributes.get(attributeType);
        if (list == null && (list = this.operationalAttributes.get(attributeType)) == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        Attribute attribute = list.get(0);
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        return DN.decode(((AttributeValue)linkedHashSet.iterator().next()).getStringValue());
    }

    public boolean isLDAPSubentry() {
        assert (Debug.debugEnter(CLASS_NAME, "isLDAPSubentry", new String[0]));
        ObjectClass objectClass = DirectoryServer.getObjectClass("ldapsubentry");
        if (objectClass == null) {
            assert (Debug.debugMessage(DebugLogCategory.SCHEMA, DebugLogSeverity.WARNING, CLASS_NAME, "isLDAPSubentry", "No ldapSubentry objectclass is defined in the server schema."));
            for (String string : this.objectClasses.values()) {
                if (!string.equalsIgnoreCase("ldapSubentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(objectClass);
    }

    public boolean matchesBaseAndScope(DN dN, SearchScope searchScope) {
        assert (Debug.debugEnter(CLASS_NAME, "matchesBaseAndScope", String.valueOf(dN), String.valueOf((Object)searchScope)));
        switch (searchScope) {
            case BASE_OBJECT: {
                return dN.equals(this.dn);
            }
            case SINGLE_LEVEL: {
                return dN.equals(this.dn.getParent());
            }
            case WHOLE_SUBTREE: {
                return dN.isAncestorOf(this.dn);
            }
            case SUBORDINATE_SUBTREE: {
                return !dN.equals(this.dn) && dN.isAncestorOf(this.dn);
            }
        }
        return false;
    }

    public List<StringBuilder> toLDIF() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", new String[0]));
        LinkedList<StringBuilder> linkedList = new LinkedList<StringBuilder>();
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder3, StaticUtils.getBytes(this.dn.toString()));
        linkedList.add(stringBuilder3);
        for (String object : this.objectClasses.values()) {
            Iterator iterator = new StringBuilder();
            ((StringBuilder)((Object)iterator)).append("objectClass: ");
            ((StringBuilder)((Object)iterator)).append(object);
            linkedList.add((StringBuilder)((Object)iterator));
        }
        for (List list : this.userAttributes.values()) {
            for (Attribute attribute : list) {
                stringBuilder2 = new StringBuilder(attribute.getName());
                for (String string : attribute.getOptions()) {
                    stringBuilder2.append(";");
                    stringBuilder2.append(string);
                }
                for (AttributeValue attributeValue : attribute.getValues()) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append((CharSequence)stringBuilder2);
                    LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, attributeValue.getValueBytes());
                    linkedList.add(stringBuilder);
                }
            }
        }
        for (List list : this.operationalAttributes.values()) {
            for (Attribute attribute : list) {
                stringBuilder2 = new StringBuilder(attribute.getName());
                for (String string : attribute.getOptions()) {
                    stringBuilder2.append(";");
                    stringBuilder2.append(string);
                }
                for (AttributeValue attributeValue : attribute.getValues()) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append((CharSequence)stringBuilder2);
                    LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, attributeValue.getValueBytes());
                    linkedList.add(stringBuilder);
                }
            }
        }
        return linkedList;
    }

    public boolean toLDIF(LDIFExportConfig lDIFExportConfig) throws IOException, LDIFException {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        List<Attribute> list;
        Object object;
        LDIFPluginResult lDIFPluginResult;
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", String.valueOf(lDIFExportConfig)));
        try {
            if (!lDIFExportConfig.includeEntry(this)) {
                assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_WRITE, DebugLogSeverity.INFO, CLASS_NAME, "writeEntry", "Skipping entry " + String.valueOf(this.dn) + " because of the export configuration."));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "toLDIF", exception));
            int n = 5505047;
            String string = MessageHandler.getMessage(n, String.valueOf(this.dn), String.valueOf(exception));
            throw new LDIFException(n, string, exception);
        }
        if (lDIFExportConfig.invokeExportPlugins() && !(lDIFPluginResult = ((PluginConfigManager)(object = DirectoryServer.getPluginConfigManager())).invokeLDIFExportPlugins(lDIFExportConfig, this)).continueEntryProcessing()) {
            return false;
        }
        object = lDIFExportConfig.getWriter();
        int n = lDIFExportConfig.getWrapColumn();
        boolean bl = n > 1;
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder3, StaticUtils.getBytes(this.dn.toString()));
        LDIFWriter.writeLDIFLine(stringBuilder3, (BufferedWriter)object, bl, n);
        if (lDIFExportConfig.includeObjectClasses()) {
            if (lDIFExportConfig.typesOnly()) {
                Iterator<Object> iterator = new StringBuilder("objectClass:");
                LDIFWriter.writeLDIFLine(iterator, (BufferedWriter)object, bl, n);
            } else {
                for (String object2 : this.objectClasses.values()) {
                    list = new StringBuilder();
                    ((StringBuilder)((Object)list)).append("objectClass: ");
                    ((StringBuilder)((Object)list)).append(object2);
                    LDIFWriter.writeLDIFLine((StringBuilder)((Object)list), (BufferedWriter)object, bl, n);
                }
            }
        } else assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_WRITE, DebugLogSeverity.VERBOSE, CLASS_NAME, "writeEntry", "Skipping objectclasses for entry " + String.valueOf(this.dn) + " because of the export configuration."));
        for (AttributeType attributeType : this.userAttributes.keySet()) {
            if (lDIFExportConfig.includeAttribute(attributeType)) {
                list = this.userAttributes.get(attributeType);
                for (Attribute attribute : list) {
                    if (lDIFExportConfig.typesOnly()) {
                        stringBuilder2 = new StringBuilder(attribute.getName());
                        for (String string : attribute.getOptions()) {
                            stringBuilder2.append(";");
                            stringBuilder2.append(string);
                        }
                        stringBuilder2.append(":");
                        LDIFWriter.writeLDIFLine(stringBuilder2, (BufferedWriter)object, bl, n);
                        continue;
                    }
                    stringBuilder2 = new StringBuilder(attribute.getName());
                    for (String string : attribute.getOptions()) {
                        stringBuilder2.append(";");
                        stringBuilder2.append(string);
                    }
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append((CharSequence)stringBuilder2);
                        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, attributeValue.getValueBytes());
                        LDIFWriter.writeLDIFLine(stringBuilder, (BufferedWriter)object, bl, n);
                    }
                }
                continue;
            }
            assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_WRITE, DebugLogSeverity.VERBOSE, CLASS_NAME, "writeEntry", "Skipping user attribute " + attributeType.getNameOrOID() + " for entry " + String.valueOf(this.dn) + " because of the export configuration."));
        }
        if (lDIFExportConfig.includeOperationalAttributes()) {
            for (AttributeType attributeType : this.operationalAttributes.keySet()) {
                if (lDIFExportConfig.includeAttribute(attributeType)) {
                    list = this.operationalAttributes.get(attributeType);
                    for (Attribute attribute : list) {
                        if (lDIFExportConfig.typesOnly()) {
                            stringBuilder2 = new StringBuilder(attribute.getName());
                            for (String string : attribute.getOptions()) {
                                stringBuilder2.append(";");
                                stringBuilder2.append(string);
                            }
                            stringBuilder2.append(":");
                            LDIFWriter.writeLDIFLine(stringBuilder2, (BufferedWriter)object, bl, n);
                            continue;
                        }
                        stringBuilder2 = new StringBuilder(attribute.getName());
                        for (String string : attribute.getOptions()) {
                            stringBuilder2.append(";");
                            stringBuilder2.append(string);
                        }
                        for (AttributeValue attributeValue : attribute.getValues()) {
                            stringBuilder = new StringBuilder();
                            stringBuilder.append((CharSequence)stringBuilder2);
                            LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, attributeValue.getValueBytes());
                            LDIFWriter.writeLDIFLine(stringBuilder, (BufferedWriter)object, bl, n);
                        }
                    }
                    continue;
                }
                assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_WRITE, DebugLogSeverity.VERBOSE, CLASS_NAME, "writeEntry", "Skipping operational attribute " + attributeType.getNameOrOID() + " for entry " + String.valueOf(this.dn) + " because of the export " + "configuration."));
            }
        } else assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_WRITE, DebugLogSeverity.VERBOSE, CLASS_NAME, "writeEntry", "Skipping all operational attributes for entry " + String.valueOf(this.dn) + " because of the export configuration."));
        ((BufferedWriter)object).newLine();
        return true;
    }

    @Override
    public String getProtocolElementName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolElementName", new String[0]));
        return "Entry";
    }

    @Override
    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        Iterator<Object> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("Entry(dn=\"");
        this.dn.toString(stringBuilder);
        stringBuilder.append("\", objectClasses={");
        if (!this.objectClasses.isEmpty()) {
            iterator = this.objectClasses.values().iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                stringBuilder.append((String)iterator.next());
            }
        }
        stringBuilder.append("}, userAttrs={");
        if (!this.userAttributes.isEmpty()) {
            iterator = this.userAttributes.keySet().iterator();
            stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
            }
        }
        stringBuilder.append("}, operationalAttrs={");
        if (!this.operationalAttributes.isEmpty()) {
            iterator = this.operationalAttributes.keySet().iterator();
            stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
            }
        }
        stringBuilder.append("})");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        for (StringBuilder stringBuilder3 : this.toLDIF()) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append((CharSequence)stringBuilder3);
            stringBuilder.append(ServerConstants.EOL);
        }
    }

    public String toSingleLineString() {
        assert (Debug.debugEnter(CLASS_NAME, "toSingleLineString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toSingleLineString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toSingleLineString(StringBuilder stringBuilder) {
        Iterator iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toSingleLineString", "java.lang.StringBuilder"));
        stringBuilder.append("Entry(dn=\"");
        this.dn.toString(stringBuilder);
        stringBuilder.append("\",objectClasses={");
        Iterator<String> iterator2 = this.objectClasses.values().iterator();
        if (iterator2.hasNext()) {
            stringBuilder.append(iterator2.next());
            while (iterator2.hasNext()) {
                stringBuilder.append(",");
                stringBuilder.append(iterator2.next());
            }
        }
        stringBuilder.append("},userAttrs={");
        boolean bl = true;
        for (List<Attribute> list : this.userAttributes.values()) {
            for (Attribute attribute : list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(attribute.getName());
                if (attribute.hasOptions()) {
                    for (String string : attribute.getOptions()) {
                        stringBuilder.append(";");
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append("={");
                iterator = attribute.getValues().iterator();
                if (iterator.hasNext()) {
                    stringBuilder.append(((AttributeValue)iterator.next()).getStringValue());
                    while (iterator.hasNext()) {
                        stringBuilder.append(",");
                        stringBuilder.append(((AttributeValue)iterator.next()).getStringValue());
                    }
                }
                stringBuilder.append("}");
            }
        }
        stringBuilder.append("},operationalAttrs={");
        for (List<Attribute> list : this.operationalAttributes.values()) {
            for (Attribute attribute : list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(attribute.getName());
                if (attribute.hasOptions()) {
                    for (String string : attribute.getOptions()) {
                        stringBuilder.append(";");
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append("={");
                iterator = attribute.getValues().iterator();
                if (iterator.hasNext()) {
                    stringBuilder.append(((AttributeValue)iterator.next()).getStringValue());
                    while (iterator.hasNext()) {
                        stringBuilder.append(",");
                        stringBuilder.append(((AttributeValue)iterator.next()).getStringValue());
                    }
                }
                stringBuilder.append("}");
            }
        }
        stringBuilder.append("})");
    }
}

