/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class FilePermission {
    private static final String CLASS_NAME = "org.opends.server.types.FilePermission";
    public static final int OWNER_READABLE = 256;
    public static final int OWNER_WRITABLE = 128;
    public static final int OWNER_EXECUTABLE = 64;
    public static final int GROUP_READABLE = 32;
    public static final int GROUP_WRITABLE = 16;
    public static final int GROUP_EXECUTABLE = 8;
    public static final int OTHER_READABLE = 4;
    public static final int OTHER_WRITABLE = 2;
    public static final int OTHER_EXECUTABLE = 1;
    private static boolean allowExec;
    private static Method setExecutableMethod;
    private static Method setReadableMethod;
    private static Method setWritableMethod;
    private int encodedPermission;

    public FilePermission(int n) {
        this.encodedPermission = n;
    }

    public FilePermission(boolean bl, boolean bl2, boolean bl3) {
        this.encodedPermission = 0;
        if (bl) {
            this.encodedPermission |= 0x100;
        }
        if (bl2) {
            this.encodedPermission |= 0x80;
        }
        if (bl3) {
            this.encodedPermission |= 0x40;
        }
    }

    public FilePermission(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.encodedPermission = 0;
        if (bl) {
            this.encodedPermission |= 0x100;
        }
        if (bl2) {
            this.encodedPermission |= 0x80;
        }
        if (bl3) {
            this.encodedPermission |= 0x40;
        }
        if (bl4) {
            this.encodedPermission |= 0x20;
        }
        if (bl5) {
            this.encodedPermission |= 0x10;
        }
        if (bl6) {
            this.encodedPermission |= 8;
        }
        if (bl7) {
            this.encodedPermission |= 4;
        }
        if (bl8) {
            this.encodedPermission |= 2;
        }
        if (bl9) {
            this.encodedPermission |= 1;
        }
    }

    public boolean isOwnerReadable() {
        return (this.encodedPermission & 0x100) == 256;
    }

    public boolean isOwnerWritable() {
        return (this.encodedPermission & 0x80) == 128;
    }

    public boolean isOwnerExecutable() {
        return (this.encodedPermission & 0x40) == 64;
    }

    public boolean isGroupReadable() {
        return (this.encodedPermission & 0x20) == 32;
    }

    public boolean isGroupWritable() {
        return (this.encodedPermission & 0x10) == 16;
    }

    public boolean isGroupExecutable() {
        return (this.encodedPermission & 8) == 8;
    }

    public boolean isOtherReadable() {
        return (this.encodedPermission & 4) == 4;
    }

    public boolean isOtherWritable() {
        return (this.encodedPermission & 2) == 2;
    }

    public boolean isOtherExecutable() {
        return (this.encodedPermission & 1) == 1;
    }

    public static boolean canSetPermissions() {
        if (setReadableMethod != null && setWritableMethod != null && setExecutableMethod != null) {
            return true;
        }
        OperatingSystem operatingSystem = DirectoryServer.getOperatingSystem();
        return allowExec && operatingSystem != null && OperatingSystem.isUNIXBased(operatingSystem);
    }

    public static boolean setPermissions(File file, FilePermission filePermission) throws FileNotFoundException, DirectoryException {
        if (!file.exists()) {
            int n = 5439629;
            String string = MessageHandler.getMessage(n, file.getAbsolutePath());
            throw new FileNotFoundException(string);
        }
        OperatingSystem operatingSystem = DirectoryServer.getOperatingSystem();
        if (allowExec && operatingSystem != null && OperatingSystem.isUNIXBased(operatingSystem)) {
            return FilePermission.setUsingUNIX(file, filePermission);
        }
        if (setReadableMethod != null && setWritableMethod != null && setExecutableMethod != null) {
            return FilePermission.setUsingJava(file, filePermission);
        }
        return false;
    }

    private static boolean setUsingUNIX(File file, FilePermission filePermission) throws DirectoryException {
        int n;
        String[] stringArray = new String[]{FilePermission.toUNIXMode(filePermission), file.getAbsolutePath()};
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            n = StaticUtils.exec("chmod", stringArray, null, null, arrayList);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getUsingUNIX", exception));
            int n2 = 5439630;
            String string = MessageHandler.getMessage(n2, file.getAbsolutePath(), String.valueOf(exception));
            throw new DirectoryException(ResultCode.OTHER, string, n2, exception);
        }
        return n == 0;
    }

    private static boolean setUsingJava(File file, FilePermission filePermission) throws DirectoryException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (filePermission.isOwnerReadable() && !filePermission.isOtherReadable()) {
            try {
                Boolean bl4 = (Boolean)setReadableMethod.invoke((Object)file, false, false);
                if (bl4.booleanValue()) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "setUsingJava", exception));
                bl3 = true;
            }
        }
        try {
            boolean bl5 = filePermission.isOwnerReadable() != filePermission.isOtherReadable();
            object = (Boolean)setReadableMethod.invoke((Object)file, filePermission.isOwnerReadable(), bl5);
            if (((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setUsingJava", exception));
            bl3 = true;
        }
        if (filePermission.isOwnerWritable() && !filePermission.isOtherWritable()) {
            try {
                Boolean bl6 = (Boolean)setWritableMethod.invoke((Object)file, false, false);
                if (bl6.booleanValue()) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "setUsingJava", exception));
                bl3 = true;
            }
        }
        try {
            boolean bl7 = filePermission.isOwnerWritable() != filePermission.isOtherWritable();
            object = (Boolean)setWritableMethod.invoke((Object)file, filePermission.isOwnerWritable(), bl7);
            if (((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setUsingJava", exception));
            bl3 = true;
        }
        if (filePermission.isOwnerExecutable() && !filePermission.isOtherExecutable()) {
            try {
                Boolean bl8 = (Boolean)setExecutableMethod.invoke((Object)file, false, false);
                if (bl8.booleanValue()) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "setUsingJava", exception));
                bl3 = true;
            }
        }
        try {
            boolean bl9 = filePermission.isOwnerExecutable() != filePermission.isOtherExecutable();
            object = (Boolean)setExecutableMethod.invoke((Object)file, filePermission.isOwnerExecutable(), bl9);
            if (((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setUsingJava", exception));
            bl3 = true;
        }
        if (bl3) {
            int n = 5505167;
            object = MessageHandler.getMessage(n, file.getAbsolutePath());
            throw new DirectoryException(ResultCode.OTHER, (String)object, n);
        }
        if (bl2) {
            if (bl) {
                int n = 5505168;
                object = MessageHandler.getMessage(n, file.getAbsolutePath());
                throw new DirectoryException(ResultCode.OTHER, (String)object, n);
            }
            int n = 5505169;
            object = MessageHandler.getMessage(n, file.getAbsolutePath());
            throw new DirectoryException(ResultCode.OTHER, (String)object, n);
        }
        return bl;
    }

    public static String toUNIXMode(FilePermission filePermission) {
        StringBuilder stringBuilder = new StringBuilder(3);
        FilePermission.toUNIXMode(stringBuilder, filePermission);
        return stringBuilder.toString();
    }

    public static void toUNIXMode(StringBuilder stringBuilder, FilePermission filePermission) {
        int n = 0;
        if (filePermission.isOwnerReadable()) {
            n = (byte)(n | 4);
        }
        if (filePermission.isOwnerWritable()) {
            n = (byte)(n | 2);
        }
        if (filePermission.isOwnerExecutable()) {
            n = (byte)(n | 1);
        }
        stringBuilder.append(String.valueOf(n));
        n = 0;
        if (filePermission.isGroupReadable()) {
            n = (byte)(n | 4);
        }
        if (filePermission.isGroupWritable()) {
            n = (byte)(n | 2);
        }
        if (filePermission.isGroupExecutable()) {
            n = (byte)(n | 1);
        }
        stringBuilder.append(String.valueOf(n));
        n = 0;
        if (filePermission.isOtherReadable()) {
            n = (byte)(n | 4);
        }
        if (filePermission.isOtherWritable()) {
            n = (byte)(n | 2);
        }
        if (filePermission.isOtherExecutable()) {
            n = (byte)(n | 1);
        }
        stringBuilder.append(String.valueOf(n));
    }

    public static FilePermission decodeUNIXMode(String string) throws DirectoryException {
        if (string == null || string.length() != 3) {
            int n = 5439634;
            String string2 = MessageHandler.getMessage(n, String.valueOf(string));
            throw new DirectoryException(ResultCode.OTHER, string2, n);
        }
        int n = 0;
        switch (string.charAt(0)) {
            case '0': {
                break;
            }
            case '1': {
                n |= 0x40;
                break;
            }
            case '2': {
                n |= 0x80;
                break;
            }
            case '3': {
                n |= 0xC0;
                break;
            }
            case '4': {
                n |= 0x100;
                break;
            }
            case '5': {
                n |= 0x140;
                break;
            }
            case '6': {
                n |= 0x180;
                break;
            }
            case '7': {
                n |= 0x1C0;
                break;
            }
            default: {
                int n2 = 5439634;
                String string3 = MessageHandler.getMessage(n2, String.valueOf(string));
                throw new DirectoryException(ResultCode.OTHER, string3, n2);
            }
        }
        switch (string.charAt(1)) {
            case '0': {
                break;
            }
            case '1': {
                n |= 8;
                break;
            }
            case '2': {
                n |= 0x10;
                break;
            }
            case '3': {
                n |= 0x18;
                break;
            }
            case '4': {
                n |= 0x20;
                break;
            }
            case '5': {
                n |= 0x28;
                break;
            }
            case '6': {
                n |= 0x30;
                break;
            }
            case '7': {
                n |= 0x38;
                break;
            }
            default: {
                int n3 = 5439634;
                String string4 = MessageHandler.getMessage(n3, String.valueOf(string));
                throw new DirectoryException(ResultCode.OTHER, string4, n3);
            }
        }
        switch (string.charAt(2)) {
            case '0': {
                break;
            }
            case '1': {
                n |= 1;
                break;
            }
            case '2': {
                n |= 2;
                break;
            }
            case '3': {
                n |= 3;
                break;
            }
            case '4': {
                n |= 4;
                break;
            }
            case '5': {
                n |= 5;
                break;
            }
            case '6': {
                n |= 6;
                break;
            }
            case '7': {
                n |= 7;
                break;
            }
            default: {
                int n4 = 5439634;
                String string5 = MessageHandler.getMessage(n4, String.valueOf(string));
                throw new DirectoryException(ResultCode.OTHER, string5, n4);
            }
        }
        return new FilePermission(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("FilePermission(");
        FilePermission.toUNIXMode(stringBuilder, this);
        stringBuilder.append(")");
    }

    static {
        block5: {
            try {
                setExecutableMethod = null;
                setReadableMethod = null;
                setWritableMethod = null;
                for (Method method : File.class.getMethods()) {
                    String string = method.getName();
                    Class<?>[] classArray = method.getParameterTypes();
                    if (string.equals("setExecutable") && classArray.length == 2) {
                        setExecutableMethod = method;
                        continue;
                    }
                    if (string.equals("setReadable") && classArray.length == 2) {
                        setReadableMethod = method;
                        continue;
                    }
                    if (!string.equals("setWritable") || classArray.length != 2) continue;
                    setWritableMethod = method;
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "<static>", exception)) break block5;
                throw new AssertionError();
            }
        }
        allowExec = StaticUtils.mayUseExec();
    }
}

