/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.List;
import java.util.Random;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedCharacterSet {
    private static final String CLASS_NAME = "org.opends.server.types.NamedCharacterSet";
    private char[] characters;
    private Random random;
    private String name;

    public NamedCharacterSet(String string, char[] cArray) throws ConfigException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(cArray)));
        this.name = string;
        this.characters = cArray;
        this.random = new Random();
        if (string == null || string.length() == 0) {
            int n = 5439609;
            String string2 = MessageHandler.getMessage(n);
            throw new ConfigException(n, string2);
        }
        for (int i = 0; i < string.length(); ++i) {
            if (StaticUtils.isAlpha(string.charAt(i))) continue;
            int n = 5439610;
            String string3 = MessageHandler.getMessage(n, String.valueOf(string.charAt(i)), i);
            throw new ConfigException(n, string3);
        }
    }

    public NamedCharacterSet(String string, char[] cArray, Random random) throws ConfigException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(cArray), String.valueOf(random)));
        this.name = string;
        this.characters = cArray;
        this.random = random;
        if (string == null || string.length() == 0) {
            int n = 5439609;
            String string2 = MessageHandler.getMessage(n);
            throw new ConfigException(n, string2);
        }
        for (int i = 0; i < string.length(); ++i) {
            if (StaticUtils.isAlpha(string.charAt(i))) continue;
            int n = 5439610;
            String string3 = MessageHandler.getMessage(n, String.valueOf(string.charAt(i)), i);
            throw new ConfigException(n, string3);
        }
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return this.name;
    }

    public char[] getCharacters() {
        assert (Debug.debugEnter(CLASS_NAME, "getCharacters", new String[0]));
        return this.characters;
    }

    public char getRandomCharacter() {
        assert (Debug.debugEnter(CLASS_NAME, "getRandomCharacter", new String[0]));
        if (this.characters == null || this.characters.length == 0) {
            return '\u0000';
        }
        return this.characters[this.random.nextInt(this.characters.length)];
    }

    public void getRandomCharacters(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getRandomCharacters", "java.lang.StringBuilder", String.valueOf(n)));
        if (this.characters == null || this.characters.length == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.characters[this.random.nextInt(this.characters.length)]);
        }
    }

    public String encode() {
        return this.name + ":" + new String(this.characters);
    }

    public static NamedCharacterSet[] decodeCharacterSets(List<String> list) throws ConfigException {
        NamedCharacterSet[] namedCharacterSetArray = new NamedCharacterSet[list.size()];
        for (int i = 0; i < namedCharacterSetArray.length; ++i) {
            Object object;
            String string = list.get(i);
            int n = string.indexOf(58);
            if (n < 0) {
                int n2 = 5439608;
                object = MessageHandler.getMessage(n2, String.valueOf(string));
                throw new ConfigException(n2, (String)object);
            }
            if (n == 0) {
                int n3 = 5439611;
                object = MessageHandler.getMessage(n3, String.valueOf(string));
                throw new ConfigException(n3, (String)object);
            }
            if (n == string.length() - 1) {
                int n4 = 5439612;
                object = MessageHandler.getMessage(n4, String.valueOf(string));
                throw new ConfigException(n4, (String)object);
            }
            String string2 = string.substring(0, n);
            object = string.substring(n + 1).toCharArray();
            namedCharacterSetArray[i] = new NamedCharacterSet(string2, (char[])object);
        }
        return namedCharacterSetArray;
    }
}

