/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Comparator;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValueComparator;
import org.opends.server.types.RDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDNComparator
implements Comparator<RDN> {
    private static final String CLASS_NAME = "org.opends.server.types.RDNComparator";

    public RDNComparator() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(RDN rDN, RDN rDN2) {
        assert (Debug.debugEnter(CLASS_NAME, "compare", String.valueOf(rDN), String.valueOf(rDN2)));
        AttributeType[] attributeTypeArray = rDN.getAttributeTypes();
        AttributeType[] attributeTypeArray2 = rDN2.getAttributeTypes();
        AttributeValue[] attributeValueArray = rDN.getAttributeValues();
        AttributeValue[] attributeValueArray2 = rDN2.getAttributeValues();
        int n = 0;
        while (true) {
            if (n < attributeTypeArray.length) {
                if (n >= attributeTypeArray.length) return 1;
                if (!attributeTypeArray[n].equals(attributeTypeArray2[n])) return attributeTypeArray[n].getNormalizedPrimaryName().compareTo(attributeTypeArray2[n].getNormalizedPrimaryName());
                AttributeValueComparator attributeValueComparator = new AttributeValueComparator(attributeTypeArray[n]);
                int n2 = attributeValueComparator.compare(attributeValueArray[n], attributeValueArray2[n]);
                if (n2 != 0) {
                    return n2;
                }
            } else {
                if (n >= attributeTypeArray.length) return 0;
                return -1;
            }
            ++n;
        }
    }
}

