/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.types.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultReference {
    private static final String CLASS_NAME = "org.opends.server.types.SearchResultReference";
    private List<Control> controls;
    private List<String> referralURLs;

    public SearchResultReference(String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.referralURLs = new ArrayList<String>(1);
        this.referralURLs.add(string);
        this.controls = new ArrayList<Control>(0);
    }

    public SearchResultReference(List<String> list) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(list)));
        this.referralURLs = list == null ? new ArrayList<String>() : list;
        this.controls = new ArrayList<Control>(0);
    }

    public SearchResultReference(List<String> list, List<Control> list2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(list), String.valueOf(list2)));
        this.referralURLs = list == null ? new ArrayList<String>() : list;
        this.controls = list2 == null ? new ArrayList<Control>(0) : list2;
    }

    public List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }

    public String getReferralURLString() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLString", new String[0]));
        if (this.referralURLs == null || this.referralURLs.isEmpty()) {
            return "";
        }
        if (this.referralURLs.size() == 1) {
            return this.referralURLs.get(0);
        }
        Iterator<String> iterator = this.referralURLs.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(", ");
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public List<Control> getControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getControls", new String[0]));
        return this.controls;
    }
}

