/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable.logs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.pdf.exception.TableCellSpanException;
import tech.grasshopper.pdf.pojo.cucumber.Row;
import tech.grasshopper.pdf.section.details.executable.logs.Log;
import tech.grasshopper.pdf.section.details.executable.logs.TextLog;
import tech.grasshopper.pdf.section.details.executable.table.TableCellWithMessage;
import tech.grasshopper.pdf.section.details.executable.table.TableColumnOptimizer;

public class TableLog
extends Log {
    @Override
    public AbstractCell display() {
        String displayOriginal = " Displaying original content.";
        try {
            List<Row> rows = this.collectCellData();
            List<Float> columnTextWidths = TableColumnOptimizer.builder().rows(rows).fontsize(8).build().organizeColumnStructure();
            return TableCellWithMessage.builder().rows(rows).columnTextWidths(columnTextWidths).fontsize(8).textColor(this.color).build().createTableCell();
        }
        catch (TableCellSpanException e) {
            String message = e.getMessage().concat(displayOriginal).concat(System.lineSeparator()).concat(this.content);
            return ((TextLog)((TextLog.TextLogBuilder)((TextLog.TextLogBuilder)TextLog.builder().content(message)).color(this.color)).build()).display();
        }
        catch (Exception e) {
            String message = "Exception occured in displaying log.".concat(displayOriginal).concat(System.lineSeparator()).concat(this.content);
            return ((TextLog)((TextLog.TextLogBuilder)((TextLog.TextLogBuilder)TextLog.builder().content(message)).color(this.color)).build()).display();
        }
    }

    private List<Row> collectCellData() {
        ArrayList<Row> rows = new ArrayList<Row>();
        Document doc = Jsoup.parseBodyFragment((String)this.content);
        Element tableElement = doc.selectFirst("table");
        if (tableElement != null) {
            for (Element rowElement : tableElement.select("tr")) {
                ArrayList<String> cells = new ArrayList<String>();
                rows.add(Row.builder().cells(cells).build());
                Elements cellElements = rowElement.select("th");
                cellElements.addAll((Collection)rowElement.select("td"));
                if (cellElements.isEmpty()) continue;
                for (Element cell : cellElements) {
                    this.checkCellSpanAttribute(cell);
                    cells.add(cell.text());
                }
            }
        }
        return rows;
    }

    private void checkCellSpanAttribute(Element cell) {
        String rowSpanAttr = cell.attr("rowspan").trim();
        String colSpanAttr = cell.attr("colspan").trim();
        if (rowSpanAttr.matches("\\d+") && Integer.parseInt(rowSpanAttr) != 1) {
            throw new TableCellSpanException("Rowspan greater than 1 is not supported.");
        }
        if (colSpanAttr.matches("\\d+") && Integer.parseInt(colSpanAttr) != 1) {
            throw new TableCellSpanException("Colspan greater than 1 is not supported.");
        }
    }

    protected TableLog(TableLogBuilder<?, ?> b) {
        super(b);
    }

    public static TableLogBuilder<?, ?> builder() {
        return new TableLogBuilderImpl();
    }

    private static final class TableLogBuilderImpl
    extends TableLogBuilder<TableLog, TableLogBuilderImpl> {
        private TableLogBuilderImpl() {
        }

        @Override
        protected TableLogBuilderImpl self() {
            return this;
        }

        @Override
        public TableLog build() {
            return new TableLog(this);
        }
    }

    public static abstract class TableLogBuilder<C extends TableLog, B extends TableLogBuilder<C, B>>
    extends Log.LogBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TableLog.TableLogBuilder(super=" + super.toString() + ")";
        }
    }
}

