/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.paginate;

import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.section.summary.SummaryDisplay;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.util.TextUtil;

public class SummaryPaginator {
    private FeatureData data;
    private PaginatedSection section;
    private int maxDataCountPerPage;

    public void paginate() {
        float currentHeight = SummaryDisplay.headerRowHeight();
        int fromIndex = 0;
        int toIndex = 0;
        TextUtil textUtil = SummaryDisplay.featureNameTextUtil();
        for (int i = 0; i < this.data.getFeatures().size(); ++i) {
            textUtil.setText(SummaryDisplay.featureNameTextOptimizer.optimizeTextLines(this.data.getFeatures().get(i).getName()));
            if ((currentHeight += textUtil.tableRowHeight()) > 470.0f || toIndex - fromIndex + 1 > this.maxDataCountPerPage) {
                this.section.generateDisplay(fromIndex, toIndex);
                fromIndex = toIndex;
                currentHeight = SummaryDisplay.headerRowHeight();
                --i;
                continue;
            }
            ++toIndex;
        }
        this.section.generateDisplay(fromIndex, toIndex);
    }

    SummaryPaginator(FeatureData data, PaginatedSection section, int maxDataCountPerPage) {
        this.data = data;
        this.section = section;
        this.maxDataCountPerPage = maxDataCountPerPage;
    }

    public static SummaryPaginatorBuilder builder() {
        return new SummaryPaginatorBuilder();
    }

    public static class SummaryPaginatorBuilder {
        private FeatureData data;
        private PaginatedSection section;
        private int maxDataCountPerPage;

        SummaryPaginatorBuilder() {
        }

        public SummaryPaginatorBuilder data(FeatureData data) {
            this.data = data;
            return this;
        }

        public SummaryPaginatorBuilder section(PaginatedSection section) {
            this.section = section;
            return this;
        }

        public SummaryPaginatorBuilder maxDataCountPerPage(int maxDataCountPerPage) {
            this.maxDataCountPerPage = maxDataCountPerPage;
            return this;
        }

        public SummaryPaginator build() {
            return new SummaryPaginator(this.data, this.section, this.maxDataCountPerPage);
        }

        public String toString() {
            return "SummaryPaginator.SummaryPaginatorBuilder(data=" + this.data + ", section=" + this.section + ", maxDataCountPerPage=" + this.maxDataCountPerPage + ")";
        }
    }
}

