/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.dashboard;

import java.awt.Color;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.config.SummaryConfig;
import tech.grasshopper.pdf.data.SummaryData;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.section.dashboard.DashboardDisplayUtil;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.footer.CroppedMessage;
import tech.grasshopper.pdf.util.DateUtil;

public class DashboardDetailsDisplay
extends Display {
    private Table.TableBuilder tableBuilder;
    private static final PDFont TITLE_FONT = ReportFont.BOLD_FONT;
    private static final int TITLE_FONT_SIZE = 20;
    private static final float TITLE_PADDING = 10.0f;
    private final TextLengthOptimizer optimizer = TextLengthOptimizer.builder().font(TITLE_FONT).fontsize(20).availableSpace(460.0f).build();
    private final SummaryConfig summaryConfig = this.reportConfig.getSummaryConfig();
    private final SummaryData summaryData = (SummaryData)this.displayData;
    private static final String CROPPED_MESSAGE = "* The report title has been cropped to fit in the available space.";

    @Override
    public void display() {
        this.headerRowDisplay();
        this.statisticsRowDisplay();
        this.chartTitleRowDisplay();
        this.chartDataRowDisplay();
        this.croppedMessageDisplay();
    }

    private void headerRowDisplay() {
        String now = LocalDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        String title = sanitizer.sanitizeText(this.optimizer.optimizeTextLines(this.summaryConfig.getTitle()));
        this.tableBuilder.addRow(Row.builder().padding(10.0f).verticalAlignment(VerticalAlignment.BOTTOM).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().font(TITLE_FONT)).fontSize(Integer.valueOf(20))).colSpan(4)).horizontalAlignment(HorizontalAlignment.LEFT)).text(title).textColor(this.summaryConfig.titleColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().font(ReportFont.REGULAR_FONT)).fontSize(Integer.valueOf(14))).horizontalAlignment(HorizontalAlignment.RIGHT)).text(now).textColor(this.summaryConfig.dateColor())).build()).build()).addRow(DashboardDisplayUtil.spacerRow());
    }

    private void statisticsRowDisplay() {
        String testRunStart = "Start : " + DateUtil.formatDateTimeWithMillis(this.summaryData.getTestRunStartTime());
        String testRunEnd = "End : " + DateUtil.formatDateTimeWithMillis(this.summaryData.getTestRunEndTime());
        String testRunDuration = "Duration : " + DateUtil.durationValue(this.summaryData.getTestRunDuration());
        this.tableBuilder.addRow(Row.builder().font(ReportFont.BOLD_ITALIC_FONT).fontSize(Integer.valueOf(13)).backgroundColor(Color.LIGHT_GRAY).borderWidth(1.0f).borderColor(Color.BLACK).padding(8.0f).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(testRunStart).textColor(this.summaryConfig.timeColor())).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(testRunEnd).textColor(this.summaryConfig.timeColor())).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(testRunDuration).fontSize(Integer.valueOf(15))).textColor(this.summaryConfig.timeColor())).build()).build()).addRow(DashboardDisplayUtil.spacerRow());
    }

    private void chartTitleRowDisplay() {
        this.tableBuilder.addRow(Row.builder().font(ReportFont.ITALIC_FONT).fontSize(Integer.valueOf(14)).borderWidth(1.0f).borderColor(Color.LIGHT_GRAY).padding(8.0f).add((AbstractCell)TextCell.builder().text("Features").build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)TextCell.builder().text("Scenarios").build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)TextCell.builder().text("Steps").build()).build()).addRow(DashboardDisplayUtil.spacerRow());
    }

    private void chartDataRowDisplay() {
        this.tableBuilder.addRow(this.chartDataRowDisplay(Status.PASSED, this.summaryData.getPassedFeatures(), this.summaryData.getPassedScenarios(), this.summaryData.getPassedSteps(), this.reportConfig.passedColor())).addRow(this.chartDataRowDisplay(Status.FAILED, this.summaryData.getFailedFeatures(), this.summaryData.getFailedScenarios(), this.summaryData.getFailedSteps(), this.reportConfig.failedColor())).addRow(this.chartDataRowDisplay(Status.SKIPPED, this.summaryData.getSkippedFeatures(), this.summaryData.getSkippedScenarios(), this.summaryData.getSkippedSteps(), this.reportConfig.skippedColor())).addRow(DashboardDisplayUtil.spacerRow());
    }

    private Row chartDataRowDisplay(Status status, int featureCount, int scenarioCount, int stepCount, Color textColor) {
        return Row.builder().font(ReportFont.ITALIC_FONT).fontSize(Integer.valueOf(12)).backgroundColor(Color.DARK_GRAY).textColor(textColor).add((AbstractCell)TextCell.builder().text((Object)((Object)status) + " - " + featureCount).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)TextCell.builder().text((Object)((Object)status) + " - " + scenarioCount).build()).add((AbstractCell)DashboardDisplayUtil.spacerCell()).add((AbstractCell)TextCell.builder().text((Object)((Object)status) + " - " + stepCount).build()).build();
    }

    private void croppedMessageDisplay() {
        if (this.optimizer.isTextTrimmed()) {
            CroppedMessage.builder().content(this.content).message(CROPPED_MESSAGE).build().displayMessage();
        }
    }

    protected DashboardDetailsDisplay(DashboardDetailsDisplayBuilder<?, ?> b) {
        super(b);
        this.tableBuilder = ((DashboardDetailsDisplayBuilder)b).tableBuilder;
    }

    public static DashboardDetailsDisplayBuilder<?, ?> builder() {
        return new DashboardDetailsDisplayBuilderImpl();
    }

    void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    private static final class DashboardDetailsDisplayBuilderImpl
    extends DashboardDetailsDisplayBuilder<DashboardDetailsDisplay, DashboardDetailsDisplayBuilderImpl> {
        private DashboardDetailsDisplayBuilderImpl() {
        }

        @Override
        protected DashboardDetailsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardDetailsDisplay build() {
            return new DashboardDetailsDisplay(this);
        }
    }

    public static abstract class DashboardDetailsDisplayBuilder<C extends DashboardDetailsDisplay, B extends DashboardDetailsDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Table.TableBuilder tableBuilder;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardDetailsDisplay.DashboardDetailsDisplayBuilder(super=" + super.toString() + ", tableBuilder=" + this.tableBuilder + ")";
        }
    }
}

