/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.table;

import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.cell.CellStyles;
import tech.grasshopper.excel.report.cell.ValueOption;
import tech.grasshopper.extent.data.pojo.Executable;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class ExceptionsTable {
    private XSSFSheet sheet;
    private String startCell;
    private List<Feature> exceptionsData;
    private final int[] columnCellCount = new int[]{1, 1, 1, 1};

    public void writeTableValues() {
        CellOperations cellOperations = CellOperations.builder().sheet(this.sheet).build();
        CellReference cellRef = new CellReference(this.startCell);
        int startRow = cellRef.getRow();
        int startCol = cellRef.getCol();
        int rowCount = (int)this.exceptionsData.stream().mapToLong(f -> f.getTotalSteps()).sum();
        cellOperations.createCellsWithStyleInRange(startRow, startRow + rowCount, startCol, startCol + Arrays.stream(this.columnCellCount).sum());
        int currentRow = startRow;
        for (Feature feature : this.exceptionsData) {
            int currentCol = startCol;
            cellOperations.mergeRows(currentRow, (int)feature.getTotalSteps(), currentCol, this.columnCellCount[0]);
            cellOperations.writeValue(new CellReference(currentRow, currentCol), feature.getName(), CellStyles.getStatusColorStyle(feature.getStatus()), ValueOption.STATUS_COLOR);
            currentCol += this.columnCellCount[0];
            for (Scenario scenario : feature.getScenarios()) {
                cellOperations.mergeRows(currentRow, (int)scenario.getTotalSteps(), currentCol, this.columnCellCount[1]);
                cellOperations.writeValue(new CellReference(currentRow, currentCol), scenario.getName(), CellStyles.getStatusColorStyle(scenario.getStatus()), ValueOption.STATUS_COLOR);
                currentCol += this.columnCellCount[1];
                for (Executable executable : scenario.getStackTraceExecutables()) {
                    cellOperations.mergeRows(currentRow, 1, currentCol, this.columnCellCount[2]);
                    cellOperations.writeValue(new CellReference(currentRow, currentCol), executable.getName(), CellStyles.getStatusColorStyle(executable.getStatus()), ValueOption.STATUS_COLOR);
                    cellOperations.mergeRows(currentRow, 1, currentCol += this.columnCellCount[2], this.columnCellCount[3]);
                    cellOperations.writeValue(new CellReference(currentRow, currentCol), executable.getErrorMessage(), CellStyles.getStatusColorStyle(executable.getStatus()), ValueOption.STATUS_COLOR);
                    currentCol -= this.columnCellCount[2];
                    ++currentRow;
                }
                currentCol -= this.columnCellCount[1];
            }
        }
    }

    ExceptionsTable(XSSFSheet sheet, String startCell, List<Feature> exceptionsData) {
        this.sheet = sheet;
        this.startCell = startCell;
        this.exceptionsData = exceptionsData;
    }

    public static ExceptionsTableBuilder builder() {
        return new ExceptionsTableBuilder();
    }

    public static class ExceptionsTableBuilder {
        private XSSFSheet sheet;
        private String startCell;
        private List<Feature> exceptionsData;

        ExceptionsTableBuilder() {
        }

        public ExceptionsTableBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public ExceptionsTableBuilder startCell(String startCell) {
            this.startCell = startCell;
            return this;
        }

        public ExceptionsTableBuilder exceptionsData(List<Feature> exceptionsData) {
            this.exceptionsData = exceptionsData;
            return this;
        }

        public ExceptionsTable build() {
            return new ExceptionsTable(this.sheet, this.startCell, this.exceptionsData);
        }

        public String toString() {
            return "ExceptionsTable.ExceptionsTableBuilder(sheet=" + this.sheet + ", startCell=" + this.startCell + ", exceptionsData=" + this.exceptionsData + ")";
        }
    }
}

