/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.pojo;

import java.time.Duration;
import java.time.LocalDateTime;
import tech.grasshopper.excel.report.exception.ExcelReportException;
import tech.grasshopper.extent.data.pojo.Status;

public abstract class BaseEntity {
    protected String name;
    protected Status status;
    protected LocalDateTime startTime;
    protected LocalDateTime endTime;

    public Duration calculatedDuration() {
        return Duration.between(this.startTime, this.endTime);
    }

    protected void checkTimeData() {
        if (this.startTime == null) {
            throw new ExcelReportException("Start Time not present for " + this.getClass().getName() + " - " + this.getName());
        }
        if (this.endTime == null) {
            throw new ExcelReportException("End Time not present for " + this.getClass().getName() + " - " + this.getName());
        }
        if (this.startTime.compareTo(this.endTime) > 0) {
            throw new ExcelReportException("Start Time is later than End time for " + this.getClass().getName() + " - " + this.getName());
        }
    }

    public void checkData() {
        this.checkTimeData();
    }

    protected BaseEntity(BaseEntityBuilder<?, ?> b) {
        this.name = ((BaseEntityBuilder)b).name;
        this.status = ((BaseEntityBuilder)b).status;
        this.startTime = ((BaseEntityBuilder)b).startTime;
        this.endTime = ((BaseEntityBuilder)b).endTime;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    public String toString() {
        return "BaseEntity(name=" + this.getName() + ", status=" + (Object)((Object)this.getStatus()) + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }

    public static abstract class BaseEntityBuilder<C extends BaseEntity, B extends BaseEntityBuilder<C, B>> {
        private String name;
        private Status status;
        private LocalDateTime startTime;
        private LocalDateTime endTime;

        protected abstract B self();

        public abstract C build();

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B status(Status status) {
            this.status = status;
            return this.self();
        }

        public B startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this.self();
        }

        public B endTime(LocalDateTime endTime) {
            this.endTime = endTime;
            return this.self();
        }

        public String toString() {
            return "BaseEntity.BaseEntityBuilder(name=" + this.name + ", status=" + (Object)((Object)this.status) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
        }
    }
}

