/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StackTraceProcessor {
    private List<Log> logs;

    public String process() {
        List failAndSkipLogs = this.logs.stream().filter(l -> l.getStatus() == Status.FAIL || l.getStatus() == Status.SKIP).collect(Collectors.toList());
        String stack = "";
        for (Log log : failAndSkipLogs) {
            if (log.getException() != null) {
                stack = log.getException().getStackTrace();
                continue;
            }
            stack = this.stripMarkup(log.getDetails());
        }
        return stack;
    }

    private String stripMarkup(String markup) {
        if (markup == null || markup.isEmpty()) {
            return "";
        }
        int start = markup.indexOf(">", markup.indexOf("<textarea"));
        int end = markup.indexOf("</textarea");
        if (start == -1 || end == -1) {
            return markup;
        }
        return markup.substring(start + 1, end);
    }

    private static List<Log> $default$logs() {
        return new ArrayList<Log>();
    }

    StackTraceProcessor(List<Log> logs) {
        this.logs = logs;
    }

    public static StackTraceProcessorBuilder builder() {
        return new StackTraceProcessorBuilder();
    }

    public static class StackTraceProcessorBuilder {
        private boolean logs$set;
        private List<Log> logs$value;

        StackTraceProcessorBuilder() {
        }

        public StackTraceProcessorBuilder logs(List<Log> logs) {
            this.logs$value = logs;
            this.logs$set = true;
            return this;
        }

        public StackTraceProcessor build() {
            List logs$value = this.logs$value;
            if (!this.logs$set) {
                logs$value = StackTraceProcessor.$default$logs();
            }
            return new StackTraceProcessor(logs$value);
        }

        public String toString() {
            return "StackTraceProcessor.StackTraceProcessorBuilder(logs$value=" + this.logs$value + ")";
        }
    }
}

