/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.split;

import java.io.IOException;
import java.util.LinkedList;
import org.vandeseer.easytable.split.CellDataSplitter;
import org.vandeseer.easytable.split.MinimumHeightSplitCellException;
import org.vandeseer.easytable.split.SplitCellData;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphProcessable;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Paragraph;

public class ParagraphCellDataSplitter
implements CellDataSplitter {
    private ParagraphCell cell;
    private float availableHeight;
    private float lineSpacing;

    @Override
    public SplitCellData splitContents() {
        Paragraph wrappedParagraph = this.cell.getParagraph().getWrappedParagraph();
        if (wrappedParagraph.isEmpty()) {
            return this.emptyParagraphCellData();
        }
        wrappedParagraph.forEach(t -> {
            try {
                if (t.getHeight() + this.cell.getVerticalPadding() > this.availableHeight) {
                    throw new MinimumHeightSplitCellException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        Dividable.Divided divided = wrappedParagraph.divide(this.availableHeight - this.cell.getVerticalPadding(), 0.0f);
        SplitCellData data = new SplitCellData();
        this.updateSamePageCellData(divided, data);
        this.updateNextPageCellData(divided, data);
        return data;
    }

    private SplitCellData emptyParagraphCellData() {
        SplitCellData data = new SplitCellData();
        data.setSamePageCell(((TextCell.TextCellBuilder)TextCell.builder().text("")).build());
        data.setNextPageCell(((TextCell.TextCellBuilder)TextCell.builder().text("")).build());
        data.setSamePageCellPresent(true);
        data.setNextPageCellPresent(false);
        data.setSamePageCellHeight(this.cell.getVerticalPadding());
        data.setNextPageCellHeight(this.cell.getVerticalPadding());
        return data;
    }

    private void updateSamePageCellData(Dividable.Divided divided, SplitCellData data) {
        Paragraph headPara = (Paragraph)divided.getFirst();
        ParagraphCell.Paragraph headParagraph = new ParagraphCell.Paragraph(new LinkedList<ParagraphProcessable>());
        headParagraph.setWrappedParagraph(headPara);
        AbstractCell headCell = ((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)((AbstractCell.AbstractCellBuilder)ParagraphCell.builder().paragraph(headParagraph)).settings(this.cell.getSettings())).lineSpacing(this.lineSpacing)).build();
        data.setSamePageCell(headCell);
        data.setSamePageCellPresent(!headPara.isEmpty());
        data.setSamePageCellHeight(((ParagraphCell)headCell).getMinHeight());
    }

    private void updateNextPageCellData(Dividable.Divided divided, SplitCellData data) {
        Paragraph tailPara = (Paragraph)divided.getTail();
        ParagraphCell.Paragraph tailParagraph = new ParagraphCell.Paragraph(new LinkedList<ParagraphProcessable>());
        tailParagraph.setWrappedParagraph(tailPara);
        AbstractCell tailCell = ((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)((AbstractCell.AbstractCellBuilder)ParagraphCell.builder().paragraph(tailParagraph)).settings(this.cell.getSettings())).lineSpacing(this.lineSpacing)).build();
        data.setNextPageCell(tailCell);
        data.setNextPageCellPresent(!tailPara.isEmpty());
        data.setNextPageCellHeight(((ParagraphCell)tailCell).getMinHeight());
    }

    ParagraphCellDataSplitter(ParagraphCell cell, float availableHeight, float lineSpacing) {
        this.cell = cell;
        this.availableHeight = availableHeight;
        this.lineSpacing = lineSpacing;
    }

    public static ParagraphCellDataSplitterBuilder builder() {
        return new ParagraphCellDataSplitterBuilder();
    }

    public static class ParagraphCellDataSplitterBuilder {
        private ParagraphCell cell;
        private float availableHeight;
        private float lineSpacing;

        ParagraphCellDataSplitterBuilder() {
        }

        public ParagraphCellDataSplitterBuilder cell(ParagraphCell cell) {
            this.cell = cell;
            return this;
        }

        public ParagraphCellDataSplitterBuilder availableHeight(float availableHeight) {
            this.availableHeight = availableHeight;
            return this;
        }

        public ParagraphCellDataSplitterBuilder lineSpacing(float lineSpacing) {
            this.lineSpacing = lineSpacing;
            return this;
        }

        public ParagraphCellDataSplitter build() {
            return new ParagraphCellDataSplitter(this.cell, this.availableHeight, this.lineSpacing);
        }

        public String toString() {
            return "ParagraphCellDataSplitter.ParagraphCellDataSplitterBuilder(cell=" + this.cell + ", availableHeight=" + this.availableHeight + ", lineSpacing=" + this.lineSpacing + ")";
        }
    }
}

