/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.Orientation;
import rst.pdfbox.layout.elements.PageFormat;
import rst.pdfbox.layout.elements.render.LayoutHint;
import rst.pdfbox.layout.elements.render.RenderContext;
import rst.pdfbox.layout.elements.render.RenderListener;
import rst.pdfbox.layout.elements.render.Renderer;
import rst.pdfbox.layout.elements.render.VerticalLayoutHint;

public class Document
implements RenderListener {
    public static final PageFormat DEFAULT_PAGE_FORMAT = new PageFormat();
    private final List<Map.Entry<Element, LayoutHint>> elements = new ArrayList<Map.Entry<Element, LayoutHint>>();
    private final List<Renderer> customRenderer = new CopyOnWriteArrayList<Renderer>();
    private final List<RenderListener> renderListener = new CopyOnWriteArrayList<RenderListener>();
    private PDDocument pdDocument;
    private PageFormat pageFormat;

    public Document() {
        this(DEFAULT_PAGE_FORMAT);
    }

    public Document(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this(PageFormat.with().margins(marginLeft, marginRight, marginTop, marginBottom).build());
    }

    @Deprecated
    public Document(PDRectangle mediaBox) {
        this(mediaBox, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Deprecated
    public Document(PDRectangle mediaBox, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this(new PageFormat(mediaBox, Orientation.Portrait, marginLeft, marginRight, marginTop, marginBottom));
    }

    public Document(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public void add(Element element) {
        this.add(element, new VerticalLayoutHint());
    }

    public void add(Element element, LayoutHint layoutHint) {
        this.elements.add(this.createEntry(element, layoutHint));
    }

    private Map.Entry<Element, LayoutHint> createEntry(Element element, LayoutHint layoutHint) {
        return new AbstractMap.SimpleEntry<Element, LayoutHint>(element, layoutHint);
    }

    public void remove(Element element) {
        this.elements.remove(element);
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    @Deprecated
    public float getMarginLeft() {
        return this.getPageFormat().getMarginLeft();
    }

    @Deprecated
    public float getMarginRight() {
        return this.getPageFormat().getMarginRight();
    }

    @Deprecated
    public float getMarginTop() {
        return this.getPageFormat().getMarginTop();
    }

    @Deprecated
    public float getMarginBottom() {
        return this.getPageFormat().getMarginBottom();
    }

    @Deprecated
    public PDRectangle getMediaBox() {
        return this.getPageFormat().getMediaBox();
    }

    @Deprecated
    public Orientation getOrientation() {
        return this.getPageFormat().getOrientation();
    }

    public float getPageWidth() {
        return this.getMediaBox().getWidth() - this.getMarginLeft() - this.getMarginRight();
    }

    public float getPageHeight() {
        return this.getMediaBox().getHeight() - this.getMarginTop() - this.getMarginBottom();
    }

    public PDDocument getPDDocument() {
        if (this.pdDocument == null) {
            this.pdDocument = new PDDocument();
        }
        return this.pdDocument;
    }

    protected void resetPDDocument() {
        this.pdDocument = null;
    }

    public void addRenderer(Renderer renderer) {
        if (renderer != null) {
            this.customRenderer.add(renderer);
        }
    }

    public void removeRenderer(Renderer renderer) {
        this.customRenderer.remove(renderer);
    }

    public PDDocument render() throws IOException {
        PDDocument document = this.getPDDocument();
        RenderContext renderContext = new RenderContext(this, document);
        for (Map.Entry<Element, LayoutHint> entry : this.elements) {
            Element element = entry.getKey();
            LayoutHint layoutHint = entry.getValue();
            boolean success = false;
            Iterator<Renderer> customRendererIterator = this.customRenderer.iterator();
            while (!success && customRendererIterator.hasNext()) {
                success = customRendererIterator.next().render(renderContext, element, layoutHint);
            }
            if (!success) {
                success = renderContext.render(renderContext, element, layoutHint);
            }
            if (success) continue;
            throw new IllegalArgumentException(String.format("neither layout %s nor the render context knows what to do with %s", renderContext.getLayout(), element));
        }
        renderContext.close();
        this.resetPDDocument();
        return document;
    }

    public void save(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.save(out);
        }
    }

    public void save(OutputStream output) throws IOException {
        try (PDDocument document = this.render();){
            try {
                document.save(output);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void addRenderListener(RenderListener listener) {
        if (listener != null) {
            this.renderListener.add(listener);
        }
    }

    public void removeRenderListener(RenderListener listener) {
        this.renderListener.remove(listener);
    }

    @Override
    public void beforePage(RenderContext renderContext) throws IOException {
        for (RenderListener listener : this.renderListener) {
            listener.beforePage(renderContext);
        }
    }

    @Override
    public void afterPage(RenderContext renderContext) throws IOException {
        for (RenderListener listener : this.renderListener) {
            listener.afterPage(renderContext);
        }
    }
}

