/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextLine;
import rst.pdfbox.layout.text.TextSequence;

public class StyledText
implements TextFragment {
    private final String text;
    private final FontDescriptor fontDescriptor;
    private final Color color;
    private final float leftMargin;
    private final float rightMargin;
    private final float baselineOffset;
    private Float width = null;

    public StyledText(String text, float size, PDFont font) {
        this(text, size, font, Color.black);
    }

    public StyledText(String text, float size, PDFont font, Color color) {
        this(text, new FontDescriptor(font, size), color);
    }

    public StyledText(String text, float size, PDFont font, Color color, float baselineOffset) {
        this(text, new FontDescriptor(font, size), color, baselineOffset, 0.0f, 0.0f);
    }

    public StyledText(String text, FontDescriptor fontDescriptor) {
        this(text, fontDescriptor, Color.black);
    }

    public StyledText(String text, FontDescriptor fontDescriptor, Color color) {
        this(text, fontDescriptor, color, 0.0f, 0.0f, 0.0f);
    }

    public StyledText(String text, FontDescriptor fontDescriptor, Color color, float baselineOffset, float leftMargin, float rightMargin) {
        if (text.contains("\n")) {
            throw new IllegalArgumentException("StyledText must not contain line breaks, use TextFragment.LINEBREAK for that");
        }
        if (leftMargin < 0.0f) {
            throw new IllegalArgumentException("leftMargin must be >= 0");
        }
        if (rightMargin < 0.0f) {
            throw new IllegalArgumentException("rightMargin must be >= 0");
        }
        this.text = text;
        this.fontDescriptor = fontDescriptor;
        this.color = color;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.baselineOffset = baselineOffset;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public FontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    @Override
    public float getWidth() throws IOException {
        if (this.width == null) {
            this.width = Float.valueOf(this.getFontDescriptor().getSize() * this.getFontDescriptor().getFont().getStringWidth(this.getText()) / 1000.0f);
            this.width = Float.valueOf(this.width.floatValue() + this.leftMargin);
            this.width = Float.valueOf(this.width.floatValue() + this.rightMargin);
        }
        return this.width.floatValue();
    }

    public float getWidthWithoutMargin() throws IOException {
        return this.getWidth() - this.leftMargin - this.rightMargin;
    }

    @Override
    public float getHeight() throws IOException {
        return this.getFontDescriptor().getSize();
    }

    public float getAsent() throws IOException {
        return this.getFontDescriptor().getSize() * this.getFontDescriptor().getFont().getFontDescriptor().getAscent() / 1000.0f;
    }

    public float getBaselineOffset() {
        return this.baselineOffset;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public float getLeftMargin() {
        return this.leftMargin;
    }

    public float getRightMargin() {
        return this.rightMargin;
    }

    public boolean hasMargin() {
        return this.getLeftMargin() != 0.0f || this.getRightMargin() != 0.0f;
    }

    public TextSequence asSequence() {
        TextLine line = new TextLine();
        line.add(this);
        return line;
    }

    public StyledText inheritAttributes(String text) {
        return this.inheritAttributes(text, this.getLeftMargin(), this.getRightMargin());
    }

    public StyledText inheritAttributes(String text, float leftMargin, float rightMargin) {
        return new StyledText(text, this.getFontDescriptor(), this.getColor(), this.getBaselineOffset(), leftMargin, rightMargin);
    }

    public String toString() {
        return "StyledText [text=" + this.text + ", fontDescriptor=" + this.fontDescriptor + ", width=" + this.width + ", color=" + this.color + ", leftMargin=" + this.leftMargin + ", rightMargin=" + this.rightMargin + ", baselineOffset=" + this.baselineOffset + "]";
    }
}

