/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.split;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.vandeseer.easytable.split.MinimumHeightSplitCellException;
import org.vandeseer.easytable.split.SplitCellData;
import org.vandeseer.easytable.split.TableContainRowSpanCellsException;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

public class TableRowSplitter {
    private Table sourceTable;
    private float currentY;
    private float pageStartY;
    private float pageEndY;
    private Table.TableBuilder targetTableBuilder;

    private void checkForRowSpanCells() {
        if (this.sourceTable.getRows().stream().flatMap(r -> r.getCells().stream()).filter(c -> c.getRowSpan() > 1).count() > 0L) {
            throw new TableContainRowSpanCellsException("Table containing cells with rowspan value greater than 1 cannot be split.");
        }
    }

    public Table splitTableRows() {
        this.checkForRowSpanCells();
        this.targetTableBuilder = Table.builder().settings(this.sourceTable.getSettings());
        this.sourceTable.getColumns().forEach(col -> this.targetTableBuilder.addColumnOfWidth(col.getWidth()));
        this.sourceTable.getRows().forEach(row -> {
            if (!this.doesRowFitInAvailableSpaceInPage((Row)row)) {
                this.targetTableBuilder.addRow((Row)row);
                this.currentY -= row.getHeight();
            } else {
                this.splitRow((Row)row);
            }
        });
        return this.targetTableBuilder.build();
    }

    private void splitRow(Row row) {
        ArrayList<SplitCellData> splitData = new ArrayList<SplitCellData>();
        List<AbstractCell> cells = row.getCells();
        try {
            for (int i = 0; i < cells.size(); ++i) {
                splitData.add(cells.get(i).splitCell(this.currentY - this.pageEndY));
            }
        }
        catch (UnsupportedOperationException e) {
            this.targetTableBuilder.addRow(row);
            this.currentY = this.pageStartY - row.getHeight();
            return;
        }
        catch (MinimumHeightSplitCellException e) {
            this.currentY = this.pageStartY;
            splitData = new ArrayList();
            for (int i = 0; i < cells.size(); ++i) {
                try {
                    splitData.add(cells.get(i).splitCell(this.currentY - this.pageEndY));
                    continue;
                }
                catch (UnsupportedOperationException uoe) {
                    this.targetTableBuilder.addRow(row);
                    this.currentY = this.pageStartY - row.getHeight();
                    return;
                }
            }
        }
        Row.RowBuilder initialRowBuilder = Row.builder().settings(row.getSettings());
        Row.RowBuilder nextRowBuilder = Row.builder().settings(row.getSettings());
        if (splitData.stream().map(SplitCellData::isSamePageCellPresent).filter(d -> d == true).count() > 0L) {
            splitData.forEach(d -> initialRowBuilder.add(d.getSamePageCell()));
            this.targetTableBuilder.addRow(initialRowBuilder.build());
        }
        if (splitData.stream().map(SplitCellData::isNextPageCellPresent).filter(d -> d == true).count() > 0L) {
            this.currentY = this.pageStartY;
            splitData.forEach(d -> nextRowBuilder.add(d.getNextPageCell()));
            this.splitRow(nextRowBuilder.build());
        } else {
            this.currentY -= ((Float)Collections.max(splitData.stream().map(SplitCellData::getSamePageCellHeight).collect(Collectors.toList()))).floatValue();
        }
    }

    private boolean doesRowFitInAvailableSpaceInPage(Row row) {
        return this.currentY - this.getHighestCellOf(row).floatValue() < this.pageEndY;
    }

    private Float getHighestCellOf(Row row) {
        return row.getCells().stream().map(AbstractCell::getMinHeight).max(Comparator.naturalOrder()).orElse(Float.valueOf(row.getHeight()));
    }

    TableRowSplitter(Table sourceTable, float currentY, float pageStartY, float pageEndY, Table.TableBuilder targetTableBuilder) {
        this.sourceTable = sourceTable;
        this.currentY = currentY;
        this.pageStartY = pageStartY;
        this.pageEndY = pageEndY;
        this.targetTableBuilder = targetTableBuilder;
    }

    public static TableRowSplitterBuilder builder() {
        return new TableRowSplitterBuilder();
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public float getCurrentY() {
        return this.currentY;
    }

    public float getPageStartY() {
        return this.pageStartY;
    }

    public float getPageEndY() {
        return this.pageEndY;
    }

    public void setSourceTable(Table sourceTable) {
        this.sourceTable = sourceTable;
    }

    public void setCurrentY(float currentY) {
        this.currentY = currentY;
    }

    public void setPageStartY(float pageStartY) {
        this.pageStartY = pageStartY;
    }

    public void setPageEndY(float pageEndY) {
        this.pageEndY = pageEndY;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableRowSplitter)) {
            return false;
        }
        TableRowSplitter other = (TableRowSplitter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getCurrentY(), other.getCurrentY()) != 0) {
            return false;
        }
        if (Float.compare(this.getPageStartY(), other.getPageStartY()) != 0) {
            return false;
        }
        if (Float.compare(this.getPageEndY(), other.getPageEndY()) != 0) {
            return false;
        }
        Table this$sourceTable = this.getSourceTable();
        Table other$sourceTable = other.getSourceTable();
        if (this$sourceTable == null ? other$sourceTable != null : !this$sourceTable.equals(other$sourceTable)) {
            return false;
        }
        Table.TableBuilder this$targetTableBuilder = this.getTargetTableBuilder();
        Table.TableBuilder other$targetTableBuilder = other.getTargetTableBuilder();
        return !(this$targetTableBuilder == null ? other$targetTableBuilder != null : !this$targetTableBuilder.equals(other$targetTableBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableRowSplitter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getCurrentY());
        result = result * 59 + Float.floatToIntBits(this.getPageStartY());
        result = result * 59 + Float.floatToIntBits(this.getPageEndY());
        Table $sourceTable = this.getSourceTable();
        result = result * 59 + ($sourceTable == null ? 43 : $sourceTable.hashCode());
        Table.TableBuilder $targetTableBuilder = this.getTargetTableBuilder();
        result = result * 59 + ($targetTableBuilder == null ? 43 : $targetTableBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "TableRowSplitter(sourceTable=" + this.getSourceTable() + ", currentY=" + this.getCurrentY() + ", pageStartY=" + this.getPageStartY() + ", pageEndY=" + this.getPageEndY() + ", targetTableBuilder=" + this.getTargetTableBuilder() + ")";
    }

    private Table.TableBuilder getTargetTableBuilder() {
        return this.targetTableBuilder;
    }

    private void setTargetTableBuilder(Table.TableBuilder targetTableBuilder) {
        this.targetTableBuilder = targetTableBuilder;
    }

    public static class TableRowSplitterBuilder {
        private Table sourceTable;
        private float currentY;
        private float pageStartY;
        private float pageEndY;
        private Table.TableBuilder targetTableBuilder;

        TableRowSplitterBuilder() {
        }

        public TableRowSplitterBuilder sourceTable(Table sourceTable) {
            this.sourceTable = sourceTable;
            return this;
        }

        public TableRowSplitterBuilder currentY(float currentY) {
            this.currentY = currentY;
            return this;
        }

        public TableRowSplitterBuilder pageStartY(float pageStartY) {
            this.pageStartY = pageStartY;
            return this;
        }

        public TableRowSplitterBuilder pageEndY(float pageEndY) {
            this.pageEndY = pageEndY;
            return this;
        }

        public TableRowSplitterBuilder targetTableBuilder(Table.TableBuilder targetTableBuilder) {
            this.targetTableBuilder = targetTableBuilder;
            return this;
        }

        public TableRowSplitter build() {
            return new TableRowSplitter(this.sourceTable, this.currentY, this.pageStartY, this.pageEndY, this.targetTableBuilder);
        }

        public String toString() {
            return "TableRowSplitter.TableRowSplitterBuilder(sourceTable=" + this.sourceTable + ", currentY=" + this.currentY + ", pageStartY=" + this.pageStartY + ", pageEndY=" + this.pageEndY + ", targetTableBuilder=" + this.targetTableBuilder + ")";
        }
    }
}

