/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.split;

import org.vandeseer.easytable.split.CellDataSplitter;
import org.vandeseer.easytable.split.MinimumHeightSplitCellException;
import org.vandeseer.easytable.split.SplitCellData;
import org.vandeseer.easytable.split.TableContainRowSpanCellsException;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;

public class TableWithinTableCellDataSplitter
implements CellDataSplitter {
    private TableWithinTableCell cell;
    private float availableHeight;

    @Override
    public SplitCellData splitContents() {
        this.checkForRowSpanCells();
        if (this.cell.getTable().getRows().get(0).getHeight() + this.cell.getVerticalPadding() > this.availableHeight) {
            throw new MinimumHeightSplitCellException();
        }
        SplitCellData data = new SplitCellData();
        Table.TableBuilder samePageTableBuilder = Table.builder().settings(this.cell.getTable().getSettings());
        Table.TableBuilder nextPageTableBuilder = Table.builder().settings(this.cell.getTable().getSettings());
        this.cell.getTable().getColumns().forEach(col -> {
            samePageTableBuilder.addColumnOfWidth(col.getWidth());
            nextPageTableBuilder.addColumnOfWidth(col.getWidth());
        });
        float rowHeightSum = this.cell.getVerticalPadding();
        boolean samePageTableExists = false;
        boolean nextPageTableExists = false;
        for (Row row : this.cell.getTable().getRows()) {
            if ((rowHeightSum += row.getHeight()) < this.availableHeight) {
                samePageTableExists = true;
                samePageTableBuilder.addRow(row);
                continue;
            }
            nextPageTableExists = true;
            nextPageTableBuilder.addRow(row);
        }
        if (samePageTableExists) {
            Table samePageTable = samePageTableBuilder.build();
            data.setSamePageCell(((TableWithinTableCell.TableWithinTableCellBuilder)((AbstractCell.AbstractCellBuilder)TableWithinTableCell.builder().table(samePageTable)).settings(this.cell.getSettings())).build());
            data.setSamePageCellPresent(true);
            data.setSamePageCellHeight(samePageTable.getHeight() + this.cell.getVerticalPadding());
        } else {
            data.setSamePageCell(((TextCell.TextCellBuilder)TextCell.builder().text("")).build());
            data.setSamePageCellPresent(false);
            data.setSamePageCellHeight(this.cell.getVerticalPadding());
        }
        if (nextPageTableExists) {
            Table nextPageTable = nextPageTableBuilder.build();
            data.setNextPageCell(((TableWithinTableCell.TableWithinTableCellBuilder)((AbstractCell.AbstractCellBuilder)TableWithinTableCell.builder().table(nextPageTable)).settings(this.cell.getSettings())).build());
            data.setNextPageCellPresent(true);
            data.setNextPageCellHeight(nextPageTable.getHeight() + this.cell.getVerticalPadding());
        } else {
            data.setNextPageCell(((TextCell.TextCellBuilder)TextCell.builder().text("")).build());
            data.setNextPageCellPresent(false);
            data.setNextPageCellHeight(this.cell.getVerticalPadding());
        }
        return data;
    }

    private void checkForRowSpanCells() {
        if (this.cell.getTable().getRows().stream().flatMap(r -> r.getCells().stream()).filter(c -> c.getRowSpan() > 1).count() > 0L) {
            throw new TableContainRowSpanCellsException("TableWithinTable containing cells with rowspan value greater than 1 cannot be split.");
        }
    }

    TableWithinTableCellDataSplitter(TableWithinTableCell cell, float availableHeight) {
        this.cell = cell;
        this.availableHeight = availableHeight;
    }

    public static TableWithinTableCellDataSplitterBuilder builder() {
        return new TableWithinTableCellDataSplitterBuilder();
    }

    public static class TableWithinTableCellDataSplitterBuilder {
        private TableWithinTableCell cell;
        private float availableHeight;

        TableWithinTableCellDataSplitterBuilder() {
        }

        public TableWithinTableCellDataSplitterBuilder cell(TableWithinTableCell cell) {
            this.cell = cell;
            return this;
        }

        public TableWithinTableCellDataSplitterBuilder availableHeight(float availableHeight) {
            this.availableHeight = availableHeight;
            return this;
        }

        public TableWithinTableCellDataSplitter build() {
            return new TableWithinTableCellDataSplitter(this.cell, this.availableHeight);
        }

        public String toString() {
            return "TableWithinTableCellDataSplitter.TableWithinTableCellDataSplitterBuilder(cell=" + this.cell + ", availableHeight=" + this.availableHeight + ")";
        }
    }
}

