/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell.paragraph;

import java.util.EnumMap;
import java.util.Map;
import lombok.NonNull;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphProcessable;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.text.BaseFont;

public class Markup
implements ParagraphProcessable {
    public static final Map<MarkupSupportedFont, BaseFont> FONT_MAP = new EnumMap<MarkupSupportedFont, BaseFont>(MarkupSupportedFont.class);
    @NonNull
    private String markup;
    @NonNull
    private MarkupSupportedFont font;
    private Float fontSize;

    @Override
    public void process(Paragraph paragraph, Settings settings) {
        Float fontSize = Float.valueOf(this.getFontSize() != null ? this.getFontSize().floatValue() : (float)settings.getFontSize().intValue());
        paragraph.addMarkup(this.getMarkup(), fontSize.floatValue(), FONT_MAP.get((Object)this.getFont()));
    }

    Markup(@NonNull String markup, @NonNull MarkupSupportedFont font, Float fontSize) {
        if (markup == null) {
            throw new NullPointerException("markup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        this.markup = markup;
        this.font = font;
        this.fontSize = fontSize;
    }

    public static MarkupBuilder builder() {
        return new MarkupBuilder();
    }

    @NonNull
    public String getMarkup() {
        return this.markup;
    }

    @NonNull
    public MarkupSupportedFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    static {
        FONT_MAP.put(MarkupSupportedFont.HELVETICA, BaseFont.Helvetica);
        FONT_MAP.put(MarkupSupportedFont.COURIER, BaseFont.Courier);
        FONT_MAP.put(MarkupSupportedFont.TIMES, BaseFont.Times);
    }

    public static class MarkupBuilder {
        private String markup;
        private MarkupSupportedFont font;
        private Float fontSize;

        MarkupBuilder() {
        }

        public MarkupBuilder markup(@NonNull String markup) {
            if (markup == null) {
                throw new NullPointerException("markup is marked non-null but is null");
            }
            this.markup = markup;
            return this;
        }

        public MarkupBuilder font(@NonNull MarkupSupportedFont font) {
            if (font == null) {
                throw new NullPointerException("font is marked non-null but is null");
            }
            this.font = font;
            return this;
        }

        public MarkupBuilder fontSize(Float fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public Markup build() {
            return new Markup(this.markup, this.font, this.fontSize);
        }

        public String toString() {
            return "Markup.MarkupBuilder(markup=" + this.markup + ", font=" + (Object)((Object)this.font) + ", fontSize=" + this.fontSize + ")";
        }
    }

    public static enum MarkupSupportedFont {
        TIMES,
        COURIER,
        HELVETICA;

    }
}

