/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.metric;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.search.Search;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;

@WebEndpoint(id="jhimetrics")
public class JHipsterMetricsEndpoint {
    private final MeterRegistry meterRegistry;
    private final Logger logger = LoggerFactory.getLogger(JHipsterMetricsEndpoint.class);
    public static final String MISSING_NAME_TAG_MESSAGE = "Missing name tag for metric {}";

    public JHipsterMetricsEndpoint(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @ReadOperation
    public Map<String, Map<?, ?>> allMetrics() {
        HashMap results = new HashMap();
        results.put("jvm", this.jvmMemoryMetrics());
        results.put("http.server.requests", this.httpRequestsMetrics());
        results.put("cache", this.cacheMetrics());
        results.put("services", this.serviceMetrics());
        results.put("databases", this.databaseMetrics());
        results.put("garbageCollector", this.garbageCollectorMetrics());
        results.put("processMetrics", this.processMetrics());
        return results;
    }

    private Map<String, Number> processMetrics() {
        HashMap<String, Number> resultsProcess = new HashMap<String, Number>();
        Collection gauges = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("cpu") || s.contains("system") || s.contains("process")).gauges();
        gauges.forEach(gauge -> resultsProcess.put(gauge.getId().getName(), gauge.value()));
        Collection timeGauges = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("process")).timeGauges();
        timeGauges.forEach(gauge -> resultsProcess.put(gauge.getId().getName(), gauge.value(TimeUnit.MILLISECONDS)));
        return resultsProcess;
    }

    private Map<String, Object> garbageCollectorMetrics() {
        HashMap<String, Object> resultsGarbageCollector = new HashMap<String, Object>();
        Collection timers = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.gc.pause")).timers();
        timers.forEach(timer -> {
            ValueAtPercentile[] percentiles;
            String key = timer.getId().getName();
            HashMap<String, Number> gcPauseResults = new HashMap<String, Number>();
            gcPauseResults.put("count", timer.count());
            gcPauseResults.put("max", timer.max(TimeUnit.MILLISECONDS));
            gcPauseResults.put("totalTime", timer.totalTime(TimeUnit.MILLISECONDS));
            gcPauseResults.put("mean", timer.mean(TimeUnit.MILLISECONDS));
            for (ValueAtPercentile percentile : percentiles = timer.takeSnapshot().percentileValues()) {
                gcPauseResults.put(String.valueOf(percentile.percentile()), percentile.value(TimeUnit.MILLISECONDS));
            }
            resultsGarbageCollector.putIfAbsent(key, gcPauseResults);
        });
        Collection gauges = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.gc") && !s.contains("jvm.gc.pause")).gauges();
        gauges.forEach(gauge -> resultsGarbageCollector.put(gauge.getId().getName(), gauge.value()));
        Collection counters = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.gc") && !s.contains("jvm.gc.pause")).counters();
        counters.forEach(counter -> resultsGarbageCollector.put(counter.getId().getName(), counter.count()));
        gauges = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.classes.loaded")).gauges();
        Double classesLoaded = gauges.stream().mapToDouble(Gauge::value).sum();
        resultsGarbageCollector.put("classesLoaded", classesLoaded);
        Collection functionCounters = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.classes.unloaded")).functionCounters();
        Double classesUnloaded = functionCounters.stream().mapToDouble(FunctionCounter::count).sum();
        resultsGarbageCollector.put("classesUnloaded", classesUnloaded);
        return resultsGarbageCollector;
    }

    private Map<String, Map<String, Number>> databaseMetrics() {
        HashMap<String, Map<String, Number>> resultsDatabase = new HashMap<String, Map<String, Number>>();
        Collection timers = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("hikari")).timers();
        timers.forEach(timer -> {
            ValueAtPercentile[] percentiles;
            String key = timer.getId().getName().substring(timer.getId().getName().lastIndexOf(46) + 1);
            resultsDatabase.putIfAbsent(key, new HashMap());
            ((Map)resultsDatabase.get(key)).put("count", timer.count());
            ((Map)resultsDatabase.get(key)).put("max", timer.max(TimeUnit.MILLISECONDS));
            ((Map)resultsDatabase.get(key)).put("totalTime", timer.totalTime(TimeUnit.MILLISECONDS));
            ((Map)resultsDatabase.get(key)).put("mean", timer.mean(TimeUnit.MILLISECONDS));
            for (ValueAtPercentile percentile : percentiles = timer.takeSnapshot().percentileValues()) {
                ((Map)resultsDatabase.get(key)).put(String.valueOf(percentile.percentile()), percentile.value(TimeUnit.MILLISECONDS));
            }
        });
        Collection gauges = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("hikari")).gauges();
        gauges.forEach(gauge -> {
            String key = gauge.getId().getName().substring(gauge.getId().getName().lastIndexOf(46) + 1);
            resultsDatabase.putIfAbsent(key, new HashMap());
            ((Map)resultsDatabase.get(key)).put("value", gauge.value());
        });
        return resultsDatabase;
    }

    private Map<String, Map<?, ?>> serviceMetrics() {
        List<String> crudOperation = Arrays.asList("GET", "POST", "PUT", "DELETE");
        Collection timers = this.meterRegistry.find("http.server.requests").timers();
        Set<String> uris = timers.stream().map(timer -> timer.getId().getTag("uri")).collect(Collectors.toSet());
        HashMap resultsHttpPerUri = new HashMap();
        uris.forEach(uri -> {
            HashMap resultsPerUri = new HashMap();
            crudOperation.forEach(operation -> {
                HashMap<String, Number> resultsPerUriPerCrudOperation = new HashMap<String, Number>();
                Collection httpTimersStream = this.meterRegistry.find("http.server.requests").tags(new String[]{"uri", uri, "method", operation}).timers();
                long count = httpTimersStream.stream().mapToLong(Timer::count).sum();
                if (count != 0L) {
                    double max = httpTimersStream.stream().mapToDouble(x -> x.totalTime(TimeUnit.MILLISECONDS)).max().orElse(0.0);
                    double totalTime = httpTimersStream.stream().mapToDouble(x -> x.totalTime(TimeUnit.MILLISECONDS)).sum();
                    resultsPerUriPerCrudOperation.put("count", count);
                    resultsPerUriPerCrudOperation.put("max", max);
                    resultsPerUriPerCrudOperation.put("mean", totalTime / (double)count);
                    resultsPerUri.put(operation, resultsPerUriPerCrudOperation);
                }
            });
            resultsHttpPerUri.put((String)uri, (Map<?, ?>)resultsPerUri);
        });
        return resultsHttpPerUri;
    }

    private Map<String, Map<String, Number>> cacheMetrics() {
        HashMap<String, Map<String, Number>> resultsCache = new HashMap<String, Map<String, Number>>();
        Collection counters = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("cache") && !s.contains("hibernate")).functionCounters();
        counters.forEach(counter -> {
            String key = counter.getId().getName();
            String name = counter.getId().getTag("name");
            if (name != null) {
                resultsCache.putIfAbsent(name, new HashMap());
                if (counter.getId().getTag("result") != null) {
                    key = key + "." + counter.getId().getTag("result");
                }
                ((Map)resultsCache.get(name)).put(key, counter.count());
            } else {
                this.logger.warn(MISSING_NAME_TAG_MESSAGE, (Object)key);
            }
        });
        Collection gauges = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("cache")).gauges();
        gauges.forEach(gauge -> {
            String key = gauge.getId().getName();
            String name = gauge.getId().getTag("name");
            if (name != null) {
                resultsCache.putIfAbsent(name, new HashMap());
                ((Map)resultsCache.get(name)).put(key, gauge.value());
            } else {
                this.logger.warn(MISSING_NAME_TAG_MESSAGE, (Object)key);
            }
        });
        return resultsCache;
    }

    private Map<String, Map<String, Number>> jvmMemoryMetrics() {
        HashMap<String, Map<String, Number>> resultsJvm = new HashMap<String, Map<String, Number>>();
        Search jvmUsedSearch = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.memory.used"));
        Collection gauges = jvmUsedSearch.gauges();
        gauges.forEach(gauge -> {
            String key = gauge.getId().getTag("id");
            resultsJvm.putIfAbsent(key, new HashMap());
            ((Map)resultsJvm.get(key)).put("used", gauge.value());
        });
        Search jvmMaxSearch = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.memory.max"));
        gauges = jvmMaxSearch.gauges();
        gauges.forEach(gauge -> {
            String key = gauge.getId().getTag("id");
            ((Map)resultsJvm.get(key)).put("max", gauge.value());
        });
        gauges = Search.in((MeterRegistry)this.meterRegistry).name(s -> s.contains("jvm.memory.committed")).gauges();
        gauges.forEach(gauge -> {
            String key = gauge.getId().getTag("id");
            ((Map)resultsJvm.get(key)).put("committed", gauge.value());
        });
        return resultsJvm;
    }

    private Map<String, Map<?, ?>> httpRequestsMetrics() {
        HashSet statusCode = new HashSet();
        Collection timers = this.meterRegistry.find("http.server.requests").timers();
        timers.forEach(timer -> statusCode.add(timer.getId().getTag("status")));
        HashMap resultsHttp = new HashMap();
        HashMap resultsHttpPerCode = new HashMap();
        statusCode.forEach(code -> {
            HashMap<String, Number> resultsPerCode = new HashMap<String, Number>();
            Collection httpTimersStream = this.meterRegistry.find("http.server.requests").tag("status", code).timers();
            long count = httpTimersStream.stream().mapToLong(Timer::count).sum();
            double max = httpTimersStream.stream().mapToDouble(x -> x.max(TimeUnit.MILLISECONDS)).max().orElse(0.0);
            double totalTime = httpTimersStream.stream().mapToDouble(x -> x.totalTime(TimeUnit.MILLISECONDS)).sum();
            resultsPerCode.put("count", count);
            resultsPerCode.put("max", max);
            resultsPerCode.put("mean", count != 0L ? totalTime / (double)count : 0.0);
            resultsHttpPerCode.put(code, resultsPerCode);
        });
        resultsHttp.put("percode", resultsHttpPerCode);
        timers = this.meterRegistry.find("http.server.requests").timers();
        long countAllRequests = timers.stream().mapToLong(Timer::count).sum();
        HashMap<String, Long> resultsHTTPAll = new HashMap<String, Long>();
        resultsHTTPAll.put("count", countAllRequests);
        resultsHttp.put("all", resultsHTTPAll);
        return resultsHttp;
    }
}

