/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Prefer `Class::isInstance` method reference over equivalent lambda expression", link="https://error-prone.picnic.tech/bugpatterns/IsInstanceLambdaUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class IsInstanceLambdaUsage
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher {
    private static final long serialVersionUID = 1L;

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        Tree tree2;
        if (tree.getParameters().size() != 1 || !((tree2 = tree.getBody()) instanceof InstanceOfTree)) {
            return Description.NO_MATCH;
        }
        InstanceOfTree instanceOf = (InstanceOfTree)tree2;
        VariableTree param = (VariableTree)Iterables.getOnlyElement(tree.getParameters());
        if (!ASTHelpers.getSymbol((VariableTree)param).equals(ASTHelpers.getSymbol((Tree)instanceOf.getExpression()))) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)(SourceCode.treeToString((Tree)instanceOf.getType(), (VisitorState)state) + ".class::isInstance")));
    }
}

