/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Inside string expressions single quotes do not need to be escaped", link="https://error-prone.picnic.tech/bugpatterns/RedundantStringEscape", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class RedundantStringEscape
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final long serialVersionUID = 1L;

    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        String constant = (String)ASTHelpers.constValue((Tree)tree, String.class);
        if (constant == null || constant.indexOf(39) < 0) {
            return Description.NO_MATCH;
        }
        String source = SourceCode.treeToString((Tree)tree, (VisitorState)state);
        if (!RedundantStringEscape.containsBannedEscapeSequence(source)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)RedundantStringEscape.dropRedundantEscapeSequences(source)));
    }

    private static boolean containsBannedEscapeSequence(String source) {
        int p = source.indexOf(92);
        while (p != -1) {
            if (source.charAt(p + 1) == '\'') {
                return true;
            }
            p = source.indexOf(92, p + 2);
        }
        return false;
    }

    private static String dropRedundantEscapeSequences(String source) {
        StringBuilder result = new StringBuilder();
        for (int p = 0; p < source.length(); ++p) {
            char c = source.charAt(p);
            if (c == '\\' && source.charAt(p + 1) == '\'') continue;
            result.append(c);
        }
        return result.toString();
    }
}

