/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;

final class AssertJIterableRules {
    private AssertJIterableRules() {
    }

    static final class AssertThatIterableHasOneElementEqualTo<S, E extends S> {
        AssertThatIterableHasOneElementEqualTo() {
        }

        ObjectAssert<S> before(Iterable<S> iterable, E element) {
            return (ObjectAssert)Assertions.assertThat((Object)Iterables.getOnlyElement(iterable)).isEqualTo(element);
        }

        IterableAssert<S> after(Iterable<S> iterable, E element) {
            return (IterableAssert)Assertions.assertThat(iterable).containsExactly(new Object[]{element});
        }
    }

    static final class AssertThatIterableSize<E> {
        AssertThatIterableSize() {
        }

        AbstractIntegerAssert<?> before(Iterable<E> iterable) {
            return Assertions.assertThat((int)Iterables.size(iterable));
        }

        AbstractIntegerAssert<?> before(Collection<E> iterable) {
            return Assertions.assertThat((int)iterable.size());
        }

        AbstractIntegerAssert<?> after(Iterable<E> iterable) {
            return Assertions.assertThat(iterable).size();
        }
    }

    static final class AssertThatIterableIsNotEmpty<E> {
        AssertThatIterableIsNotEmpty() {
        }

        AbstractAssert<?, ?> before(Iterable<E> iterable) {
            return Assertions.assertThat(iterable.iterator()).hasNext();
        }

        AbstractAssert<?, ?> before(Collection<E> iterable) {
            return Assertions.assertThat((boolean)iterable.isEmpty()).isFalse();
        }

        IterableAssert<E> after(Iterable<E> iterable) {
            return (IterableAssert)Assertions.assertThat(iterable).isNotEmpty();
        }
    }

    static final class AssertThatIterableIsEmpty<E> {
        AssertThatIterableIsEmpty() {
        }

        void before(Iterable<E> iterable) {
            Assertions.assertThat(iterable.iterator()).isExhausted();
        }

        void before(Collection<E> iterable) {
            Assertions.assertThat((boolean)iterable.isEmpty()).isTrue();
        }

        void after(Collection<E> iterable) {
            Assertions.assertThat(iterable).isEmpty();
        }
    }
}

