/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Iterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IteratorAssert;

final class AssertJIteratorRules {
    private AssertJIteratorRules() {
    }

    static final class AssertThatIsExhausted<T> {
        AssertThatIsExhausted() {
        }

        AbstractBooleanAssert<?> before(Iterator<T> iterator) {
            return Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
        }

        IteratorAssert<T> after(Iterator<T> iterator) {
            return (IteratorAssert)Assertions.assertThat(iterator).isExhausted();
        }
    }

    static final class AssertThatHasNext<T> {
        AssertThatHasNext() {
        }

        AbstractBooleanAssert<?> before(Iterator<T> iterator) {
            return Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        }

        IteratorAssert<T> after(Iterator<T> iterator) {
            return (IteratorAssert)Assertions.assertThat(iterator).hasNext();
        }
    }
}

