/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;

final class AssertJMapRules {
    private AssertJMapRules() {
    }

    static final class AssertThatMapDoesNotContainValue<K, V> {
        AssertThatMapDoesNotContainValue() {
        }

        AbstractBooleanAssert<?> before(Map<K, V> map, V value) {
            return Assertions.assertThat((boolean)map.containsValue(value)).isFalse();
        }

        MapAssert<K, V> after(Map<K, V> map, V value) {
            return (MapAssert)Assertions.assertThat(map).doesNotContainValue(value);
        }
    }

    static final class AssertThatMapContainsValue<K, V> {
        AssertThatMapContainsValue() {
        }

        AbstractBooleanAssert<?> before(Map<K, V> map, V value) {
            return Assertions.assertThat((boolean)map.containsValue(value)).isTrue();
        }

        MapAssert<K, V> after(Map<K, V> map, V value) {
            return (MapAssert)Assertions.assertThat(map).containsValue(value);
        }
    }

    static final class AssertThatMapContainsOnlyKeys<K, V> {
        AssertThatMapContainsOnlyKeys() {
        }

        AbstractCollectionAssert<?, Collection<? extends K>, K, ?> before(Map<K, V> map, Iterable<? extends K> keys) {
            return (AbstractCollectionAssert)Assertions.assertThat(map.keySet()).hasSameElementsAs(keys);
        }

        MapAssert<K, V> after(Map<K, V> map, Iterable<? extends K> keys) {
            return (MapAssert)Assertions.assertThat(map).containsOnlyKeys(keys);
        }
    }

    static final class AssertThatMapDoesNotContainKey<K, V> {
        AssertThatMapDoesNotContainKey() {
        }

        AbstractBooleanAssert<?> before(Map<K, V> map, K key) {
            return Assertions.assertThat((boolean)map.containsKey(key)).isFalse();
        }

        MapAssert<K, V> after(Map<K, V> map, K key) {
            return (MapAssert)Assertions.assertThat(map).doesNotContainKey(key);
        }
    }

    static final class AssertThatMapContainsKey<K, V> {
        AssertThatMapContainsKey() {
        }

        AbstractBooleanAssert<?> before(Map<K, V> map, K key) {
            return Assertions.assertThat((boolean)map.containsKey(key)).isTrue();
        }

        MapAssert<K, V> after(Map<K, V> map, K key) {
            return (MapAssert)Assertions.assertThat(map).containsKey(key);
        }
    }

    static final class AbstractMapAssertHasSameSizeAs<K, V> {
        AbstractMapAssertHasSameSizeAs() {
        }

        AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert, Map<?, ?> map) {
            return mapAssert.hasSize(map.size());
        }

        AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert, Map<?, ?> map) {
            return mapAssert.hasSameSizeAs(map);
        }
    }

    static final class AssertThatMapHasSize<K, V> {
        AssertThatMapHasSize() {
        }

        AbstractAssert<?, ?> before(Map<K, V> map, int length) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat((int)map.size()).isEqualTo(length), Assertions.assertThat((Collection)((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values(), map.entrySet()}))).hasSize(length)});
        }

        MapAssert<K, V> after(Map<K, V> map, int length) {
            return (MapAssert)Assertions.assertThat(map).hasSize(length);
        }
    }

    static final class AbstractMapAssertContainsExactlyEntriesOf<K, V> {
        AbstractMapAssertContainsExactlyEntriesOf() {
        }

        AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert, K key, V value) {
            return mapAssert.containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of(key, value));
        }

        AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert, K key, V value) {
            return mapAssert.containsExactlyEntriesOf((Map)ImmutableMap.of(key, value));
        }
    }

    static final class AbstractMapAssertContainsExactlyInAnyOrderEntriesOf<K, V> {
        AbstractMapAssertContainsExactlyInAnyOrderEntriesOf() {
        }

        AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert, Map<? extends K, ? extends V> map) {
            return mapAssert.isEqualTo(map);
        }

        AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert, Map<? extends K, ? extends V> map) {
            return mapAssert.containsExactlyInAnyOrderEntriesOf(map);
        }
    }

    static final class AssertThatMapIsNotEmpty<K, V> {
        AssertThatMapIsNotEmpty() {
        }

        AbstractAssert<?, ?> before(Map<K, V> map) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat((boolean)map.isEmpty()).isFalse(), Assertions.assertThat((int)map.size()).isNotEqualTo(0), Assertions.assertThat((int)map.size()).isPositive(), Assertions.assertThat((Collection)((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values(), map.entrySet()}))).isNotEmpty()});
        }

        MapAssert<K, V> after(Map<K, V> map) {
            return (MapAssert)Assertions.assertThat(map).isNotEmpty();
        }
    }

    static final class AbstractMapAssertIsNotEmpty<K, V> {
        AbstractMapAssertIsNotEmpty() {
        }

        AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert, Map<?, ?> map) {
            return mapAssert.isNotEqualTo(map);
        }

        AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert) {
            return mapAssert.isNotEmpty();
        }
    }

    static final class AssertThatMapIsEmpty<K, V> {
        AssertThatMapIsEmpty() {
        }

        void before(Map<K, V> map) {
            Refaster.anyOf((Object[])new AbstractAssert[]{Assertions.assertThat(map).hasSize(0), Assertions.assertThat((boolean)map.isEmpty()).isTrue(), Assertions.assertThat((int)map.size()).isEqualTo(0L), Assertions.assertThat((int)map.size()).isNotPositive()});
        }

        void before2(Map<K, V> map) {
            Assertions.assertThat((Collection)((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values(), map.entrySet()}))).isEmpty();
        }

        void after(Map<K, V> map) {
            Assertions.assertThat(map).isEmpty();
        }
    }

    static final class AbstractMapAssertIsEmpty<K, V> {
        AbstractMapAssertIsEmpty() {
        }

        void before(AbstractMapAssert<?, ?, K, V> mapAssert, Map<? extends K, ? extends V> wellTypedMap, Map<?, ?> arbitrarilyTypedMap, Iterable<? extends K> keys) {
            Refaster.anyOf((Object[])new AbstractMapAssert[]{mapAssert.containsExactlyEntriesOf(wellTypedMap), mapAssert.containsExactlyInAnyOrderEntriesOf(wellTypedMap), mapAssert.hasSameSizeAs(arbitrarilyTypedMap), mapAssert.isEqualTo(arbitrarilyTypedMap), mapAssert.containsOnlyKeys(keys), mapAssert.containsExactly(new Map.Entry[0]), mapAssert.containsOnly(new Map.Entry[0]), mapAssert.containsOnlyKeys(new Object[0])});
        }

        void after(AbstractMapAssert<?, ?, K, V> mapAssert) {
            mapAssert.isEmpty();
        }
    }
}

