/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.io.IOException;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.ThrowableAssertAlternative;

final class AssertJThrowingCallableRules {
    private AssertJThrowingCallableRules() {
    }

    static final class AbstractThrowableAssertWithFailMessage {
        AbstractThrowableAssertWithFailMessage() {
        }

        AbstractThrowableAssert<?, ? extends Throwable> before(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object args) {
            return (AbstractThrowableAssert)abstractThrowableAssert.withFailMessage(String.format(message, args), new Object[0]);
        }

        AbstractThrowableAssert<?, ? extends Throwable> after(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object args) {
            return (AbstractThrowableAssert)abstractThrowableAssert.withFailMessage(message, new Object[]{args});
        }
    }

    static final class AbstractThrowableAssertHasMessage {
        AbstractThrowableAssertHasMessage() {
        }

        AbstractThrowableAssert<?, ? extends Throwable> before(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object parameters) {
            return abstractThrowableAssert.hasMessage(String.format(message, parameters));
        }

        AbstractThrowableAssert<?, ? extends Throwable> after(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object parameters) {
            return abstractThrowableAssert.hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByHasMessageNotContaining {
        AssertThatThrownByHasMessageNotContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageNotContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessageNotContaining(message);
        }
    }

    static final class AssertThatThrownByHasMessageContaining {
        AssertThatThrownByHasMessageContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessageContaining(message);
        }
    }

    static final class AssertThatThrownByHasMessageStartingWith {
        AssertThatThrownByHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByHasMessageParameters {
        AssertThatThrownByHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message, Object parameters) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByRootCauseHasMessage {
        AssertThatThrownByRootCauseHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).havingRootCause().withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).rootCause().hasMessage(message);
        }
    }

    static final class AssertThatThrownByHasMessage {
        AssertThatThrownByHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByAsInstanceOfThrowable<T extends Throwable> {
        AssertThatThrownByAsInstanceOfThrowable() {
        }

        ThrowableAssertAlternative<T> before(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> exceptionType) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable);
        }

        AbstractThrowableAssert<?, T> after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> exceptionType) {
            return (AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).asInstanceOf(InstanceOfAssertFactories.throwable(exceptionType));
        }
    }

    static final class AssertThatThrownByIOExceptionHasMessageNotContaining {
        AssertThatThrownByIOExceptionHasMessageNotContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessageNotContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessageNotContaining(message);
        }
    }

    static final class AssertThatThrownByIOExceptionHasMessageContaining {
        AssertThatThrownByIOExceptionHasMessageContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessageContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessageContaining(message);
        }
    }

    static final class AssertThatThrownByIOExceptionHasMessageStartingWith {
        AssertThatThrownByIOExceptionHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByIOExceptionHasMessageParameters {
        AssertThatThrownByIOExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByIOExceptionRootCauseHasMessage {
        AssertThatThrownByIOExceptionRootCauseHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).rootCause().hasMessage(message);
        }
    }

    static final class AssertThatThrownByIOExceptionHasMessage {
        AssertThatThrownByIOExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByIOException {
        AssertThatThrownByIOException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class);
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessageNotContaining {
        AssertThatThrownByNullPointerExceptionHasMessageNotContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessageNotContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessageNotContaining(message);
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessageContaining {
        AssertThatThrownByNullPointerExceptionHasMessageContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessageContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessageContaining(message);
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessageStartingWith {
        AssertThatThrownByNullPointerExceptionHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessageParameters {
        AssertThatThrownByNullPointerExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByNullPointerExceptionRootCauseHasMessage {
        AssertThatThrownByNullPointerExceptionRootCauseHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).rootCause().hasMessage(message);
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessage {
        AssertThatThrownByNullPointerExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByNullPointerException {
        AssertThatThrownByNullPointerException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageNotContaining {
        AssertThatThrownByIllegalStateExceptionHasMessageNotContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageNotContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageNotContaining(message);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageContaining {
        AssertThatThrownByIllegalStateExceptionHasMessageContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageContaining(message);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageStartingWith {
        AssertThatThrownByIllegalStateExceptionHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageParameters {
        AssertThatThrownByIllegalStateExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionRootCauseHasMessage {
        AssertThatThrownByIllegalStateExceptionRootCauseHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).rootCause().hasMessage(message);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessage {
        AssertThatThrownByIllegalStateExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByIllegalStateException {
        AssertThatThrownByIllegalStateException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class);
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAny {
        AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAny() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, CharSequence values) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageNotContainingAny(new CharSequence[]{values});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, CharSequence values) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageNotContainingAny(new CharSequence[]{values});
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageContaining {
        AssertThatThrownByIllegalArgumentExceptionHasMessageContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(message);
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith {
        AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageParameters {
        AssertThatThrownByIllegalArgumentExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionRootCauseHasMessage {
        AssertThatThrownByIllegalArgumentExceptionRootCauseHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).havingRootCause().withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).rootCause().hasMessage(message);
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessage {
        AssertThatThrownByIllegalArgumentExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByIllegalArgumentException {
        AssertThatThrownByIllegalArgumentException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class);
        }
    }

    static final class AssertThatThrownByIsInstanceOf<T extends Throwable> {
        AssertThatThrownByIsInstanceOf() {
        }

        void before(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> exceptionType) {
            Refaster.anyOf((Object[])new AbstractObjectAssert[]{(AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).asInstanceOf(InstanceOfAssertFactories.throwable(exceptionType)), (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).asInstanceOf(InstanceOfAssertFactories.type(exceptionType))});
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> exceptionType) {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType);
        }
    }
}

