/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJBooleanRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJBooleanRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJBooleanRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJBooleanRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractBooleanAssertIsEqualToRecipe(), new AbstractBooleanAssertIsNotEqualToRecipe(), new AbstractBooleanAssertIsTrueRecipe(), new AssertThatBooleanIsTrueRecipe(), new AbstractBooleanAssertIsFalseRecipe(), new AssertThatBooleanIsFalseRecipe()});
    }

    @NullMarked
    public static class AbstractBooleanAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AbstractBooleanAssertIsEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBooleanAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isNotEqualTo(!other);\n    }\n    \n    @AfterTemplate\n    AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isEqualTo(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isNotEqualTo(!#{other:any(boolean)})").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isEqualTo(#{other:any(boolean)})").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isNotEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractBooleanAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AbstractBooleanAssertIsNotEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBooleanAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isEqualTo(!other);\n    }\n    \n    @AfterTemplate\n    AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isNotEqualTo(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isEqualTo(!#{other:any(boolean)})").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isNotEqualTo(#{other:any(boolean)})").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractBooleanAssertIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AbstractBooleanAssertIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBooleanAssertIsTrue {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert) {\n        return Refaster.anyOf(boolAssert.isEqualTo(true), boolAssert.isNotEqualTo(false));\n    }\n    \n    @AfterTemplate\n    AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert) {\n        return boolAssert.isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isEqualTo(true)").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isNotEqualTo(false)").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isNotEqualTo(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatBooleanIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AssertThatBooleanIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanIsTrue {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean b) {\n        return assertThat(!b).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean b) {\n        return assertThat(b).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(!#{b:any(boolean)}).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{b:any(boolean)}).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractBooleanAssertIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AbstractBooleanAssertIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBooleanAssertIsFalse {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert) {\n        return Refaster.anyOf(boolAssert.isEqualTo(false), boolAssert.isNotEqualTo(true));\n    }\n    \n    @AfterTemplate\n    AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert) {\n        return boolAssert.isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isEqualTo(false)").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isNotEqualTo(true)").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{boolAssert:any(org.assertj.core.api.AbstractBooleanAssert<?>)}.isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isNotEqualTo(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatBooleanIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AssertThatBooleanIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanIsFalse {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean b) {\n        return assertThat(!b).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean b) {\n        return assertThat(b).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(!#{b:any(boolean)}).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{b:any(boolean)}).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

