/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class MultimapRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`MultimapRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `Multimap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/MultimapRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new MultimapKeySetRecipe(), new MultimapIsEmptyRecipe(), new MultimapSizeRecipe(), new MultimapContainsKeyRecipe(), new MultimapContainsValueRecipe(), new MultimapGetRecipe(), new MultimapKeysStreamRecipe(), new MultimapValuesStreamRecipe()});
    }

    @NullMarked
    public static class MultimapKeySetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MultimapRules.MultimapKeySet`";
        }

        public String getDescription() {
            return "Prefer `Multimap#keySet()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.asMap().keySet()").bindType("java.util.Set<K>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()").bindType("java.util.Set<K>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimap asMap(..)", true), new UsesMethod("java.util.Map keySet(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MultimapIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MultimapRules.MultimapIsEmpty`";
        }

        public String getDescription() {
            return "Prefer `Multimap#isEmpty()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet().isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keys().isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.entries().isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("java.util.Collection isEmpty(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.Multimap entries(..)", true), new UsesMethod("com.google.common.collect.Multimap keySet(..)", true), new UsesMethod("com.google.common.collect.Multimap keys(..)", true), new UsesMethod("com.google.common.collect.Multimap values(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MultimapSizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MultimapRules.MultimapSize`";
        }

        public String getDescription() {
            return "Prefer `Multimap#size()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().size()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.size()").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimap values(..)", true), new UsesMethod("java.util.Collection size(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MultimapContainsKeyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MultimapRules.MultimapContainsKey`";
        }

        public String getDescription() {
            return "Prefer `Multimap#containsKey(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet().contains(#{key:any(T)})").genericTypes(new String[]{"K", "V", "T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(#{key:any(T)})").genericTypes(new String[]{"K", "V", "T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keys().contains(#{key:any(T)})").genericTypes(new String[]{"K", "V", "T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(#{key:any(T)})").genericTypes(new String[]{"K", "V", "T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("java.util.Collection contains(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.Multimap keySet(..)", true), new UsesMethod("com.google.common.collect.Multimap keys(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MultimapContainsValueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MultimapRules.MultimapContainsValue`";
        }

        public String getDescription() {
            return "Prefer `Multimap#containsValue(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().contains(#{value:any(T)})").genericTypes(new String[]{"K", "V", "T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsValue(#{value:any(T)})").genericTypes(new String[]{"K", "V", "T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimap values(..)", true), new UsesMethod("java.util.Collection contains(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MultimapGetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Multimap#get(Object)` over more contrived alternatives";
        }

        public String getDescription() {
            return "<strong>Warning:</strong> this rewrite rule is not completely behavior preserving: the\n original code will yield `null` for unknown keys, while the replacement code will return\n an empty collection for unknown keys.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.asMap().get(#{key:any(K)})").bindType("java.util.Collection<V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.get(#{key:any(K)})").bindType("java.util.Collection<V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.Multimap<K, V>)}).get(#{key:any(K)})").bindType("java.util.Collection<V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Multimaps");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.get(#{key:any(K)})").bindType("java.util.Collection<V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Map get(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.Multimap asMap(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimaps", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimaps asMap(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MultimapKeysStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MultimapRules.MultimapKeysStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily use `Multimap#entries()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.entries().stream().map(java.util.Map.Entry::getKey)").bindType("java.util.stream.Stream<K>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keys().stream()").bindType("java.util.stream.Stream<K>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimap entries(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MultimapValuesStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MultimapRules.MultimapValuesStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily use `Multimap#entries()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.entries().stream().map(java.util.Map.Entry::getValue)").bindType("java.util.stream.Stream<V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().stream()").bindType("java.util.stream.Stream<V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimap entries(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

