/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class SuggestedFixRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`SuggestedFixRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `SuggestedFix`es.\n[Source](https://error-prone.picnic.tech/refasterrules/SuggestedFixRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new SuggestedFixToBuilderRecipe(), new SuggestedFixDeleteRecipe(), new SuggestedFixReplaceTreeRecipe(), new SuggestedFixReplaceStartEndRecipe(), new SuggestedFixReplaceTreeStartEndRecipe(), new SuggestedFixSwapRecipe(), new SuggestedFixPrefixWithRecipe(), new SuggestedFixPostfixWithRecipe()});
    }

    @NullMarked
    public static class SuggestedFixToBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixToBuilder`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#toBuilder()`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().merge(#{fix:any(com.google.errorprone.fixes.SuggestedFix)})").bindType("com.google.errorprone.fixes.SuggestedFix.Builder").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{fix:any(com.google.errorprone.fixes.SuggestedFix)}.toBuilder()").bindType("com.google.errorprone.fixes.SuggestedFix.Builder").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder merge(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SuggestedFixDeleteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixDelete`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#delete(Tree)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().delete(#{tree:any(com.sun.source.tree.Tree)}).build()").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.delete(#{tree:any(com.sun.source.tree.Tree)})").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder delete(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SuggestedFixReplaceTreeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixReplaceTree`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#replace(Tree, String)`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)}).build()").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)})").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SuggestedFixReplaceStartEndRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixReplaceStartEnd`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#replace(int, int, String)`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().replace(#{start:any(int)}, #{end:any(int)}, #{replaceWith:any(java.lang.String)}).build()").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.replace(#{start:any(int)}, #{end:any(int)}, #{replaceWith:any(java.lang.String)})").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SuggestedFixReplaceTreeStartEndRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixReplaceTreeStartEnd`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#replace(Tree, String, int, int)`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)}, #{start:any(int)}, #{end:any(int)}).build()").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)}, #{start:any(int)}, #{end:any(int)})").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SuggestedFixSwapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixSwap`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#swap(Tree, Tree, VisitorState)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().swap(#{tree1:any(com.sun.source.tree.Tree)}, #{tree2:any(com.sun.source.tree.Tree)}, #{state:any(com.google.errorprone.VisitorState)}).build()").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.swap(#{tree1:any(com.sun.source.tree.Tree)}, #{tree2:any(com.sun.source.tree.Tree)}, #{state:any(com.google.errorprone.VisitorState)})").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.VisitorState", Boolean.valueOf(true)), new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder swap(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SuggestedFixPrefixWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixPrefixWith`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#prefixWith(Tree, String)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().prefixWith(#{tree:any(com.sun.source.tree.Tree)}, #{prefix:any(java.lang.String)}).build()").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.prefixWith(#{tree:any(com.sun.source.tree.Tree)}, #{prefix:any(java.lang.String)})").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder prefixWith(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SuggestedFixPostfixWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SuggestedFixRules.SuggestedFixPostfixWith`";
        }

        public String getDescription() {
            return "Prefer `SuggestedFix#postfixWith(Tree, String)`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.builder().postfixWith(#{tree:any(com.sun.source.tree.Tree)}, #{postfix:any(java.lang.String)}).build()").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.fixes.SuggestedFix.postfixWith(#{tree:any(com.sun.source.tree.Tree)}, #{postfix:any(java.lang.String)})").bindType("com.google.errorprone.fixes.SuggestedFix").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder postfixWith(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

