/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SourceCode {
    private static final CharMatcher NON_WHITESPACE_MATCHER = CharMatcher.whitespace().negate();

    private SourceCode() {
    }

    public static String treeToString(Tree tree, VisitorState state) {
        String src = state.getSourceForNode(tree);
        return src != null ? src : tree.toString();
    }

    public static SuggestedFix deleteWithTrailingWhitespace(Tree tree, VisitorState state) {
        CharSequence sourceCode = state.getSourceCode();
        int endPos = state.getEndPosition(tree);
        if (sourceCode == null || endPos == -1) {
            return SuggestedFix.delete((Tree)tree);
        }
        int whitespaceEndPos = NON_WHITESPACE_MATCHER.indexIn(sourceCode, endPos);
        return SuggestedFix.replace((int)((JCDiagnostic.DiagnosticPosition)((Object)tree)).getStartPosition(), (int)(whitespaceEndPos == -1 ? sourceCode.length() : whitespaceEndPos), (String)"");
    }

    public static SuggestedFix unwrapMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        CharSequence sourceCode = state.getSourceCode();
        int startPosition = state.getEndPosition((Tree)tree.getMethodSelect());
        int endPosition = state.getEndPosition((Tree)tree);
        if (sourceCode == null || startPosition == -1 || endPosition == -1) {
            return SourceCode.unwrapMethodInvocationDroppingWhitespaceAndComments(tree, state);
        }
        ImmutableList tokens = ErrorProneTokens.getTokens((String)sourceCode.subSequence(startPosition, endPosition).toString(), (Context)state.context);
        Optional<Integer> leftParenPosition = tokens.stream().findFirst().map(t -> startPosition + t.endPos());
        Optional<Integer> rightParenPosition = Streams.findLast(tokens.stream().filter(t -> t.kind() == Tokens.TokenKind.RPAREN)).map(t -> startPosition + t.pos());
        if (leftParenPosition.isEmpty() || rightParenPosition.isEmpty()) {
            return SourceCode.unwrapMethodInvocationDroppingWhitespaceAndComments(tree, state);
        }
        return SuggestedFix.replace((Tree)tree, (String)sourceCode.subSequence(leftParenPosition.orElseThrow(), rightParenPosition.orElseThrow()).toString());
    }

    @VisibleForTesting
    static SuggestedFix unwrapMethodInvocationDroppingWhitespaceAndComments(MethodInvocationTree tree, VisitorState state) {
        return SuggestedFix.replace((Tree)tree, (String)tree.getArguments().stream().map(arg -> SourceCode.treeToString(arg, state)).collect(Collectors.joining(", ")));
    }
}

