/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.ThrottleItem;
import Acme.Utils;
import Acme.WildcardDictionary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThrottledOutputStream
extends FilterOutputStream {
    private long maxBps;
    private long bytes;
    private long start;
    private byte[] oneByte = new byte[1];

    public static WildcardDictionary parseThrottleFile(String string) throws IOException {
        String string2;
        WildcardDictionary wildcardDictionary = new WildcardDictionary();
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir", "."), file.getName());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(35);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if ((string2 = string2.trim()).length() == 0) continue;
            String[] stringArray = Utils.splitStr(string2);
            if (stringArray.length != 2) {
                throw new IOException("malformed throttle line: " + string2);
            }
            try {
                wildcardDictionary.put(stringArray[0], new ThrottleItem(Long.parseLong(stringArray[1])));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("malformed number in throttle line: " + string2);
            }
        }
        bufferedReader.close();
        return wildcardDictionary;
    }

    public ThrottledOutputStream(OutputStream outputStream, long l) {
        super(outputStream);
        this.maxBps = l;
        this.bytes = 0L;
        this.start = System.currentTimeMillis();
    }

    public void write(int n) throws IOException {
        this.oneByte[0] = (byte)n;
        this.write(this.oneByte, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.bytes += (long)n2;
        long l = Math.max(System.currentTimeMillis() - this.start, 1L);
        long l2 = this.bytes * 1000L / l;
        if (l2 > this.maxBps) {
            long l3 = this.bytes * 1000L / this.maxBps;
            try {
                Thread.sleep(l3 - l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.out.write(byArray, n, n2);
    }
}

