/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.Serve;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import java.util.Map;

public class SelectorAcceptor
implements Serve.Acceptor {
    private ServerSocketChannel channel;
    private Selector selector;
    private Iterator readyItor;

    public Socket accept() throws IOException {
        while (true) {
            if (this.readyItor == null) {
                if (this.selector.select() > 0) {
                    this.readyItor = this.selector.selectedKeys().iterator();
                } else {
                    throw new IOException();
                }
            }
            if (this.readyItor.hasNext()) {
                SelectionKey selectionKey = (SelectionKey)this.readyItor.next();
                this.readyItor.remove();
                if (!selectionKey.isValid() || !selectionKey.isAcceptable()) continue;
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                ServerSocket serverSocket = serverSocketChannel.socket();
                return serverSocket.accept();
            }
            this.readyItor = null;
        }
    }

    public void destroy() throws IOException {
        String string = "";
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            string = string + iOException.toString();
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            string = string + iOException.toString();
        }
        if (string.length() > 0) {
            throw new IOException(string);
        }
    }

    public void init(Map map, Map map2) throws IOException {
        this.selector = Selector.open();
        this.channel = ServerSocketChannel.open();
        this.channel.configureBlocking(false);
        int n = map.get("port") != null ? (Integer)map.get("port") : 8080;
        InetSocketAddress inetSocketAddress = null;
        if (map.get("bind-address") != null) {
            try {
                inetSocketAddress = new InetSocketAddress((String)map.get("bind-address"), n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inetSocketAddress == null) {
            inetSocketAddress = new InetSocketAddress(n);
        }
        this.channel.socket().bind(inetSocketAddress);
        this.channel.register(this.selector, 16);
        if (map2 != null) {
            if (this.channel.socket().isBound()) {
                map2.put("bind-address", this.channel.socket().getInetAddress().getHostName());
            } else {
                map2.put("bind-address", InetAddress.getLocalHost().getHostName());
            }
        }
    }

    public String toString() {
        return "SelectorAcceptor - " + (this.channel == null ? "unset" : "" + this.channel.socket());
    }
}

