/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.filter;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.SerializableString;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.filter.TokenFilter;
import tools.jackson.core.filter.TokenFilterContext;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.JsonParserDelegate;

public class FilteringParserDelegate
extends JsonParserDelegate {
    protected TokenFilter rootFilter;
    protected boolean _allowMultipleMatches;
    protected TokenFilter.Inclusion _inclusion;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;
    protected TokenFilterContext _headContext;
    protected TokenFilterContext _exposedContext;
    protected TokenFilter _itemFilter;
    protected int _matchCount;

    public FilteringParserDelegate(JsonParser p, TokenFilter f, TokenFilter.Inclusion inclusion, boolean allowMultipleMatches) {
        super(p);
        FilteringParserDelegate._checkAsyncParser(p);
        this.initializeFilters(f, inclusion, allowMultipleMatches);
    }

    private static void _checkAsyncParser(JsonParser p) throws IllegalArgumentException {
        if (p.canParseAsync()) {
            throw new IllegalArgumentException(String.format("%s is an asynchronous parser (canParseAsync() == true), which requires explicit permission to be used: to allow use, call constructor with `allowNonBlockingParser` passed as `true`", p.getClass().getSimpleName()));
        }
    }

    public FilteringParserDelegate(JsonParser p, TokenFilter f, TokenFilter.Inclusion inclusion, boolean allowMultipleMatches, boolean allowNonBlockingParser) {
        super(p);
        if (!allowNonBlockingParser) {
            FilteringParserDelegate._checkAsyncParser(p);
        }
        this.initializeFilters(f, inclusion, allowMultipleMatches);
    }

    private void initializeFilters(TokenFilter f, TokenFilter.Inclusion inclusion, boolean allowMultipleMatches) {
        this.rootFilter = f;
        this._itemFilter = f;
        this._headContext = TokenFilterContext.createRootContext(f);
        this._inclusion = inclusion;
        this._allowMultipleMatches = allowMultipleMatches;
    }

    public TokenFilter getFilter() {
        return this.rootFilter;
    }

    public int getMatchCount() {
        return this._matchCount;
    }

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public final int currentTokenId() {
        JsonToken t = this._currToken;
        return t == null ? 0 : t.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int id) {
        JsonToken t = this._currToken;
        if (t == null) {
            return 0 == id;
        }
        return t.id() == id;
    }

    @Override
    public final boolean hasToken(JsonToken t) {
        return this._currToken == t;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public TokenStreamLocation currentLocation() {
        return this.delegate.currentLocation();
    }

    @Override
    public TokenStreamContext streamReadContext() {
        return this._filterContext();
    }

    @Override
    public String currentName() {
        TokenStreamContext ctxt = this._filterContext();
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            TokenStreamContext parent = ctxt.getParent();
            return parent == null ? null : parent.currentName();
        }
        return ctxt.currentName();
    }

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public JsonToken nextToken() throws JacksonException {
        JsonToken t;
        block40: {
            if (!this._allowMultipleMatches && this._currToken != null && this._exposedContext == null && this._currToken.isScalarValue() && !this._headContext.isStartHandled() && this._inclusion == TokenFilter.Inclusion.ONLY_INCLUDE_ALL && this._itemFilter == TokenFilter.INCLUDE_ALL) {
                this._currToken = null;
                return null;
            }
            TokenFilterContext ctxt = this._exposedContext;
            if (ctxt != null) {
                do {
                    if ((t = ctxt.nextTokenToRead()) != null) {
                        this._currToken = t;
                        return t;
                    }
                    if (ctxt == this._headContext) {
                        this._exposedContext = null;
                        if (ctxt.inArray()) {
                            this._currToken = t = this.delegate.currentToken();
                            if (this._currToken == JsonToken.END_ARRAY) {
                                this._headContext = this._headContext.getParent();
                                this._itemFilter = this._headContext.getFilter();
                            }
                            return t;
                        }
                        t = this.delegate.currentToken();
                        if (t == JsonToken.END_OBJECT) {
                            this._headContext = this._headContext.getParent();
                            this._itemFilter = this._headContext.getFilter();
                        }
                        if (t != JsonToken.PROPERTY_NAME) {
                            this._currToken = t;
                            return t;
                        }
                        break block40;
                    }
                    this._exposedContext = ctxt = this._headContext.findChildOf(ctxt);
                } while (ctxt != null);
                throw this._constructReadException("Unexpected problem: chain of filtered context broken, token: " + String.valueOf((Object)t));
            }
        }
        if ((t = this.delegate.nextToken()) == null) {
            this._currToken = t;
            return t;
        }
        switch (t.id()) {
            case -1: {
                throw this._constructReadException("`JsonToken.NOT_AVAILABLE` received: ensure all input is fed to the Parser before use");
            }
            case 3: {
                TokenFilter f = this._itemFilter;
                if (f == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildArrayContext(f, null, true);
                    this._currToken = t;
                    return this._currToken;
                }
                if (f == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if ((f = this._headContext.checkValue(f)) == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if (f != TokenFilter.INCLUDE_ALL) {
                    f = f.filterStartArray();
                }
                this._itemFilter = f;
                if (f == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildArrayContext(f, null, true);
                    this._currToken = t;
                    return this._currToken;
                }
                if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                    this._headContext = this._headContext.createChildArrayContext(f, null, true);
                    this._currToken = t;
                    return this._currToken;
                }
                this._headContext = this._headContext.createChildArrayContext(f, null, false);
                if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH || (t = this._nextTokenWithBuffering(this._headContext)) == null) break;
                this._currToken = t;
                return t;
            }
            case 1: {
                TokenFilter f = this._itemFilter;
                if (f == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildObjectContext(f, null, true);
                    this._currToken = t;
                    return this._currToken;
                }
                if (f == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if ((f = this._headContext.checkValue(f)) == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if (f != TokenFilter.INCLUDE_ALL) {
                    f = f.filterStartObject();
                }
                this._itemFilter = f;
                if (f == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildObjectContext(f, null, true);
                    this._currToken = t;
                    return this._currToken;
                }
                if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                    this._headContext = this._headContext.createChildObjectContext(f, null, true);
                    this._currToken = t;
                    return this._currToken;
                }
                this._headContext = this._headContext.createChildObjectContext(f, null, false);
                if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH || (t = this._nextTokenWithBuffering(this._headContext)) == null) break;
                this._currToken = t;
                return t;
            }
            case 2: 
            case 4: {
                boolean returnEnd = this._headContext.isStartHandled();
                TokenFilter f = this._headContext.getFilter();
                if (f != null && f != TokenFilter.INCLUDE_ALL) {
                    if (t.id() == 4) {
                        f.filterFinishArray();
                    } else {
                        f.filterFinishObject();
                    }
                }
                this._headContext = this._headContext.getParent();
                this._itemFilter = this._headContext.getFilter();
                if (!returnEnd) break;
                this._currToken = t;
                return this._currToken;
            }
            case 5: {
                String name = this.delegate.currentName();
                TokenFilter f = this._headContext.setPropertyName(name);
                if (f == TokenFilter.INCLUDE_ALL) {
                    this._itemFilter = f;
                    this._currToken = t;
                    return this._currToken;
                }
                if (f == null) {
                    this.delegate.nextToken();
                    this.delegate.skipChildren();
                    break;
                }
                if ((f = f.includeProperty(name)) == null) {
                    this.delegate.nextToken();
                    this.delegate.skipChildren();
                    break;
                }
                this._itemFilter = f;
                if (f == TokenFilter.INCLUDE_ALL) {
                    if (this._verifyAllowedMatches()) {
                        if (this._inclusion == TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) {
                            this._currToken = t;
                            return this._currToken;
                        }
                    } else {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                    }
                }
                if (this._inclusion == TokenFilter.Inclusion.ONLY_INCLUDE_ALL || (t = this._nextTokenWithBuffering(this._headContext)) == null) break;
                this._currToken = t;
                return t;
            }
            default: {
                TokenFilter f = this._itemFilter;
                if (f == TokenFilter.INCLUDE_ALL) {
                    this._currToken = t;
                    return this._currToken;
                }
                if (f == null || (f = this._headContext.checkValue(f)) != TokenFilter.INCLUDE_ALL && (f == null || !f.includeValue(this.delegate)) || !this._verifyAllowedMatches()) break;
                this._currToken = t;
                return this._currToken;
            }
        }
        return this._nextToken2();
    }

    protected final JsonToken _nextToken2() throws JacksonException {
        JsonToken t;
        block7: while (true) {
            TokenFilter f;
            if ((t = this.delegate.nextToken()) == null) {
                this._currToken = t;
                return t;
            }
            switch (t.id()) {
                case 3: {
                    f = this._itemFilter;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(f, null, true);
                        this._currToken = t;
                        return this._currToken;
                    }
                    if (f == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((f = this._headContext.checkValue(f)) == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (f != TokenFilter.INCLUDE_ALL) {
                        f = f.filterStartArray();
                    }
                    this._itemFilter = f;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(f, null, true);
                        this._currToken = t;
                        return this._currToken;
                    }
                    if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildArrayContext(f, null, true);
                        this._currToken = t;
                        return this._currToken;
                    }
                    this._headContext = this._headContext.createChildArrayContext(f, null, false);
                    if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH || (t = this._nextTokenWithBuffering(this._headContext)) == null) continue block7;
                    this._currToken = t;
                    return t;
                }
                case 1: {
                    f = this._itemFilter;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(f, null, true);
                        this._currToken = t;
                        return this._currToken;
                    }
                    if (f == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((f = this._headContext.checkValue(f)) == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (f != TokenFilter.INCLUDE_ALL) {
                        f = f.filterStartObject();
                    }
                    this._itemFilter = f;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(f, null, true);
                        this._currToken = t;
                        return this._currToken;
                    }
                    if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildObjectContext(f, null, true);
                        this._currToken = t;
                        return this._currToken;
                    }
                    this._headContext = this._headContext.createChildObjectContext(f, null, false);
                    if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH || (t = this._nextTokenWithBuffering(this._headContext)) == null) continue block7;
                    this._currToken = t;
                    return t;
                }
                case 4: {
                    boolean includeEmpty;
                    boolean returnEnd = this._headContext.isStartHandled();
                    f = this._headContext.getFilter();
                    if (f != null && f != TokenFilter.INCLUDE_ALL) {
                        includeEmpty = f.includeEmptyArray(this._headContext.hasCurrentIndex());
                        f.filterFinishArray();
                        if (includeEmpty) {
                            return this._nextBuffered(this._headContext);
                        }
                    }
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (!returnEnd) continue block7;
                    this._currToken = t;
                    return this._currToken;
                }
                case 2: {
                    boolean includeEmpty;
                    boolean returnEnd = this._headContext.isStartHandled();
                    f = this._headContext.getFilter();
                    if (f != null && f != TokenFilter.INCLUDE_ALL) {
                        includeEmpty = f.includeEmptyObject(this._headContext.hasCurrentName());
                        f.filterFinishObject();
                        if (includeEmpty) {
                            return this._nextBuffered(this._headContext);
                        }
                    }
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (!returnEnd) continue block7;
                    this._currToken = t;
                    return this._currToken;
                }
                case 5: {
                    String name = this.delegate.currentName();
                    f = this._headContext.setPropertyName(name);
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._itemFilter = f;
                        this._currToken = t;
                        return this._currToken;
                    }
                    if (f == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((f = f.includeProperty(name)) == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    this._itemFilter = f;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        if (this._verifyAllowedMatches()) {
                            if (this._inclusion != TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) continue block7;
                            this._currToken = t;
                            return this._currToken;
                        }
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (this._inclusion == TokenFilter.Inclusion.ONLY_INCLUDE_ALL || (t = this._nextTokenWithBuffering(this._headContext)) == null) continue block7;
                    this._currToken = t;
                    return t;
                }
            }
            f = this._itemFilter;
            if (f == TokenFilter.INCLUDE_ALL) {
                this._currToken = t;
                return this._currToken;
            }
            if (f != null && ((f = this._headContext.checkValue(f)) == TokenFilter.INCLUDE_ALL || f != null && f.includeValue(this.delegate)) && this._verifyAllowedMatches()) break;
        }
        this._currToken = t;
        return this._currToken;
    }

    protected final JsonToken _nextTokenWithBuffering(TokenFilterContext buffRoot) throws JacksonException {
        block7: while (true) {
            TokenFilter f;
            JsonToken t;
            if ((t = this.delegate.nextToken()) == null) {
                return t;
            }
            switch (t.id()) {
                case 3: {
                    f = this._headContext.checkValue(this._itemFilter);
                    if (f == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (f != TokenFilter.INCLUDE_ALL) {
                        f = f.filterStartArray();
                    }
                    this._itemFilter = f;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(f, null, true);
                        return this._nextBuffered(buffRoot);
                    }
                    if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildArrayContext(f, null, true);
                        return this._nextBuffered(buffRoot);
                    }
                    this._headContext = this._headContext.createChildArrayContext(f, null, false);
                    continue block7;
                }
                case 1: {
                    f = this._itemFilter;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(f, null, true);
                        return t;
                    }
                    if (f == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((f = this._headContext.checkValue(f)) == null) {
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if (f != TokenFilter.INCLUDE_ALL) {
                        f = f.filterStartObject();
                    }
                    this._itemFilter = f;
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(f, null, true);
                        return this._nextBuffered(buffRoot);
                    }
                    if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
                        this._headContext = this._headContext.createChildArrayContext(f, null, true);
                        return this._nextBuffered(buffRoot);
                    }
                    this._headContext = this._headContext.createChildObjectContext(f, null, false);
                    continue block7;
                }
                case 4: {
                    f = this._headContext.getFilter();
                    if (f != null && f != TokenFilter.INCLUDE_ALL) {
                        boolean includeEmpty = f.includeEmptyArray(this._headContext.hasCurrentIndex());
                        f.filterFinishArray();
                        if (includeEmpty) {
                            return this._nextBuffered(buffRoot);
                        }
                    }
                    boolean gotEnd = this._headContext == buffRoot;
                    boolean returnEnd = gotEnd && this._headContext.isStartHandled();
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (returnEnd) {
                        return t;
                    }
                    if (!gotEnd) continue block7;
                    return null;
                }
                case 2: {
                    f = this._headContext.getFilter();
                    if (f != null && f != TokenFilter.INCLUDE_ALL) {
                        boolean includeEmpty = f.includeEmptyObject(this._headContext.hasCurrentName());
                        f.filterFinishObject();
                        if (includeEmpty) {
                            this._headContext._currentName = this._headContext._parent == null ? null : this._headContext._parent._currentName;
                            this._headContext._needToHandleName = false;
                            return this._nextBuffered(buffRoot);
                        }
                    }
                    boolean gotEnd = this._headContext == buffRoot;
                    boolean returnEnd = gotEnd && this._headContext.isStartHandled();
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (returnEnd) {
                        return t;
                    }
                    if (!gotEnd) continue block7;
                    return null;
                }
                case 5: {
                    String name = this.delegate.currentName();
                    f = this._headContext.setPropertyName(name);
                    if (f == TokenFilter.INCLUDE_ALL) {
                        this._itemFilter = f;
                        return this._nextBuffered(buffRoot);
                    }
                    if (f == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    if ((f = f.includeProperty(name)) == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block7;
                    }
                    this._itemFilter = f;
                    if (f != TokenFilter.INCLUDE_ALL) continue block7;
                    if (this._verifyAllowedMatches()) {
                        return this._nextBuffered(buffRoot);
                    }
                    this._itemFilter = this._headContext.setPropertyName(name);
                    continue block7;
                }
            }
            f = this._itemFilter;
            if (f == TokenFilter.INCLUDE_ALL) {
                return this._nextBuffered(buffRoot);
            }
            if (f != null && ((f = this._headContext.checkValue(f)) == TokenFilter.INCLUDE_ALL || f != null && f.includeValue(this.delegate)) && this._verifyAllowedMatches()) break;
        }
        return this._nextBuffered(buffRoot);
    }

    private JsonToken _nextBuffered(TokenFilterContext buffRoot) throws JacksonException {
        this._exposedContext = buffRoot;
        TokenFilterContext ctxt = buffRoot;
        JsonToken t = ctxt.nextTokenToRead();
        if (t != null) {
            return t;
        }
        do {
            if (ctxt == this._headContext) {
                throw this._constructReadException("Internal error: failed to locate expected buffered tokens");
            }
            this._exposedContext = ctxt = this._exposedContext.findChildOf(ctxt);
            if (ctxt != null) continue;
            throw this._constructReadException("Unexpected problem: chain of filtered context broken");
        } while ((t = this._exposedContext.nextTokenToRead()) == null);
        return t;
    }

    private final boolean _verifyAllowedMatches() throws JacksonException {
        if (this._matchCount == 0 || this._allowMultipleMatches) {
            ++this._matchCount;
            return true;
        }
        return false;
    }

    @Override
    public JsonToken nextValue() throws JacksonException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.PROPERTY_NAME) {
            t = this.nextToken();
        }
        return t;
    }

    @Override
    public JsonParser skipChildren() throws JacksonException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = this.nextToken()) == null) {
                return this;
            }
            if (t.isStructStart()) {
                ++open;
                continue;
            }
            if (t.isStructEnd() && --open == 0) break;
        }
        return this;
    }

    @Override
    public String getString() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName();
        }
        return this.delegate.getString();
    }

    @Override
    public boolean hasStringCharacters() {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return false;
        }
        return this.delegate.hasStringCharacters();
    }

    @Override
    public char[] getStringCharacters() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName().toCharArray();
        }
        return this.delegate.getStringCharacters();
    }

    @Override
    public int getStringLength() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName().length();
        }
        return this.delegate.getStringLength();
    }

    @Override
    public int getStringOffset() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return 0;
        }
        return this.delegate.getStringOffset();
    }

    @Override
    public String getValueAsString() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName();
        }
        return this.delegate.getValueAsString();
    }

    @Override
    public String getValueAsString(String defaultValue) throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName();
        }
        return this.delegate.getValueAsString(defaultValue);
    }

    @Override
    public String nextName() throws JacksonException {
        return this.nextToken() == JsonToken.PROPERTY_NAME ? this.currentName() : null;
    }

    @Override
    public boolean nextName(SerializableString str) throws JacksonException {
        return this.nextToken() == JsonToken.PROPERTY_NAME && str.getValue().equals(this.currentName());
    }

    @Override
    public int nextNameMatch(PropertyNameMatcher matcher) throws JacksonException {
        String str = this.nextName();
        if (str != null) {
            return matcher.matchName(str);
        }
        if (this.hasToken(JsonToken.END_OBJECT)) {
            return -1;
        }
        return -3;
    }

    protected TokenStreamContext _filterContext() {
        if (this._exposedContext != null) {
            return this._exposedContext;
        }
        return this._headContext;
    }
}

